/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.BSHType;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

class BSHPrimarySuffix
extends SimpleNode {
    public static final int CLASS = 0;
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int PROPERTY = 3;
    public int operation;
    Object index;
    public String field;

    BSHPrimarySuffix(int n) {
        super(n);
    }

    public Object doSuffix(Object object, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.operation == 0) {
            if (object instanceof BSHType) {
                NameSpace nameSpace = callStack.top();
                return ((BSHType)object).getType(nameSpace);
            }
            throw new EvalError("Attemp to invoke .class on non class.", this);
        }
        if (object instanceof SimpleNode) {
            object = object instanceof BSHAmbiguousName ? ((BSHAmbiguousName)object).toObject(callStack, interpreter) : ((SimpleNode)object).eval(callStack, interpreter);
        }
        try {
            switch (this.operation) {
                case 1: {
                    return this.doIndex(object, callStack, interpreter);
                }
                case 2: {
                    return this.doName(object, callStack, interpreter);
                }
                case 3: {
                    return this.doProperty(object, callStack, interpreter);
                }
            }
            throw new InterpreterError("LHS suffix");
        }
        catch (ReflectError reflectError) {
            throw new EvalError("reflection error: " + reflectError, this);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TargetError("target exception", invocationTargetException.getTargetException(), this, true);
        }
    }

    private Object doName(Object object, CallStack callStack, Interpreter interpreter) throws EvalError, ReflectError, InvocationTargetException {
        if (this.field.equals("length") && object.getClass().isArray()) {
            return new Primitive(Array.getLength(object));
        }
        if (this.jjtGetNumChildren() == 0) {
            return Reflect.getObjectField(object, this.field);
        }
        Object[] objectArray = ((BSHArguments)this.jjtGetChild(0)).getArguments(callStack, interpreter);
        try {
            return Reflect.invokeObjectMethod(interpreter, object, this.field, objectArray, this);
        }
        catch (EvalError evalError) {
            throw new EvalError(evalError.getMessage(), this);
        }
    }

    static int getIndexAux(Object object, CallStack callStack, Interpreter interpreter, SimpleNode simpleNode) throws EvalError {
        int n;
        if (!object.getClass().isArray()) {
            throw new EvalError("Not an array", simpleNode);
        }
        try {
            Object object2 = ((SimpleNode)simpleNode.jjtGetChild(0)).eval(callStack, interpreter);
            if (!(object2 instanceof Primitive)) {
                object2 = NameSpace.getAssignableForm(object2, Integer.TYPE);
            }
            n = ((Primitive)object2).intValue();
        }
        catch (EvalError evalError) {
            Interpreter.debug("doIndex: " + evalError);
            evalError.reThrow("You can only index arrays by integer types", simpleNode);
            throw new Error("can't get here");
        }
        return n;
    }

    private Object doIndex(Object object, CallStack callStack, Interpreter interpreter) throws EvalError, ReflectError {
        int n = BSHPrimarySuffix.getIndexAux(object, callStack, interpreter, this);
        return Reflect.getIndex(object, n);
    }

    private Object doProperty(Object object, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (object == Primitive.VOID) {
            throw new EvalError("Attempt to access property on undefined variable or class name", this);
        }
        if (object instanceof Primitive) {
            throw new EvalError("Attempt to access property on a primitive", this);
        }
        Object object2 = ((SimpleNode)this.jjtGetChild(0)).eval(callStack, interpreter);
        if (!(object2 instanceof String)) {
            throw new EvalError("Property expression must be a String or identifier.", this);
        }
        if (object instanceof Hashtable) {
            Object object3 = ((Hashtable)object).get((String)object2);
            if (object3 == null) {
                object3 = Primitive.NULL;
            }
            return object3;
        }
        try {
            return Reflect.getObjectProperty(object, (String)object2);
        }
        catch (ReflectError reflectError) {
            Interpreter.debug(reflectError.toString());
            throw new EvalError("No such property: " + object2, this);
        }
    }
}

