#ifndef AVIFILE_CONFIGFILE_H
#define AVIFILE_CONFIGFILE_H

#include "default.h"
#include "avm_stl.h"
struct ConfigEntry
{
    enum Types
    {
	Int,
	Float,
	Binary
    };
    avm::string appname;
    avm::string valname;
    int length;
    Types type;
    union
    {
	int i;
	float f;
	char *b;
    };

    ConfigEntry();
    ~ConfigEntry();
    ConfigEntry(const ConfigEntry& e);
    ConfigEntry& operator= (const ConfigEntry& e);
};

struct ConfigFile {
    avm::string filename;
    avm::vector<ConfigEntry> entries;
    bool dirty;
    bool opened;

    ConfigFile();
    ~ConfigFile();
    void Open(const avm::string& fn);
    void Close();
    ConfigEntry *Find(const avm::string& appname, const avm::string& valname);
    void push_back(const ConfigEntry& e);
};

/**
 * This namespace provides means to conveniently store and retrieve app-specific
 * data from the registry ( file ~/.registry ).
 *
 * Function names are self-explanatory. Do not include spaces in first two
 * arguments to avoid collisions. 'def_value' arguments correspond to
 * values which will be returned if needed record is not found in the
 * registry or if registry access fails for some reason.
 *
 * You can use this namespace without avifile library, but you should
 * define Registry::sConfigName & config in some place where linker will
 * find it.
 */

#define REGISTRY_BEGIN_NAMESPACE    namespace Registry {
#define REGISTRY_END_NAMESPACE      };

/* declaration */

REGISTRY_BEGIN_NAMESPACE

//extern std::string sConfigName;
//extern ConfigFile config;

int WriteInt(avm::string appname, avm::string valname, int value);
int ReadInt(avm::string appname, avm::string valname, int def_value);
int WriteFloat(avm::string appname, avm::string valname, float value);
float ReadFloat(avm::string appname, avm::string valname, float def_value);
int WriteString(avm::string appname, avm::string valname, avm::string value);
avm::string ReadString(avm::string appname, avm::string valname, avm::string def_value);
int WriteData(avm::string appname, avm::string valname, const void *data, int size);
int ReadData(avm::string appname, avm::string valname, void *data, int size);

REGISTRY_END_NAMESPACE

#endif
