#ifndef AVIFILE_PLAYERWIDGET_H
#define AVIFILE_PLAYERWIDGET_H
/**
    Implement this interface if you wish to manually handle
    playback-controlling events that come from movie window
    of IAviPlayer2 object. For example, you might want
    some kind of configuration popup menu ( implemented
    with your favorite widget toolkit ) to show up when
    user right-clicks in the movie window. You'll have to
    put the code for creation of popup menu into implementation
    of PW_menu_slot().
    Members of this interface will be called from within movie
    window event thread.
**/    
class PlayerWidget
{
public:
    virtual ~PlayerWidget() {}
    /* Unused */
    virtual void PW_showconf_func() =0;
    /* Middle button click.
     Default action: switch zoom 0.5x->1x->2x
    */
    virtual void PW_middle_button() =0;
    /* Key 'x' pressed.
     Default action: stop playback.
    */
    virtual void PW_stop_func() =0;
    /* Key 'c' pressed.
     Default action: pause/resume playback.
     */     
    virtual void PW_pause_func() =0;
    /* Key 'v' pressed.
     Default action: start playback after stop or pause.
     */
    virtual void PW_play_func() =0;
    /* Key 'q' pressed.
     Default action: do nothing.
     */
    virtual void PW_quit_func() =0;
    /* Right button click.
     Default action: do nothing.
     */
    virtual void PW_menu_slot() =0;
    /* 'Esc' or 'Alt+Enter' pressed.
     Default action: toggle fullscreen mode.
     */
    virtual void PW_fullscreen() =0;
    /* Movie window is resized with mouse.
     Default action: resize picture.
     */
    virtual void PW_maximize_func() =0;

    virtual void PW_resize(int w, int h) =0;
    virtual void PW_refresh()  =0;

    virtual void PW_key_func(int sym, int mod) =0;
};

#endif // AVIFILE_PLAYERWIDGET_H
