#ifndef AVIFILE_SUBTITLE_H
#define AVIFILE_SUBTITLE_H

#define SUBTITLE_MAX_LINES 5

#if defined(__cplusplus)
extern "C" {
#endif

typedef enum
{
    SUBTITLE_UNSELECTED,
    SUBTITLE_MICRODVD,
    SUBTITLE_SUBRIP,
    SUBTITLE_VPLAYER,
    SUBTITLE_AQT,
    SUBTITLE_SAMI,
    SUBTITLE_SUBVIEVER,
    SUBTITLE_MPSUB,		/* say hallo to Gabuciono */
} subtitle_type;

typedef struct
{
    int lines;
    unsigned int start;         /* time in 1/1000s */
    unsigned int end;
    char* line[SUBTITLE_MAX_LINES];
} subtitle_line_t;

typedef struct
{
    /* should not be accessed directly - use functions! */
    char* filename;
    subtitle_type type;
    int allocated;
    int count;
    int frame_based; /* if subtitles use frame number */
    double fps;
    /* mutex for write will be added */
    void* mutex; // prevents us to use const (no mutable)
    subtitle_line_t* subtitle;
} subtitles_t;

/**
 * if st == NULL - new is created - otherwice *st just updated
 */
subtitles_t* subtitle_open(subtitles_t* st, const char* filename);
void subtitle_close(subtitles_t*);
void subtitle_set_fps(subtitles_t*, double fps);
/**
 * number of lines in subtitle array
 */
int subtitle_get_lines(subtitles_t*);
/**
 * type of subtitles
 */
subtitle_type subtitle_get_type(subtitles_t*);
/**
 * copies subtitle into given subtitle_line_t pointer
 * it will check first if the line isn't already copied
 * returns true if subtitle is found
 */
int subtitle_get(subtitle_line_t*, subtitles_t*, double timepos);
/**
 * check if two subtitle lines aren't the same
 * checking linecount & start,end pos (text is not being compared!)
 */
int subtitle_line_equals(const subtitle_line_t*, const subtitle_line_t*);
/**
 * creates new empty subtitle line
 */
subtitle_line_t* subtitle_line_new(void);
/**
 * duplicates one subtitle line
 */
subtitle_line_t* subtitle_line_copy(const subtitle_line_t*);
/**
 * free allocated subtitle line (obtained with subtitle_line_copy)
 */
void subtitle_line_free(subtitle_line_t*);

/*
 will be implemented later

 write
 update
 insert
 delete
 */

#if defined(__cplusplus)
}
#endif

#endif
