#ifndef AVIFILE_IVIDEOENCODER_H
#define AVIFILE_IVIDEOENCODER_H

/********************************************************

	Video encoder interface
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/

#include "infotypes.h"
class CImage;

/**
 *
 *    Video encoder class.
 *
 *  Usage:
 *	
 *   Create encoder object. Optionally
 * set quality and key-frame frequency. Call Start().
 * Call GetOutputSize() to identify maximum possible
 * size of compressed frame. Allocate buffer of this size.
 * Pass it as 'dest' in calls to EncodeFrame(). At the end
 * call Stop(). Do not forget to delete the object.
 *
 *  Some codec DLLs have be controlled by special codec-specific
 * parameters. In Windows you can set them from codec configuration 
 * dialog, but since we are completely GUI-independent, we'll need
 * an internal method to set them. Currently it is done by calling
 * static func SetExtendedAttr(), which takes FOURCC of codec, 
 * name of parameter and its integer value. Complete list of
 * supported attributes can be retrieved as GetCodecInfo().encoder_info.
 * SetExtendedAttr() should be called before object creation,
 * because values for these attributes are typically stored in 
 * registry and read by codec during object creation.
 *
 */
class IVideoEncoder
{
protected:
    CodecInfo record;
public:
    enum CAPS
    {
	CAP_NONE = 0,
	CAP_YUY2 = 1,
	CAP_YV12 = 2,
	CAP_IYUV = 4,
	CAP_UYVY = 8,
	CAP_YVYU = 16,
	CAP_I420 = 32
    };

    IVideoEncoder(const CodecInfo& info) : record(info) {}
    virtual ~IVideoEncoder(){}
    virtual int EncodeFrame(const CImage* src, void* dest, int* is_keyframe,
			    uint_t* size, int* lpckid = 0)	=0;
    virtual const CodecInfo& GetCodecInfo() const { return record; }
    virtual const BITMAPINFOHEADER& GetOutputFormat() const	=0;
    virtual int GetOutputSize() const				=0;

    virtual int Start()						=0;
    virtual int Stop()						=0;

    virtual int GetQuality() const		{ return -1; }
    virtual int SetQuality(int quality)		{ return -1; }
    virtual int GetKeyFrame() const		{ return 1; }
    virtual int SetKeyFrame(int frequency)	{ return -1; }

    /* just for backward compatibility */
    int QueryOutputSize() const { return GetOutputSize(); };
    const BITMAPINFOHEADER& QueryOutputFormat() const { return GetOutputFormat(); }
};

#endif // AVIFILE_IVIDEOENCODER_H
