/******************************************************************
*
*	CyberVRML97 for C++
*
*	Copyright (C) Satoshi Konno 1996-2000
*
*	File:	TextureNode.h
*
******************************************************************/

#ifndef _TEXTURENODE_H_
#define _TEXTURENODE_H_

#include "vrmlfields.h"
#include "Node.h"
#include "FileImage.h"

#ifdef SUPPORT_OPENGL
#define	textureNamePrivateFieldString			"oglTextureName"
#define	hasTransparencyColorPrivateFieldString	"hasTransparencyColor"
#endif

class TextureNode : public Node {

public:

	TextureNode();
	~TextureNode();

	////////////////////////////////////////////////
	//	Virtual Methods
	////////////////////////////////////////////////

	virtual int getWidth() {
		return 0;
	}

	virtual int getHeight() {
		return 0;
	}

	virtual RGBAColor32	*getImage() {
		return NULL;
	}

#ifdef SUPPORT_OPENGL

	////////////////////////////////////////////////
	//	TextureName
	////////////////////////////////////////////////

	void setTextureName(unsigned int n) {
		SFInt32 *texName = (SFInt32 *)getPrivateField(textureNamePrivateFieldString);
		texName->setValue((int)n);
	}

	unsigned int getTextureName() {
		SFInt32 *texName = (SFInt32 *)getPrivateField(textureNamePrivateFieldString);
		return (unsigned int)texName->getValue();
	} 

	////////////////////////////////////////////////
	//	TextureName
	////////////////////////////////////////////////

	void setHasTransparencyColor(bool value) {
		SFBool *transCol = (SFBool *)getPrivateField(hasTransparencyColorPrivateFieldString);
		transCol->setValue(value);
	}

	bool hasTransparencyColor() {
		SFBool *transCol = (SFBool *)getPrivateField(hasTransparencyColorPrivateFieldString);
		return transCol->getValue();
	} 

#endif
};

#ifdef SUPPORT_OPENGL
int GetOpenGLTextureSize(int size);
#endif

#endif

