/* clipplot.c -- May 29, 2002 */

#include "epix.h"

double f(double t)
{
  return 2*t*(1-t)*(1-t);
}

double g(double t)
{
  return 1/(1-t*t);
}

main() {

  bounding_box(P(-2,-4), P(2,4));
  picture(P(200,200));
  unitlength("1pt");
  offset(P(80, -40));

  begin();

  // Vertical asymptotes
  dashed;
  line(P(-1, y_min), P(-1, y_max));
  line(P( 1, y_min), P( 1, y_max));
  solid;

  // Axes
  h_axis(P(x_min, 0), P(x_max, 0), 8);
  v_axis(P(0, y_min), P(0, y_max), 8);

  h_axis_labels(P(x_min, 0), P(x_max, 0), 4, P(-1, 2), tl);
  v_axis_labels(P(0, y_min), P(0, y_max), 4, P(-1, 2), lt);

  // Graphs
  clipplot(f, x_min, x_max, 40);
  bold;
  clipplot(g, x_min, x_max, 80);

  end();
}

