/* contour.c -- March 29, 2002 */
#include "epix.h"

double pi=M_PI, theta=1;
double Rad=4.5; // outer radius
double rad=0.5; // inner radius
double D=0.125;  // half-width of slit

main() 
{
  bounding_box(P(-5, -5), P(5,5));
  picture(P(160, 160));
  unitlength("0.35mm");
  offset(P(100,-50));

  begin();

  //  boldarrow(P(0,0), P(1.5*x_max,0));
  spot(P(0,0)); 

  // Circular arcs
  arc(P(0,0), Rad, asin(D/Rad), 2*M_PI-asin(D/Rad));
  arc(P(0,0), rad, asin(D/rad), 2*M_PI-asin(D/rad));

  // Slit
  line(P(rad*cos(asin(D/rad)),  D), P(Rad*cos(asin(D/Rad)),  D));
  line(P(rad*cos(asin(D/rad)), -D), P(Rad*cos(asin(D/Rad)), -D));

  // Arrows
  arrow(P(  Rad/4,  rad), P(3*Rad/4,  rad));
  arrow(P(3*Rad/4, -rad), P(  Rad/4, -rad));

  arc_arrow(P(0,0), 0.9*Rad, pi-theta, pi+theta);

  label(P(Rad,D), P(2,4), "$R\\to\\infty$", tr);
  label(P(0,rad), P(0,4), "$\\delta\\to0$", tl);
  label(polar(Rad, M_PI_4), P(0,0), "$\\gamma$", tr);

  end();
}
