/* flow-plot.cc -- July 27, 2002 */
#include "epix.h"
pair F(double s, double t)
{
  pair point = P(s,t);
  return (1/(0.01 + raw_len(point)))*J(point);
}
 
pair curve1(double t)
{
  return P(0.4,0)+polar(0.05, 2*M_PI*t);
}
pair curve2(double t)
{
  return P(0.6,0)+polar(0.05, 2*M_PI*t);
}
pair curve3(double t)
{
  return P(0.8,0)+polar(0.05, 2*M_PI*t);
}
 
triple color(double t)
{
  return P(t, t*(1-t), 1-t);
}

main() {
  unitlength("0.01in");
  bounding_box(P(-1,-1), P(1,1));
  picture(P(550,550));
 
  begin();
 
  bold;
  flow_plot(F, curve1, color, 3, 16, 80);
  flow_plot(F, curve2, color, 3, 16, 60);                                  
  flow_plot(F, curve3, color, 3, 16, 40);                                  

  end();
}
