/* 
 * koch.c -- Simple fractal "curve" generation. 
 *   See arcana.h for details on usage. 
 *   Examples to try:
 *
 *     const int koch[] = {6, 4, 0, 1, -1, 0}; // Koch snowflake
 *     const int zig_zag[] = {6, 6, 0, 1, -1, -1, 1, 0};
 *
 * May 29, 2002
 */

#include "epix.h"

const int koch_seed[] = {6, 4, 0, 1, -1, 0};

main() 
{
  bounding_box(P(-1,-1), P(1, 1));
  picture(P(75, 75));
  unitlength("1pt");

  for (int i=1; i <= 5; ++i)
    {
      begin();   
      
      fractal(cis(5*M_PI/6), cis(  M_PI/6), i, koch_seed);
      fractal(cis(  M_PI/6), cis( -M_PI_2), i, koch_seed);
      fractal(cis( -M_PI_2), cis(5*M_PI/6), i, koch_seed);

      if (i==1)
        {
          bold;
          red;
          fractal(cis(5*M_PI/6), cis(M_PI/6), i, koch_seed);
          black;
          end_bold;
        }
      end();
    }
}

