/* slopefield.c -- March 29, 2002
 *
 * Slope field and ode plotting
 */

#include "epix.h"
pair F(double s, double t)
{
  pair temp = P(s,t);
  return (P(0.1,0.025)&temp) + (1/(0.01+s*s+t*t))*J(temp);
}

main() 
{
  unitlength("1pt");
  bounding_box(P(-4, -3), P(2,2));
  picture(P(234, 195));
  offset(P(120, -20));

  begin();

  dart_field(F, P(x_min, y_min), P(x_max, y_max), 4*x_size, 4*y_size);

  bold;
  for (int i=0; i<7; ++i)
    {
      rgb(0.25 - 0.05*i, 1 - 0.1*i, 0.2*i);
      ode_plot(F, P(-0.9-0.025*i,0), 20, 200);
    }
  end();
}

