/* sphere.c, March 28, 2002  */
#include "epix.h"

static double zero (double t) {return 0;}
triple phi1(double t)
{
  return P(sin(t), cos(t), t);
}
triple phi2(double t)
{
  return P(-cos(t), sin(t), t);
}

main() 
{
  bounding_box(P(-1, -1), P(1,1));
  picture(P(160, 160));
  unitlength("1.25pt");
  viewpoint(1.5, 2, 1);

  offset(P(100, -35));

  begin();

  ellipse(P(0,0), P(1,1));

  dotted;
  backplot_R(cos, sin, zero, 0, 2*M_PI, 60);
  backplot_R(zero, cos, sin, 0, 2*M_PI, 60);
  backplot_R(sin, zero, cos, 0, 2*M_PI, 60);

  solid;
  frontplot_R(cos, sin, zero, 0, 2*M_PI, 60);
  frontplot_R(zero, cos, sin, 0, 2*M_PI, 60);
  frontplot_R(sin, zero, cos, 0, 2*M_PI, 60);

  red;
  pen(0.15);
  dashed;
  backplot_R(phi1, -4*M_PI, 6*M_PI, 240);
  backplot_R(phi2, -4*M_PI, 6*M_PI, 240);

  bold;
  solid;
  frontplot_R(phi1, -4*M_PI, 6*M_PI, 240);
  frontplot_R(phi2, -4*M_PI, 6*M_PI, 240);

  end();
}
