/* stereo-left.c, November 25, 2001 
 *
 * Twisted cubic and projections
 */

#include "epix.h"

double   u1(double t) {return t;}
double   u2(double t) {return t*t;}
double   u3(double t) {return t*t*t;}
double zero(double t) {return 0;}

int N=60;

main() 
{
  int i;
  double t;

  unitlength("1pt");
  bounding_box(P(-1,-1), P(1,1));
  picture(P(150,150));
  offset(P(-20,0));

  viewpoint(1, 2, 0.5);

  begin();

  // coordinate axes
  boldarrow(V(-1,0,0), V(1,0,0));
  boldarrow(V(0,0,-1), V(0,0,1));

  bold;
  blue;
  plot(u1, zero, u3, -1, 1, N);
  for (i=0; i<=20; ++i)
    {
      t = -1 + i/10.0;
      line(V(u1(t), 0, u3(t)), V(u1(t), u2(t), u3(t)));
    }

  label(V(1,0,1), P(2,2), "$x$-$z$ plane");

  red;
  plot(zero, u2, u3, -1, 1, N);
  for (i=0; i<=20; ++i)
    {
      t = -1 + i/10.0;
      line(V(0, u2(t), u3(t)), V(u1(t), u2(t), u3(t)));
    }

  label(V(0,1,1), P(2,2), "$y$-$z$ plane");

  black;
  boldarrow(V(0,0,0), V(0,1,0));

  magenta;
  plot(u1, u2, zero, -1, 1, N);
  for (i=0; i<=20; ++i)
    {
      t = -1 + i/10.0;
      line(V(u1(t), u2(t), 0), V(u1(t), u2(t), u3(t)));
    }

  label(V(1,1,0), P(-45,-12), "$x$-$y$ plane");
  black;

  /* The cubic */
  plot(u1, u2, u3, -1, 1, N);

  end();
}

