/* uppersum.c -- Upper sums for the integral of sin.
 *
 * March 29, 2002
 */

#include "epix.h"
#define N 12.0 // Number of rectangles
#define f sin  // gather references to integrand

main() 
{
  picture(P(300, 100));
  bounding_box(P(0,0), P(3,1));
  unitlength("0.01in");
  offset(P(100,-150));

  begin();

  double dx = x_size/N;

  for(int i=0; i < N; ++i)
    {
      double ai=x_min + i*dx;
      double bi=x_min + (i+1)*dx;

      rect(P(ai, 0), P(bi, sup(f, ai, bi)));
    }

  h_axis(P(x_min, y_min), P(x_max, y_min), x_size);
  v_axis(P(x_min, y_min), P(x_min, y_max), 2*y_size);

  h_axis_labels(P(x_min, 0), P(x_max, 0), x_size, P(0,-4), b);
  label(P(x_max, f(x_max)), P(4,0), "$y=\\sin x$", r);

  bold;
  blue;
  plot(f, x_min, x_max, 40);

  end();
}

