/* 
 * wheel.c -- Animation frames (rolling wheel)
 *
 * June 6, 2002
 */

#include "epix.h"

pair F(double t, double r)
{
  return P(t,0) - r*P(sin(t), cos(t));
}

main() 
{
  double dt = 5*M_PI/11;
  double t = 0;

  picture(P(420, 120));
  bounding_box(P(0,-1), P(7,1));
  unitlength("0.005in");
  offset(P(-120,0));

  for(int i=0; i < 9; ++i)
    {
      t += dt;
      begin(); // Entire picture inside loop body

      line(P(x_min - 2, y_min), P(x_max + 6, y_min)); // the ground
      
      ellipse(P(t,0), P(1,1)); // the wheel

      /* the paths */
      bold;
      for (int j=0; j < 6; ++j)
	{
	  rgb(1-0.125*j, 0.125*j, 0.5+0.25*j);
	  sliceplot2(F, 0, t, 0.2*j, (int) ceil(1+10*t));
	}

      /* the spoke */
      green;
      line(P(t,0), F(t,1));

      end();
    
      /* figure separator and vertical space */
      printf("\n\\vspace*{3ex}\n%%%%");
    }
}

