/* calculus.c -- May 29, 2002 */
#include "epix.h"
double MAX=2*M_PI;
double f(double t)
{
  return t*sin(t);
}

main() {

  unitlength("1pt");
  picture(P(240, 120));
  bounding_box(P(-MAX,-MAX), P(MAX,MAX));
  offset(P(50, 0));

  begin();

  // Coordinate axes and labels
  h_axis(P(x_min,0), P(x_max,0), 8);
  v_axis(P(0,y_min), P(0,y_max), 4);

  label(P(0,y_max), P(-2,0), "$\\phantom{-}2\\pi$", l);
  label(P(0,y_min), P(-2,0), "$-2\\pi$", l);

  label(P(x_min,0), P(-4,2), "$-2\\pi$", t);
  label(P(x_max,0), P( 0,2), "$2\\pi$", t);

  bold;
  plot(f, x_min, x_max, 90);
  green;
  plot_deriv(f, x_min, x_max, 90);

  /* Definite integral from x=0 */
  blue;
  plot_int(f, 0, x_min, x_max, 90);

  end();
}
