/* demoivre.c -- July 22, 2001 */

#include "epix.h"
int n=24;

main()
{
  pair power = e_1; // (1,0)
  pair alpha = e_1 + (M_PI/n)*e_2;

  bounding_box(P(-1.5,0), P(1,1.25));
  picture(P(200,100));
  unitlength("1pt");
  offset(P(75,0));

  begin();
  
  for(int i=0; i<n; ++i)
    {
      line(P(0,0), alpha*power); // draw two sides
      line(power, alpha*power);  // of triangle
      power *= alpha;            // and increment power
    }

  label(alpha, P(2,0), "$\\alpha=1+\\frac{i\\pi}{n}$", r);
  label(power, P(-1,0), "$\\alpha^n$", l);

  red;
  bold;
  triangle(P(0, 0), e_1, alpha);

  end();
}

