/* denom.c -- March 28, 2002 */
#include "epix.h"

#define N 20

main() 
{
  unitlength("0.0125in");
  bounding_box(P(-2,0), P(2,1));
  picture(P(400,100));

  begin();   

  h_axis(P(x_min, 0), P(x_max, 0), 2*x_size);
  v_axis(P(0, 0), P(0, y_max), 2);

  h_axis_labels(P(x_min, 0), P(x_max, 0), x_size, P(-12, -12));

  for (int i=1; i< N; ++i) 
    for (int j=i*x_min; j <= i*x_max; ++j) 
      if (gcd(i, j) == 1) 
	marker(P(((double)j)/i, 1.0/i), DOT);

  end();
}

