/* levelset.c -- level sets */
#include "epix.h"
#define MAX 3

pair F1(double t, double r)
{
  return r*P(sinh(t), cosh(t));
}
pair F2(double t, double r)
{
  return r*P(cosh(t), sinh(t));
}

main()
{
  int i;

  bounding_box(P(-(MAX),-(MAX)), P((MAX), (MAX)));
  unitlength("0.625in");
  picture(P(4,4));
  offset(P(3,-1));

  begin();

  bold;
  rgb(0.5,0.5,1);
  line(P(x_min, y_min), P(x_max, y_max));
  line(P(x_min, y_max), P(x_max, y_min));

  for (i=1; i <= (MAX)*(MAX); ++i) 
    {
      double t0 = acosh((MAX)/sqrt(i));
      double D = i*i/pow(MAX, 4); //((MAX)*(MAX));

      rgb(0.5+0.75*D, 0.5-0.25*D, 1-D);
      sliceplot2(F1, -t0, t0,  sqrt(i), 40);
      sliceplot2(F1, -t0, t0, -sqrt(i), 40);

      rgb(0.5-0.5*D, 0.5+0.25*D, 1-0.25*D);
      sliceplot2(F2, -t0, t0,  sqrt(i), 40);
      sliceplot2(F2, -t0, t0, -sqrt(i), 40);
  }

  plain;
  red;
  rect(P(x_min, y_min), P(x_max, y_max));
  end(); 
}

