/* lissajous.c -- May 29, 2002 */
#include "epix.h"

pair f(double t) 
{
  return P(sin(3*M_PI*t+0.5), sin(4*M_PI*t+0.5));
}

main() {

  bounding_box(P(-1,-1), P(1,1));
  picture(P(300, 300));
  unitlength("0.01in");
  offset(P(150,-150));

  begin();

  grid(4*x_size, 4*y_size);

  bold;
  line(P(x_min, 0), P(x_max, 0));
  line(P(0, y_min), P(0, y_max));

  red;
  plot(f, 0, 2, 200);

  plain;
  blue;
  tan_field(f, 0, 2, 81);

  black;
  v_axis_masklabels(P(0, y_min), P(0, y_max), 2*y_size, P(0,0), c);

  end();
}

