/* 
 * weierstrass.c -- A Weierstrass nowhere-differentiable function
 *
 * August 16, 2001
 */
#include "epix.h"
#define N 8 // Number of summands

/* "cb" is the Charlie Brown function, see functions.c */

double weierstrass(double t)
{
  double y=0;
  for(int i=0; i < N; ++i)
    y += pow(2,-i)*cb(pow(2,i)*t);

  return y;
}

main() {

  bounding_box(P(-2, 0), P(2, 1.5));
  picture(P(320, 120));
  unitlength("0.01in");
  offset(P(160,-120));

  begin();

  h_axis(P(x_min,0), P(x_max,0), 2*x_size);
  v_axis(P(0,y_min), P(0,y_max), 2*y_size);
  h_axis_labels(P(x_min,0), P(x_max,0), x_size, P(-12,-14));
  
  blue;
  plot(cb, x_min - 0.25, x_max+0.25, 4*x_size + 2);

  bold;
  black;
  plot(weierstrass, x_min, x_max, pow(2,N));

  red;
  plot(weierstrass, 0.5, 1.5, pow(2,N-2));

  end();
}

