module X
	( module X
	) where

import Xlib_StdDIS


-- ToDo: use newtype
type XID      = Word32
type Mask     = Word32
type Atom     = Word32
type VisualID = Word32
type Time     = Word32


-- end platform dependency

type Window   = XID
type Drawable = XID
type Font     = XID
type Pixmap   = XID
type Cursor   = XID
type Colormap = XID
type GContext = XID
type KeySym   = XID


type KeyCode = Char

xK_VoidSymbol :: KeySym
xK_VoidSymbol =
  unsafePerformIO(
    prim_X_xK_VoidSymbol >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_VoidSymbol :: IO (Word32)
xK_BackSpace :: KeySym
xK_BackSpace =
  unsafePerformIO(
    prim_X_xK_BackSpace >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_BackSpace :: IO (Word32)
xK_Tab :: KeySym
xK_Tab =
  unsafePerformIO(
    prim_X_xK_Tab >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Tab :: IO (Word32)
xK_Linefeed :: KeySym
xK_Linefeed =
  unsafePerformIO(
    prim_X_xK_Linefeed >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Linefeed :: IO (Word32)
xK_Clear :: KeySym
xK_Clear =
  unsafePerformIO(
    prim_X_xK_Clear >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Clear :: IO (Word32)
xK_Return :: KeySym
xK_Return =
  unsafePerformIO(
    prim_X_xK_Return >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Return :: IO (Word32)
xK_Pause :: KeySym
xK_Pause =
  unsafePerformIO(
    prim_X_xK_Pause >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Pause :: IO (Word32)
xK_Scroll_Lock :: KeySym
xK_Scroll_Lock =
  unsafePerformIO(
    prim_X_xK_Scroll_Lock >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Scroll_Lock :: IO (Word32)
xK_Sys_Req :: KeySym
xK_Sys_Req =
  unsafePerformIO(
    prim_X_xK_Sys_Req >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Sys_Req :: IO (Word32)
xK_Escape :: KeySym
xK_Escape =
  unsafePerformIO(
    prim_X_xK_Escape >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Escape :: IO (Word32)
xK_Delete :: KeySym
xK_Delete =
  unsafePerformIO(
    prim_X_xK_Delete >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Delete :: IO (Word32)
xK_Multi_key :: KeySym
xK_Multi_key =
  unsafePerformIO(
    prim_X_xK_Multi_key >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Multi_key :: IO (Word32)

-- Cursor control & motion
xK_Home :: KeySym
xK_Home =
  unsafePerformIO(
    prim_X_xK_Home >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Home :: IO (Word32)
xK_Left :: KeySym
xK_Left =
  unsafePerformIO(
    prim_X_xK_Left >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Left :: IO (Word32)
xK_Up :: KeySym
xK_Up =
  unsafePerformIO(
    prim_X_xK_Up >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Up :: IO (Word32)
xK_Right :: KeySym
xK_Right =
  unsafePerformIO(
    prim_X_xK_Right >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Right :: IO (Word32)
xK_Down :: KeySym
xK_Down =
  unsafePerformIO(
    prim_X_xK_Down >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Down :: IO (Word32)
xK_Prior :: KeySym
xK_Prior =
  unsafePerformIO(
    prim_X_xK_Prior >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Prior :: IO (Word32)
xK_Page_Up :: KeySym
xK_Page_Up =
  unsafePerformIO(
    prim_X_xK_Page_Up >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Page_Up :: IO (Word32)
xK_Next :: KeySym
xK_Next =
  unsafePerformIO(
    prim_X_xK_Next >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Next :: IO (Word32)
xK_Page_Down :: KeySym
xK_Page_Down =
  unsafePerformIO(
    prim_X_xK_Page_Down >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Page_Down :: IO (Word32)
xK_End :: KeySym
xK_End =
  unsafePerformIO(
    prim_X_xK_End >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_End :: IO (Word32)
xK_Begin :: KeySym
xK_Begin =
  unsafePerformIO(
    prim_X_xK_Begin >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Begin :: IO (Word32)
xK_Select :: KeySym
xK_Select =
  unsafePerformIO(
    prim_X_xK_Select >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Select :: IO (Word32)
xK_Print :: KeySym
xK_Print =
  unsafePerformIO(
    prim_X_xK_Print >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Print :: IO (Word32)
xK_Execute :: KeySym
xK_Execute =
  unsafePerformIO(
    prim_X_xK_Execute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Execute :: IO (Word32)
xK_Insert :: KeySym
xK_Insert =
  unsafePerformIO(
    prim_X_xK_Insert >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Insert :: IO (Word32)
xK_Undo :: KeySym
xK_Undo =
  unsafePerformIO(
    prim_X_xK_Undo >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Undo :: IO (Word32)
xK_Redo :: KeySym
xK_Redo =
  unsafePerformIO(
    prim_X_xK_Redo >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Redo :: IO (Word32)
xK_Menu :: KeySym
xK_Menu =
  unsafePerformIO(
    prim_X_xK_Menu >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Menu :: IO (Word32)
xK_Find :: KeySym
xK_Find =
  unsafePerformIO(
    prim_X_xK_Find >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Find :: IO (Word32)
xK_Cancel :: KeySym
xK_Cancel =
  unsafePerformIO(
    prim_X_xK_Cancel >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Cancel :: IO (Word32)
xK_Help :: KeySym
xK_Help =
  unsafePerformIO(
    prim_X_xK_Help >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Help :: IO (Word32)
xK_Break :: KeySym
xK_Break =
  unsafePerformIO(
    prim_X_xK_Break >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Break :: IO (Word32)
xK_Mode_switch :: KeySym
xK_Mode_switch =
  unsafePerformIO(
    prim_X_xK_Mode_switch >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Mode_switch :: IO (Word32)
xK_script_switch :: KeySym
xK_script_switch =
  unsafePerformIO(
    prim_X_xK_script_switch >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_script_switch :: IO (Word32)
xK_Num_Lock :: KeySym
xK_Num_Lock =
  unsafePerformIO(
    prim_X_xK_Num_Lock >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Num_Lock :: IO (Word32)
 
-- Keypad Functions, keypad numbers cleverly chosen to map to ascii
xK_KP_Space :: KeySym
xK_KP_Space =
  unsafePerformIO(
    prim_X_xK_KP_Space >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Space :: IO (Word32)
xK_KP_Tab :: KeySym
xK_KP_Tab =
  unsafePerformIO(
    prim_X_xK_KP_Tab >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Tab :: IO (Word32)
xK_KP_Enter :: KeySym
xK_KP_Enter =
  unsafePerformIO(
    prim_X_xK_KP_Enter >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Enter :: IO (Word32)
xK_KP_F1 :: KeySym
xK_KP_F1 =
  unsafePerformIO(
    prim_X_xK_KP_F1 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_F1 :: IO (Word32)
xK_KP_F2 :: KeySym
xK_KP_F2 =
  unsafePerformIO(
    prim_X_xK_KP_F2 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_F2 :: IO (Word32)
xK_KP_F3 :: KeySym
xK_KP_F3 =
  unsafePerformIO(
    prim_X_xK_KP_F3 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_F3 :: IO (Word32)
xK_KP_F4 :: KeySym
xK_KP_F4 =
  unsafePerformIO(
    prim_X_xK_KP_F4 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_F4 :: IO (Word32)
xK_KP_Home :: KeySym
xK_KP_Home =
  unsafePerformIO(
    prim_X_xK_KP_Home >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Home :: IO (Word32)
xK_KP_Left :: KeySym
xK_KP_Left =
  unsafePerformIO(
    prim_X_xK_KP_Left >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Left :: IO (Word32)
xK_KP_Up :: KeySym
xK_KP_Up =
  unsafePerformIO(
    prim_X_xK_KP_Up >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Up :: IO (Word32)
xK_KP_Right :: KeySym
xK_KP_Right =
  unsafePerformIO(
    prim_X_xK_KP_Right >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Right :: IO (Word32)
xK_KP_Down :: KeySym
xK_KP_Down =
  unsafePerformIO(
    prim_X_xK_KP_Down >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Down :: IO (Word32)
xK_KP_Prior :: KeySym
xK_KP_Prior =
  unsafePerformIO(
    prim_X_xK_KP_Prior >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Prior :: IO (Word32)
xK_KP_Page_Up :: KeySym
xK_KP_Page_Up =
  unsafePerformIO(
    prim_X_xK_KP_Page_Up >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Page_Up :: IO (Word32)
xK_KP_Next :: KeySym
xK_KP_Next =
  unsafePerformIO(
    prim_X_xK_KP_Next >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Next :: IO (Word32)
xK_KP_Page_Down :: KeySym
xK_KP_Page_Down =
  unsafePerformIO(
    prim_X_xK_KP_Page_Down >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Page_Down :: IO (Word32)
xK_KP_End :: KeySym
xK_KP_End =
  unsafePerformIO(
    prim_X_xK_KP_End >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_End :: IO (Word32)
xK_KP_Begin :: KeySym
xK_KP_Begin =
  unsafePerformIO(
    prim_X_xK_KP_Begin >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Begin :: IO (Word32)
xK_KP_Insert :: KeySym
xK_KP_Insert =
  unsafePerformIO(
    prim_X_xK_KP_Insert >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Insert :: IO (Word32)
xK_KP_Delete :: KeySym
xK_KP_Delete =
  unsafePerformIO(
    prim_X_xK_KP_Delete >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Delete :: IO (Word32)
xK_KP_Equal :: KeySym
xK_KP_Equal =
  unsafePerformIO(
    prim_X_xK_KP_Equal >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Equal :: IO (Word32)
xK_KP_Multiply :: KeySym
xK_KP_Multiply =
  unsafePerformIO(
    prim_X_xK_KP_Multiply >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Multiply :: IO (Word32)
xK_KP_Add :: KeySym
xK_KP_Add =
  unsafePerformIO(
    prim_X_xK_KP_Add >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Add :: IO (Word32)
xK_KP_Separator :: KeySym
xK_KP_Separator =
  unsafePerformIO(
    prim_X_xK_KP_Separator >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Separator :: IO (Word32)
xK_KP_Subtract :: KeySym
xK_KP_Subtract =
  unsafePerformIO(
    prim_X_xK_KP_Subtract >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Subtract :: IO (Word32)
xK_KP_Decimal :: KeySym
xK_KP_Decimal =
  unsafePerformIO(
    prim_X_xK_KP_Decimal >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Decimal :: IO (Word32)
xK_KP_Divide :: KeySym
xK_KP_Divide =
  unsafePerformIO(
    prim_X_xK_KP_Divide >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_Divide :: IO (Word32)
xK_KP_0 :: KeySym
xK_KP_0 =
  unsafePerformIO(
    prim_X_xK_KP_0 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_0 :: IO (Word32)
xK_KP_1 :: KeySym
xK_KP_1 =
  unsafePerformIO(
    prim_X_xK_KP_1 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_1 :: IO (Word32)
xK_KP_2 :: KeySym
xK_KP_2 =
  unsafePerformIO(
    prim_X_xK_KP_2 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_2 :: IO (Word32)
xK_KP_3 :: KeySym
xK_KP_3 =
  unsafePerformIO(
    prim_X_xK_KP_3 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_3 :: IO (Word32)
xK_KP_4 :: KeySym
xK_KP_4 =
  unsafePerformIO(
    prim_X_xK_KP_4 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_4 :: IO (Word32)
xK_KP_5 :: KeySym
xK_KP_5 =
  unsafePerformIO(
    prim_X_xK_KP_5 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_5 :: IO (Word32)
xK_KP_6 :: KeySym
xK_KP_6 =
  unsafePerformIO(
    prim_X_xK_KP_6 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_6 :: IO (Word32)
xK_KP_7 :: KeySym
xK_KP_7 =
  unsafePerformIO(
    prim_X_xK_KP_7 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_7 :: IO (Word32)
xK_KP_8 :: KeySym
xK_KP_8 =
  unsafePerformIO(
    prim_X_xK_KP_8 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_8 :: IO (Word32)
xK_KP_9 :: KeySym
xK_KP_9 =
  unsafePerformIO(
    prim_X_xK_KP_9 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_KP_9 :: IO (Word32)
xK_F1 :: KeySym
xK_F1 =
  unsafePerformIO(
    prim_X_xK_F1 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F1 :: IO (Word32)
xK_F2 :: KeySym
xK_F2 =
  unsafePerformIO(
    prim_X_xK_F2 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F2 :: IO (Word32)
xK_F3 :: KeySym
xK_F3 =
  unsafePerformIO(
    prim_X_xK_F3 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F3 :: IO (Word32)
xK_F4 :: KeySym
xK_F4 =
  unsafePerformIO(
    prim_X_xK_F4 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F4 :: IO (Word32)
xK_F5 :: KeySym
xK_F5 =
  unsafePerformIO(
    prim_X_xK_F5 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F5 :: IO (Word32)
xK_F6 :: KeySym
xK_F6 =
  unsafePerformIO(
    prim_X_xK_F6 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F6 :: IO (Word32)
xK_F7 :: KeySym
xK_F7 =
  unsafePerformIO(
    prim_X_xK_F7 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F7 :: IO (Word32)
xK_F8 :: KeySym
xK_F8 =
  unsafePerformIO(
    prim_X_xK_F8 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F8 :: IO (Word32)
xK_F9 :: KeySym
xK_F9 =
  unsafePerformIO(
    prim_X_xK_F9 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F9 :: IO (Word32)
xK_F10 :: KeySym
xK_F10 =
  unsafePerformIO(
    prim_X_xK_F10 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F10 :: IO (Word32)
xK_F11 :: KeySym
xK_F11 =
  unsafePerformIO(
    prim_X_xK_F11 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F11 :: IO (Word32)
xK_L1 :: KeySym
xK_L1 =
  unsafePerformIO(
    prim_X_xK_L1 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L1 :: IO (Word32)
xK_F12 :: KeySym
xK_F12 =
  unsafePerformIO(
    prim_X_xK_F12 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F12 :: IO (Word32)
xK_L2 :: KeySym
xK_L2 =
  unsafePerformIO(
    prim_X_xK_L2 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L2 :: IO (Word32)
xK_F13 :: KeySym
xK_F13 =
  unsafePerformIO(
    prim_X_xK_F13 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F13 :: IO (Word32)
xK_L3 :: KeySym
xK_L3 =
  unsafePerformIO(
    prim_X_xK_L3 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L3 :: IO (Word32)
xK_F14 :: KeySym
xK_F14 =
  unsafePerformIO(
    prim_X_xK_F14 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F14 :: IO (Word32)
xK_L4 :: KeySym
xK_L4 =
  unsafePerformIO(
    prim_X_xK_L4 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L4 :: IO (Word32)
xK_F15 :: KeySym
xK_F15 =
  unsafePerformIO(
    prim_X_xK_F15 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F15 :: IO (Word32)
xK_L5 :: KeySym
xK_L5 =
  unsafePerformIO(
    prim_X_xK_L5 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L5 :: IO (Word32)
xK_F16 :: KeySym
xK_F16 =
  unsafePerformIO(
    prim_X_xK_F16 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F16 :: IO (Word32)
xK_L6 :: KeySym
xK_L6 =
  unsafePerformIO(
    prim_X_xK_L6 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L6 :: IO (Word32)
xK_F17 :: KeySym
xK_F17 =
  unsafePerformIO(
    prim_X_xK_F17 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F17 :: IO (Word32)
xK_L7 :: KeySym
xK_L7 =
  unsafePerformIO(
    prim_X_xK_L7 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L7 :: IO (Word32)
xK_F18 :: KeySym
xK_F18 =
  unsafePerformIO(
    prim_X_xK_F18 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F18 :: IO (Word32)
xK_L8 :: KeySym
xK_L8 =
  unsafePerformIO(
    prim_X_xK_L8 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L8 :: IO (Word32)
xK_F19 :: KeySym
xK_F19 =
  unsafePerformIO(
    prim_X_xK_F19 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F19 :: IO (Word32)
xK_L9 :: KeySym
xK_L9 =
  unsafePerformIO(
    prim_X_xK_L9 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L9 :: IO (Word32)
xK_F20 :: KeySym
xK_F20 =
  unsafePerformIO(
    prim_X_xK_F20 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F20 :: IO (Word32)
xK_L10 :: KeySym
xK_L10 =
  unsafePerformIO(
    prim_X_xK_L10 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L10 :: IO (Word32)
xK_F21 :: KeySym
xK_F21 =
  unsafePerformIO(
    prim_X_xK_F21 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F21 :: IO (Word32)
xK_R1 :: KeySym
xK_R1 =
  unsafePerformIO(
    prim_X_xK_R1 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R1 :: IO (Word32)
xK_F22 :: KeySym
xK_F22 =
  unsafePerformIO(
    prim_X_xK_F22 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F22 :: IO (Word32)
xK_R2 :: KeySym
xK_R2 =
  unsafePerformIO(
    prim_X_xK_R2 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R2 :: IO (Word32)
xK_F23 :: KeySym
xK_F23 =
  unsafePerformIO(
    prim_X_xK_F23 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F23 :: IO (Word32)
xK_R3 :: KeySym
xK_R3 =
  unsafePerformIO(
    prim_X_xK_R3 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R3 :: IO (Word32)
xK_F24 :: KeySym
xK_F24 =
  unsafePerformIO(
    prim_X_xK_F24 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F24 :: IO (Word32)
xK_R4 :: KeySym
xK_R4 =
  unsafePerformIO(
    prim_X_xK_R4 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R4 :: IO (Word32)
xK_F25 :: KeySym
xK_F25 =
  unsafePerformIO(
    prim_X_xK_F25 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F25 :: IO (Word32)
xK_R5 :: KeySym
xK_R5 =
  unsafePerformIO(
    prim_X_xK_R5 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R5 :: IO (Word32)
xK_F26 :: KeySym
xK_F26 =
  unsafePerformIO(
    prim_X_xK_F26 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F26 :: IO (Word32)
xK_R6 :: KeySym
xK_R6 =
  unsafePerformIO(
    prim_X_xK_R6 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R6 :: IO (Word32)
xK_F27 :: KeySym
xK_F27 =
  unsafePerformIO(
    prim_X_xK_F27 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F27 :: IO (Word32)
xK_R7 :: KeySym
xK_R7 =
  unsafePerformIO(
    prim_X_xK_R7 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R7 :: IO (Word32)
xK_F28 :: KeySym
xK_F28 =
  unsafePerformIO(
    prim_X_xK_F28 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F28 :: IO (Word32)
xK_R8 :: KeySym
xK_R8 =
  unsafePerformIO(
    prim_X_xK_R8 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R8 :: IO (Word32)
xK_F29 :: KeySym
xK_F29 =
  unsafePerformIO(
    prim_X_xK_F29 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F29 :: IO (Word32)
xK_R9 :: KeySym
xK_R9 =
  unsafePerformIO(
    prim_X_xK_R9 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R9 :: IO (Word32)
xK_F30 :: KeySym
xK_F30 =
  unsafePerformIO(
    prim_X_xK_F30 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F30 :: IO (Word32)
xK_R10 :: KeySym
xK_R10 =
  unsafePerformIO(
    prim_X_xK_R10 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R10 :: IO (Word32)
xK_F31 :: KeySym
xK_F31 =
  unsafePerformIO(
    prim_X_xK_F31 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F31 :: IO (Word32)
xK_R11 :: KeySym
xK_R11 =
  unsafePerformIO(
    prim_X_xK_R11 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R11 :: IO (Word32)
xK_F32 :: KeySym
xK_F32 =
  unsafePerformIO(
    prim_X_xK_F32 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F32 :: IO (Word32)
xK_R12 :: KeySym
xK_R12 =
  unsafePerformIO(
    prim_X_xK_R12 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R12 :: IO (Word32)
xK_F33 :: KeySym
xK_F33 =
  unsafePerformIO(
    prim_X_xK_F33 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F33 :: IO (Word32)
xK_R13 :: KeySym
xK_R13 =
  unsafePerformIO(
    prim_X_xK_R13 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R13 :: IO (Word32)
xK_F34 :: KeySym
xK_F34 =
  unsafePerformIO(
    prim_X_xK_F34 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F34 :: IO (Word32)
xK_R14 :: KeySym
xK_R14 =
  unsafePerformIO(
    prim_X_xK_R14 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R14 :: IO (Word32)
xK_F35 :: KeySym
xK_F35 =
  unsafePerformIO(
    prim_X_xK_F35 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F35 :: IO (Word32)
xK_R15 :: KeySym
xK_R15 =
  unsafePerformIO(
    prim_X_xK_R15 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R15 :: IO (Word32)
			    
xK_Shift_L :: KeySym
xK_Shift_L =
  unsafePerformIO(
    prim_X_xK_Shift_L >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Shift_L :: IO (Word32)
xK_Shift_R :: KeySym
xK_Shift_R =
  unsafePerformIO(
    prim_X_xK_Shift_R >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Shift_R :: IO (Word32)
xK_Control_L :: KeySym
xK_Control_L =
  unsafePerformIO(
    prim_X_xK_Control_L >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Control_L :: IO (Word32)
xK_Control_R :: KeySym
xK_Control_R =
  unsafePerformIO(
    prim_X_xK_Control_R >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Control_R :: IO (Word32)
xK_Caps_Lock :: KeySym
xK_Caps_Lock =
  unsafePerformIO(
    prim_X_xK_Caps_Lock >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Caps_Lock :: IO (Word32)
xK_Shift_Lock :: KeySym
xK_Shift_Lock =
  unsafePerformIO(
    prim_X_xK_Shift_Lock >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Shift_Lock :: IO (Word32)
xK_Meta_L :: KeySym
xK_Meta_L =
  unsafePerformIO(
    prim_X_xK_Meta_L >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Meta_L :: IO (Word32)
xK_Meta_R :: KeySym
xK_Meta_R =
  unsafePerformIO(
    prim_X_xK_Meta_R >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Meta_R :: IO (Word32)
xK_Alt_L :: KeySym
xK_Alt_L =
  unsafePerformIO(
    prim_X_xK_Alt_L >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Alt_L :: IO (Word32)
xK_Alt_R :: KeySym
xK_Alt_R =
  unsafePerformIO(
    prim_X_xK_Alt_R >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Alt_R :: IO (Word32)
xK_Super_L :: KeySym
xK_Super_L =
  unsafePerformIO(
    prim_X_xK_Super_L >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Super_L :: IO (Word32)
xK_Super_R :: KeySym
xK_Super_R =
  unsafePerformIO(
    prim_X_xK_Super_R >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Super_R :: IO (Word32)
xK_Hyper_L :: KeySym
xK_Hyper_L =
  unsafePerformIO(
    prim_X_xK_Hyper_L >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Hyper_L :: IO (Word32)
xK_Hyper_R :: KeySym
xK_Hyper_R =
  unsafePerformIO(
    prim_X_xK_Hyper_R >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Hyper_R :: IO (Word32)

xK_space :: KeySym
xK_space =
  unsafePerformIO(
    prim_X_xK_space >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_space :: IO (Word32)
xK_exclam :: KeySym
xK_exclam =
  unsafePerformIO(
    prim_X_xK_exclam >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_exclam :: IO (Word32)
xK_quotedbl :: KeySym
xK_quotedbl =
  unsafePerformIO(
    prim_X_xK_quotedbl >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_quotedbl :: IO (Word32)
xK_numbersign :: KeySym
xK_numbersign =
  unsafePerformIO(
    prim_X_xK_numbersign >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_numbersign :: IO (Word32)
xK_dollar :: KeySym
xK_dollar =
  unsafePerformIO(
    prim_X_xK_dollar >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_dollar :: IO (Word32)
xK_percent :: KeySym
xK_percent =
  unsafePerformIO(
    prim_X_xK_percent >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_percent :: IO (Word32)
xK_ampersand :: KeySym
xK_ampersand =
  unsafePerformIO(
    prim_X_xK_ampersand >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ampersand :: IO (Word32)
xK_apostrophe :: KeySym
xK_apostrophe =
  unsafePerformIO(
    prim_X_xK_apostrophe >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_apostrophe :: IO (Word32)
xK_quoteright :: KeySym
xK_quoteright =
  unsafePerformIO(
    prim_X_xK_quoteright >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_quoteright :: IO (Word32)
xK_parenleft :: KeySym
xK_parenleft =
  unsafePerformIO(
    prim_X_xK_parenleft >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_parenleft :: IO (Word32)
xK_parenright :: KeySym
xK_parenright =
  unsafePerformIO(
    prim_X_xK_parenright >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_parenright :: IO (Word32)
xK_asterisk :: KeySym
xK_asterisk =
  unsafePerformIO(
    prim_X_xK_asterisk >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_asterisk :: IO (Word32)
xK_plus :: KeySym
xK_plus =
  unsafePerformIO(
    prim_X_xK_plus >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_plus :: IO (Word32)
xK_comma :: KeySym
xK_comma =
  unsafePerformIO(
    prim_X_xK_comma >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_comma :: IO (Word32)
xK_minus :: KeySym
xK_minus =
  unsafePerformIO(
    prim_X_xK_minus >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_minus :: IO (Word32)
xK_period :: KeySym
xK_period =
  unsafePerformIO(
    prim_X_xK_period >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_period :: IO (Word32)
xK_slash :: KeySym
xK_slash =
  unsafePerformIO(
    prim_X_xK_slash >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_slash :: IO (Word32)
xK_0 :: KeySym
xK_0 =
  unsafePerformIO(
    prim_X_xK_0 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_0 :: IO (Word32)
xK_1 :: KeySym
xK_1 =
  unsafePerformIO(
    prim_X_xK_1 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_1 :: IO (Word32)
xK_2 :: KeySym
xK_2 =
  unsafePerformIO(
    prim_X_xK_2 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_2 :: IO (Word32)
xK_3 :: KeySym
xK_3 =
  unsafePerformIO(
    prim_X_xK_3 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_3 :: IO (Word32)
xK_4 :: KeySym
xK_4 =
  unsafePerformIO(
    prim_X_xK_4 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_4 :: IO (Word32)
xK_5 :: KeySym
xK_5 =
  unsafePerformIO(
    prim_X_xK_5 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_5 :: IO (Word32)
xK_6 :: KeySym
xK_6 =
  unsafePerformIO(
    prim_X_xK_6 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_6 :: IO (Word32)
xK_7 :: KeySym
xK_7 =
  unsafePerformIO(
    prim_X_xK_7 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_7 :: IO (Word32)
xK_8 :: KeySym
xK_8 =
  unsafePerformIO(
    prim_X_xK_8 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_8 :: IO (Word32)
xK_9 :: KeySym
xK_9 =
  unsafePerformIO(
    prim_X_xK_9 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_9 :: IO (Word32)
xK_colon :: KeySym
xK_colon =
  unsafePerformIO(
    prim_X_xK_colon >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_colon :: IO (Word32)
xK_semicolon :: KeySym
xK_semicolon =
  unsafePerformIO(
    prim_X_xK_semicolon >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_semicolon :: IO (Word32)
xK_less :: KeySym
xK_less =
  unsafePerformIO(
    prim_X_xK_less >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_less :: IO (Word32)
xK_equal :: KeySym
xK_equal =
  unsafePerformIO(
    prim_X_xK_equal >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_equal :: IO (Word32)
xK_greater :: KeySym
xK_greater =
  unsafePerformIO(
    prim_X_xK_greater >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_greater :: IO (Word32)
xK_question :: KeySym
xK_question =
  unsafePerformIO(
    prim_X_xK_question >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_question :: IO (Word32)
xK_at :: KeySym
xK_at =
  unsafePerformIO(
    prim_X_xK_at >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_at :: IO (Word32)
xK_A :: KeySym
xK_A =
  unsafePerformIO(
    prim_X_xK_A >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_A :: IO (Word32)
xK_B :: KeySym
xK_B =
  unsafePerformIO(
    prim_X_xK_B >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_B :: IO (Word32)
xK_C :: KeySym
xK_C =
  unsafePerformIO(
    prim_X_xK_C >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_C :: IO (Word32)
xK_D :: KeySym
xK_D =
  unsafePerformIO(
    prim_X_xK_D >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_D :: IO (Word32)
xK_E :: KeySym
xK_E =
  unsafePerformIO(
    prim_X_xK_E >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_E :: IO (Word32)
xK_F :: KeySym
xK_F =
  unsafePerformIO(
    prim_X_xK_F >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_F :: IO (Word32)
xK_G :: KeySym
xK_G =
  unsafePerformIO(
    prim_X_xK_G >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_G :: IO (Word32)
xK_H :: KeySym
xK_H =
  unsafePerformIO(
    prim_X_xK_H >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_H :: IO (Word32)
xK_I :: KeySym
xK_I =
  unsafePerformIO(
    prim_X_xK_I >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_I :: IO (Word32)
xK_J :: KeySym
xK_J =
  unsafePerformIO(
    prim_X_xK_J >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_J :: IO (Word32)
xK_K :: KeySym
xK_K =
  unsafePerformIO(
    prim_X_xK_K >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_K :: IO (Word32)
xK_L :: KeySym
xK_L =
  unsafePerformIO(
    prim_X_xK_L >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_L :: IO (Word32)
xK_M :: KeySym
xK_M =
  unsafePerformIO(
    prim_X_xK_M >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_M :: IO (Word32)
xK_N :: KeySym
xK_N =
  unsafePerformIO(
    prim_X_xK_N >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_N :: IO (Word32)
xK_O :: KeySym
xK_O =
  unsafePerformIO(
    prim_X_xK_O >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_O :: IO (Word32)
xK_P :: KeySym
xK_P =
  unsafePerformIO(
    prim_X_xK_P >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_P :: IO (Word32)
xK_Q :: KeySym
xK_Q =
  unsafePerformIO(
    prim_X_xK_Q >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Q :: IO (Word32)
xK_R :: KeySym
xK_R =
  unsafePerformIO(
    prim_X_xK_R >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_R :: IO (Word32)
xK_S :: KeySym
xK_S =
  unsafePerformIO(
    prim_X_xK_S >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_S :: IO (Word32)
xK_T :: KeySym
xK_T =
  unsafePerformIO(
    prim_X_xK_T >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_T :: IO (Word32)
xK_U :: KeySym
xK_U =
  unsafePerformIO(
    prim_X_xK_U >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_U :: IO (Word32)
xK_V :: KeySym
xK_V =
  unsafePerformIO(
    prim_X_xK_V >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_V :: IO (Word32)
xK_W :: KeySym
xK_W =
  unsafePerformIO(
    prim_X_xK_W >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_W :: IO (Word32)
xK_X :: KeySym
xK_X =
  unsafePerformIO(
    prim_X_xK_X >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_X :: IO (Word32)
xK_Y :: KeySym
xK_Y =
  unsafePerformIO(
    prim_X_xK_Y >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Y :: IO (Word32)
xK_Z :: KeySym
xK_Z =
  unsafePerformIO(
    prim_X_xK_Z >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Z :: IO (Word32)
xK_bracketleft :: KeySym
xK_bracketleft =
  unsafePerformIO(
    prim_X_xK_bracketleft >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_bracketleft :: IO (Word32)
xK_backslash :: KeySym
xK_backslash =
  unsafePerformIO(
    prim_X_xK_backslash >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_backslash :: IO (Word32)
xK_bracketright :: KeySym
xK_bracketright =
  unsafePerformIO(
    prim_X_xK_bracketright >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_bracketright :: IO (Word32)
xK_asciicircum :: KeySym
xK_asciicircum =
  unsafePerformIO(
    prim_X_xK_asciicircum >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_asciicircum :: IO (Word32)
xK_underscore :: KeySym
xK_underscore =
  unsafePerformIO(
    prim_X_xK_underscore >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_underscore :: IO (Word32)
xK_grave :: KeySym
xK_grave =
  unsafePerformIO(
    prim_X_xK_grave >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_grave :: IO (Word32)
xK_quoteleft :: KeySym
xK_quoteleft =
  unsafePerformIO(
    prim_X_xK_quoteleft >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_quoteleft :: IO (Word32)
xK_a :: KeySym
xK_a =
  unsafePerformIO(
    prim_X_xK_a >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_a :: IO (Word32)
xK_b :: KeySym
xK_b =
  unsafePerformIO(
    prim_X_xK_b >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_b :: IO (Word32)
xK_c :: KeySym
xK_c =
  unsafePerformIO(
    prim_X_xK_c >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_c :: IO (Word32)
xK_d :: KeySym
xK_d =
  unsafePerformIO(
    prim_X_xK_d >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_d :: IO (Word32)
xK_e :: KeySym
xK_e =
  unsafePerformIO(
    prim_X_xK_e >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_e :: IO (Word32)
xK_f :: KeySym
xK_f =
  unsafePerformIO(
    prim_X_xK_f >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_f :: IO (Word32)
xK_g :: KeySym
xK_g =
  unsafePerformIO(
    prim_X_xK_g >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_g :: IO (Word32)
xK_h :: KeySym
xK_h =
  unsafePerformIO(
    prim_X_xK_h >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_h :: IO (Word32)
xK_i :: KeySym
xK_i =
  unsafePerformIO(
    prim_X_xK_i >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_i :: IO (Word32)
xK_j :: KeySym
xK_j =
  unsafePerformIO(
    prim_X_xK_j >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_j :: IO (Word32)
xK_k :: KeySym
xK_k =
  unsafePerformIO(
    prim_X_xK_k >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_k :: IO (Word32)
xK_l :: KeySym
xK_l =
  unsafePerformIO(
    prim_X_xK_l >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_l :: IO (Word32)
xK_m :: KeySym
xK_m =
  unsafePerformIO(
    prim_X_xK_m >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_m :: IO (Word32)
xK_n :: KeySym
xK_n =
  unsafePerformIO(
    prim_X_xK_n >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_n :: IO (Word32)
xK_o :: KeySym
xK_o =
  unsafePerformIO(
    prim_X_xK_o >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_o :: IO (Word32)
xK_p :: KeySym
xK_p =
  unsafePerformIO(
    prim_X_xK_p >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_p :: IO (Word32)
xK_q :: KeySym
xK_q =
  unsafePerformIO(
    prim_X_xK_q >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_q :: IO (Word32)
xK_r :: KeySym
xK_r =
  unsafePerformIO(
    prim_X_xK_r >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_r :: IO (Word32)
xK_s :: KeySym
xK_s =
  unsafePerformIO(
    prim_X_xK_s >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_s :: IO (Word32)
xK_t :: KeySym
xK_t =
  unsafePerformIO(
    prim_X_xK_t >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_t :: IO (Word32)
xK_u :: KeySym
xK_u =
  unsafePerformIO(
    prim_X_xK_u >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_u :: IO (Word32)
xK_v :: KeySym
xK_v =
  unsafePerformIO(
    prim_X_xK_v >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_v :: IO (Word32)
xK_w :: KeySym
xK_w =
  unsafePerformIO(
    prim_X_xK_w >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_w :: IO (Word32)
xK_x :: KeySym
xK_x =
  unsafePerformIO(
    prim_X_xK_x >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_x :: IO (Word32)
xK_y :: KeySym
xK_y =
  unsafePerformIO(
    prim_X_xK_y >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_y :: IO (Word32)
xK_z :: KeySym
xK_z =
  unsafePerformIO(
    prim_X_xK_z >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_z :: IO (Word32)
xK_braceleft :: KeySym
xK_braceleft =
  unsafePerformIO(
    prim_X_xK_braceleft >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_braceleft :: IO (Word32)
xK_bar :: KeySym
xK_bar =
  unsafePerformIO(
    prim_X_xK_bar >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_bar :: IO (Word32)
xK_braceright :: KeySym
xK_braceright =
  unsafePerformIO(
    prim_X_xK_braceright >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_braceright :: IO (Word32)
xK_asciitilde :: KeySym
xK_asciitilde =
  unsafePerformIO(
    prim_X_xK_asciitilde >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_asciitilde :: IO (Word32)
xK_nobreakspace :: KeySym
xK_nobreakspace =
  unsafePerformIO(
    prim_X_xK_nobreakspace >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_nobreakspace :: IO (Word32)
xK_exclamdown :: KeySym
xK_exclamdown =
  unsafePerformIO(
    prim_X_xK_exclamdown >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_exclamdown :: IO (Word32)
xK_cent :: KeySym
xK_cent =
  unsafePerformIO(
    prim_X_xK_cent >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_cent :: IO (Word32)
xK_sterling :: KeySym
xK_sterling =
  unsafePerformIO(
    prim_X_xK_sterling >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_sterling :: IO (Word32)
xK_currency :: KeySym
xK_currency =
  unsafePerformIO(
    prim_X_xK_currency >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_currency :: IO (Word32)
xK_yen :: KeySym
xK_yen =
  unsafePerformIO(
    prim_X_xK_yen >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_yen :: IO (Word32)
xK_brokenbar :: KeySym
xK_brokenbar =
  unsafePerformIO(
    prim_X_xK_brokenbar >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_brokenbar :: IO (Word32)
xK_section :: KeySym
xK_section =
  unsafePerformIO(
    prim_X_xK_section >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_section :: IO (Word32)
xK_diaeresis :: KeySym
xK_diaeresis =
  unsafePerformIO(
    prim_X_xK_diaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_diaeresis :: IO (Word32)
xK_copyright :: KeySym
xK_copyright =
  unsafePerformIO(
    prim_X_xK_copyright >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_copyright :: IO (Word32)
xK_ordfeminine :: KeySym
xK_ordfeminine =
  unsafePerformIO(
    prim_X_xK_ordfeminine >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ordfeminine :: IO (Word32)
xK_guillemotleft :: KeySym
xK_guillemotleft =
  unsafePerformIO(
    prim_X_xK_guillemotleft >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_guillemotleft :: IO (Word32)
xK_notsign :: KeySym
xK_notsign =
  unsafePerformIO(
    prim_X_xK_notsign >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_notsign :: IO (Word32)
xK_hyphen :: KeySym
xK_hyphen =
  unsafePerformIO(
    prim_X_xK_hyphen >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_hyphen :: IO (Word32)
xK_registered :: KeySym
xK_registered =
  unsafePerformIO(
    prim_X_xK_registered >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_registered :: IO (Word32)
xK_macron :: KeySym
xK_macron =
  unsafePerformIO(
    prim_X_xK_macron >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_macron :: IO (Word32)
xK_degree :: KeySym
xK_degree =
  unsafePerformIO(
    prim_X_xK_degree >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_degree :: IO (Word32)
xK_plusminus :: KeySym
xK_plusminus =
  unsafePerformIO(
    prim_X_xK_plusminus >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_plusminus :: IO (Word32)
xK_twosuperior :: KeySym
xK_twosuperior =
  unsafePerformIO(
    prim_X_xK_twosuperior >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_twosuperior :: IO (Word32)
xK_threesuperior :: KeySym
xK_threesuperior =
  unsafePerformIO(
    prim_X_xK_threesuperior >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_threesuperior :: IO (Word32)
xK_acute :: KeySym
xK_acute =
  unsafePerformIO(
    prim_X_xK_acute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_acute :: IO (Word32)
xK_mu :: KeySym
xK_mu =
  unsafePerformIO(
    prim_X_xK_mu >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_mu :: IO (Word32)
xK_paragraph :: KeySym
xK_paragraph =
  unsafePerformIO(
    prim_X_xK_paragraph >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_paragraph :: IO (Word32)
xK_periodcentered :: KeySym
xK_periodcentered =
  unsafePerformIO(
    prim_X_xK_periodcentered >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_periodcentered :: IO (Word32)
xK_cedilla :: KeySym
xK_cedilla =
  unsafePerformIO(
    prim_X_xK_cedilla >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_cedilla :: IO (Word32)
xK_onesuperior :: KeySym
xK_onesuperior =
  unsafePerformIO(
    prim_X_xK_onesuperior >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_onesuperior :: IO (Word32)
xK_masculine :: KeySym
xK_masculine =
  unsafePerformIO(
    prim_X_xK_masculine >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_masculine :: IO (Word32)
xK_guillemotright :: KeySym
xK_guillemotright =
  unsafePerformIO(
    prim_X_xK_guillemotright >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_guillemotright :: IO (Word32)
xK_onequarter :: KeySym
xK_onequarter =
  unsafePerformIO(
    prim_X_xK_onequarter >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_onequarter :: IO (Word32)
xK_onehalf :: KeySym
xK_onehalf =
  unsafePerformIO(
    prim_X_xK_onehalf >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_onehalf :: IO (Word32)
xK_threequarters :: KeySym
xK_threequarters =
  unsafePerformIO(
    prim_X_xK_threequarters >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_threequarters :: IO (Word32)
xK_questiondown :: KeySym
xK_questiondown =
  unsafePerformIO(
    prim_X_xK_questiondown >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_questiondown :: IO (Word32)
xK_Agrave :: KeySym
xK_Agrave =
  unsafePerformIO(
    prim_X_xK_Agrave >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Agrave :: IO (Word32)
xK_Aacute :: KeySym
xK_Aacute =
  unsafePerformIO(
    prim_X_xK_Aacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Aacute :: IO (Word32)
xK_Acircumflex :: KeySym
xK_Acircumflex =
  unsafePerformIO(
    prim_X_xK_Acircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Acircumflex :: IO (Word32)
xK_Atilde :: KeySym
xK_Atilde =
  unsafePerformIO(
    prim_X_xK_Atilde >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Atilde :: IO (Word32)
xK_Adiaeresis :: KeySym
xK_Adiaeresis =
  unsafePerformIO(
    prim_X_xK_Adiaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Adiaeresis :: IO (Word32)
xK_Aring :: KeySym
xK_Aring =
  unsafePerformIO(
    prim_X_xK_Aring >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Aring :: IO (Word32)
xK_AE :: KeySym
xK_AE =
  unsafePerformIO(
    prim_X_xK_AE >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_AE :: IO (Word32)
xK_Ccedilla :: KeySym
xK_Ccedilla =
  unsafePerformIO(
    prim_X_xK_Ccedilla >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Ccedilla :: IO (Word32)
xK_Egrave :: KeySym
xK_Egrave =
  unsafePerformIO(
    prim_X_xK_Egrave >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Egrave :: IO (Word32)
xK_Eacute :: KeySym
xK_Eacute =
  unsafePerformIO(
    prim_X_xK_Eacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Eacute :: IO (Word32)
xK_Ecircumflex :: KeySym
xK_Ecircumflex =
  unsafePerformIO(
    prim_X_xK_Ecircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Ecircumflex :: IO (Word32)
xK_Ediaeresis :: KeySym
xK_Ediaeresis =
  unsafePerformIO(
    prim_X_xK_Ediaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Ediaeresis :: IO (Word32)
xK_Igrave :: KeySym
xK_Igrave =
  unsafePerformIO(
    prim_X_xK_Igrave >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Igrave :: IO (Word32)
xK_Iacute :: KeySym
xK_Iacute =
  unsafePerformIO(
    prim_X_xK_Iacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Iacute :: IO (Word32)
xK_Icircumflex :: KeySym
xK_Icircumflex =
  unsafePerformIO(
    prim_X_xK_Icircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Icircumflex :: IO (Word32)
xK_Idiaeresis :: KeySym
xK_Idiaeresis =
  unsafePerformIO(
    prim_X_xK_Idiaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Idiaeresis :: IO (Word32)
xK_ETH :: KeySym
xK_ETH =
  unsafePerformIO(
    prim_X_xK_ETH >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ETH :: IO (Word32)
xK_Eth :: KeySym
xK_Eth =
  unsafePerformIO(
    prim_X_xK_Eth >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Eth :: IO (Word32)
xK_Ntilde :: KeySym
xK_Ntilde =
  unsafePerformIO(
    prim_X_xK_Ntilde >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Ntilde :: IO (Word32)
xK_Ograve :: KeySym
xK_Ograve =
  unsafePerformIO(
    prim_X_xK_Ograve >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Ograve :: IO (Word32)
xK_Oacute :: KeySym
xK_Oacute =
  unsafePerformIO(
    prim_X_xK_Oacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Oacute :: IO (Word32)
xK_Ocircumflex :: KeySym
xK_Ocircumflex =
  unsafePerformIO(
    prim_X_xK_Ocircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Ocircumflex :: IO (Word32)
xK_Otilde :: KeySym
xK_Otilde =
  unsafePerformIO(
    prim_X_xK_Otilde >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Otilde :: IO (Word32)
xK_Odiaeresis :: KeySym
xK_Odiaeresis =
  unsafePerformIO(
    prim_X_xK_Odiaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Odiaeresis :: IO (Word32)
xK_multiply :: KeySym
xK_multiply =
  unsafePerformIO(
    prim_X_xK_multiply >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_multiply :: IO (Word32)
xK_Ooblique :: KeySym
xK_Ooblique =
  unsafePerformIO(
    prim_X_xK_Ooblique >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Ooblique :: IO (Word32)
xK_Ugrave :: KeySym
xK_Ugrave =
  unsafePerformIO(
    prim_X_xK_Ugrave >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Ugrave :: IO (Word32)
xK_Uacute :: KeySym
xK_Uacute =
  unsafePerformIO(
    prim_X_xK_Uacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Uacute :: IO (Word32)
xK_Ucircumflex :: KeySym
xK_Ucircumflex =
  unsafePerformIO(
    prim_X_xK_Ucircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Ucircumflex :: IO (Word32)
xK_Udiaeresis :: KeySym
xK_Udiaeresis =
  unsafePerformIO(
    prim_X_xK_Udiaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Udiaeresis :: IO (Word32)
xK_Yacute :: KeySym
xK_Yacute =
  unsafePerformIO(
    prim_X_xK_Yacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Yacute :: IO (Word32)
xK_THORN :: KeySym
xK_THORN =
  unsafePerformIO(
    prim_X_xK_THORN >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_THORN :: IO (Word32)
xK_Thorn :: KeySym
xK_Thorn =
  unsafePerformIO(
    prim_X_xK_Thorn >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_Thorn :: IO (Word32)
xK_ssharp :: KeySym
xK_ssharp =
  unsafePerformIO(
    prim_X_xK_ssharp >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ssharp :: IO (Word32)
xK_agrave :: KeySym
xK_agrave =
  unsafePerformIO(
    prim_X_xK_agrave >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_agrave :: IO (Word32)
xK_aacute :: KeySym
xK_aacute =
  unsafePerformIO(
    prim_X_xK_aacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_aacute :: IO (Word32)
xK_acircumflex :: KeySym
xK_acircumflex =
  unsafePerformIO(
    prim_X_xK_acircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_acircumflex :: IO (Word32)
xK_atilde :: KeySym
xK_atilde =
  unsafePerformIO(
    prim_X_xK_atilde >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_atilde :: IO (Word32)
xK_adiaeresis :: KeySym
xK_adiaeresis =
  unsafePerformIO(
    prim_X_xK_adiaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_adiaeresis :: IO (Word32)
xK_aring :: KeySym
xK_aring =
  unsafePerformIO(
    prim_X_xK_aring >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_aring :: IO (Word32)
xK_ae :: KeySym
xK_ae =
  unsafePerformIO(
    prim_X_xK_ae >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ae :: IO (Word32)
xK_ccedilla :: KeySym
xK_ccedilla =
  unsafePerformIO(
    prim_X_xK_ccedilla >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ccedilla :: IO (Word32)
xK_egrave :: KeySym
xK_egrave =
  unsafePerformIO(
    prim_X_xK_egrave >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_egrave :: IO (Word32)
xK_eacute :: KeySym
xK_eacute =
  unsafePerformIO(
    prim_X_xK_eacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_eacute :: IO (Word32)
xK_ecircumflex :: KeySym
xK_ecircumflex =
  unsafePerformIO(
    prim_X_xK_ecircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ecircumflex :: IO (Word32)
xK_ediaeresis :: KeySym
xK_ediaeresis =
  unsafePerformIO(
    prim_X_xK_ediaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ediaeresis :: IO (Word32)
xK_igrave :: KeySym
xK_igrave =
  unsafePerformIO(
    prim_X_xK_igrave >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_igrave :: IO (Word32)
xK_iacute :: KeySym
xK_iacute =
  unsafePerformIO(
    prim_X_xK_iacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_iacute :: IO (Word32)
xK_icircumflex :: KeySym
xK_icircumflex =
  unsafePerformIO(
    prim_X_xK_icircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_icircumflex :: IO (Word32)
xK_idiaeresis :: KeySym
xK_idiaeresis =
  unsafePerformIO(
    prim_X_xK_idiaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_idiaeresis :: IO (Word32)
xK_eth :: KeySym
xK_eth =
  unsafePerformIO(
    prim_X_xK_eth >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_eth :: IO (Word32)
xK_ntilde :: KeySym
xK_ntilde =
  unsafePerformIO(
    prim_X_xK_ntilde >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ntilde :: IO (Word32)
xK_ograve :: KeySym
xK_ograve =
  unsafePerformIO(
    prim_X_xK_ograve >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ograve :: IO (Word32)
xK_oacute :: KeySym
xK_oacute =
  unsafePerformIO(
    prim_X_xK_oacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_oacute :: IO (Word32)
xK_ocircumflex :: KeySym
xK_ocircumflex =
  unsafePerformIO(
    prim_X_xK_ocircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ocircumflex :: IO (Word32)
xK_otilde :: KeySym
xK_otilde =
  unsafePerformIO(
    prim_X_xK_otilde >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_otilde :: IO (Word32)
xK_odiaeresis :: KeySym
xK_odiaeresis =
  unsafePerformIO(
    prim_X_xK_odiaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_odiaeresis :: IO (Word32)
xK_division :: KeySym
xK_division =
  unsafePerformIO(
    prim_X_xK_division >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_division :: IO (Word32)
xK_oslash :: KeySym
xK_oslash =
  unsafePerformIO(
    prim_X_xK_oslash >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_oslash :: IO (Word32)
xK_ugrave :: KeySym
xK_ugrave =
  unsafePerformIO(
    prim_X_xK_ugrave >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ugrave :: IO (Word32)
xK_uacute :: KeySym
xK_uacute =
  unsafePerformIO(
    prim_X_xK_uacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_uacute :: IO (Word32)
xK_ucircumflex :: KeySym
xK_ucircumflex =
  unsafePerformIO(
    prim_X_xK_ucircumflex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ucircumflex :: IO (Word32)
xK_udiaeresis :: KeySym
xK_udiaeresis =
  unsafePerformIO(
    prim_X_xK_udiaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_udiaeresis :: IO (Word32)
xK_yacute :: KeySym
xK_yacute =
  unsafePerformIO(
    prim_X_xK_yacute >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_yacute :: IO (Word32)
xK_thorn :: KeySym
xK_thorn =
  unsafePerformIO(
    prim_X_xK_thorn >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_thorn :: IO (Word32)
xK_ydiaeresis :: KeySym
xK_ydiaeresis =
  unsafePerformIO(
    prim_X_xK_ydiaeresis >>= \ (res1) ->
    (return (res1)))
primitive prim_X_xK_ydiaeresis :: IO (Word32)

type EventMask = Mask

noEventMask :: EventMask
noEventMask =
  unsafePerformIO(
    prim_X_noEventMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_noEventMask :: IO (Word32)
keyPressMask :: EventMask
keyPressMask =
  unsafePerformIO(
    prim_X_keyPressMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_keyPressMask :: IO (Word32)
keyReleaseMask :: EventMask
keyReleaseMask =
  unsafePerformIO(
    prim_X_keyReleaseMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_keyReleaseMask :: IO (Word32)
buttonPressMask :: EventMask
buttonPressMask =
  unsafePerformIO(
    prim_X_buttonPressMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_buttonPressMask :: IO (Word32)
buttonReleaseMask :: EventMask
buttonReleaseMask =
  unsafePerformIO(
    prim_X_buttonReleaseMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_buttonReleaseMask :: IO (Word32)
enterWindowMask :: EventMask
enterWindowMask =
  unsafePerformIO(
    prim_X_enterWindowMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_enterWindowMask :: IO (Word32)
leaveWindowMask :: EventMask
leaveWindowMask =
  unsafePerformIO(
    prim_X_leaveWindowMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_leaveWindowMask :: IO (Word32)
pointerMotionMask :: EventMask
pointerMotionMask =
  unsafePerformIO(
    prim_X_pointerMotionMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_pointerMotionMask :: IO (Word32)
pointerMotionHintMask :: EventMask
pointerMotionHintMask =
  unsafePerformIO(
    prim_X_pointerMotionHintMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_pointerMotionHintMask :: IO (Word32)
button1MotionMask :: EventMask
button1MotionMask =
  unsafePerformIO(
    prim_X_button1MotionMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button1MotionMask :: IO (Word32)
button2MotionMask :: EventMask
button2MotionMask =
  unsafePerformIO(
    prim_X_button2MotionMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button2MotionMask :: IO (Word32)
button3MotionMask :: EventMask
button3MotionMask =
  unsafePerformIO(
    prim_X_button3MotionMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button3MotionMask :: IO (Word32)
button4MotionMask :: EventMask
button4MotionMask =
  unsafePerformIO(
    prim_X_button4MotionMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button4MotionMask :: IO (Word32)
button5MotionMask :: EventMask
button5MotionMask =
  unsafePerformIO(
    prim_X_button5MotionMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button5MotionMask :: IO (Word32)
buttonMotionMask :: EventMask
buttonMotionMask =
  unsafePerformIO(
    prim_X_buttonMotionMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_buttonMotionMask :: IO (Word32)
keymapStateMask :: EventMask
keymapStateMask =
  unsafePerformIO(
    prim_X_keymapStateMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_keymapStateMask :: IO (Word32)
exposureMask :: EventMask
exposureMask =
  unsafePerformIO(
    prim_X_exposureMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_exposureMask :: IO (Word32)
visibilityChangeMask :: EventMask
visibilityChangeMask =
  unsafePerformIO(
    prim_X_visibilityChangeMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_visibilityChangeMask :: IO (Word32)
structureNotifyMask :: EventMask
structureNotifyMask =
  unsafePerformIO(
    prim_X_structureNotifyMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_structureNotifyMask :: IO (Word32)
resizeRedirectMask :: EventMask
resizeRedirectMask =
  unsafePerformIO(
    prim_X_resizeRedirectMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_resizeRedirectMask :: IO (Word32)
substructureNotifyMask :: EventMask
substructureNotifyMask =
  unsafePerformIO(
    prim_X_substructureNotifyMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_substructureNotifyMask :: IO (Word32)
substructureRedirectMask :: EventMask
substructureRedirectMask =
  unsafePerformIO(
    prim_X_substructureRedirectMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_substructureRedirectMask :: IO (Word32)
focusChangeMask :: EventMask
focusChangeMask =
  unsafePerformIO(
    prim_X_focusChangeMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_focusChangeMask :: IO (Word32)
propertyChangeMask :: EventMask
propertyChangeMask =
  unsafePerformIO(
    prim_X_propertyChangeMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_propertyChangeMask :: IO (Word32)
colormapChangeMask :: EventMask
colormapChangeMask =
  unsafePerformIO(
    prim_X_colormapChangeMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_colormapChangeMask :: IO (Word32)
ownerGrabButtonMask :: EventMask
ownerGrabButtonMask =
  unsafePerformIO(
    prim_X_ownerGrabButtonMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_ownerGrabButtonMask :: IO (Word32)

type EventType = Word32

keyPress :: EventType
keyPress =
  unsafePerformIO(
    prim_X_keyPress >>= \ (res1) ->
    (return (res1)))
primitive prim_X_keyPress :: IO (Word32)
keyRelease :: EventType
keyRelease =
  unsafePerformIO(
    prim_X_keyRelease >>= \ (res1) ->
    (return (res1)))
primitive prim_X_keyRelease :: IO (Word32)
buttonPress :: EventType
buttonPress =
  unsafePerformIO(
    prim_X_buttonPress >>= \ (res1) ->
    (return (res1)))
primitive prim_X_buttonPress :: IO (Word32)
buttonRelease :: EventType
buttonRelease =
  unsafePerformIO(
    prim_X_buttonRelease >>= \ (res1) ->
    (return (res1)))
primitive prim_X_buttonRelease :: IO (Word32)
motionNotify :: EventType
motionNotify =
  unsafePerformIO(
    prim_X_motionNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_motionNotify :: IO (Word32)
enterNotify :: EventType
enterNotify =
  unsafePerformIO(
    prim_X_enterNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_enterNotify :: IO (Word32)
leaveNotify :: EventType
leaveNotify =
  unsafePerformIO(
    prim_X_leaveNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_leaveNotify :: IO (Word32)
focusIn :: EventType
focusIn =
  unsafePerformIO(
    prim_X_focusIn >>= \ (res1) ->
    (return (res1)))
primitive prim_X_focusIn :: IO (Word32)
focusOut :: EventType
focusOut =
  unsafePerformIO(
    prim_X_focusOut >>= \ (res1) ->
    (return (res1)))
primitive prim_X_focusOut :: IO (Word32)
keymapNotify :: EventType
keymapNotify =
  unsafePerformIO(
    prim_X_keymapNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_keymapNotify :: IO (Word32)
expose :: EventType
expose =
  unsafePerformIO(
    prim_X_expose >>= \ (res1) ->
    (return (res1)))
primitive prim_X_expose :: IO (Word32)
graphicsExpose :: EventType
graphicsExpose =
  unsafePerformIO(
    prim_X_graphicsExpose >>= \ (res1) ->
    (return (res1)))
primitive prim_X_graphicsExpose :: IO (Word32)
noExpose :: EventType
noExpose =
  unsafePerformIO(
    prim_X_noExpose >>= \ (res1) ->
    (return (res1)))
primitive prim_X_noExpose :: IO (Word32)
visibilityNotify :: EventType
visibilityNotify =
  unsafePerformIO(
    prim_X_visibilityNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_visibilityNotify :: IO (Word32)
createNotify :: EventType
createNotify =
  unsafePerformIO(
    prim_X_createNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_createNotify :: IO (Word32)
destroyNotify :: EventType
destroyNotify =
  unsafePerformIO(
    prim_X_destroyNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_destroyNotify :: IO (Word32)
unmapNotify :: EventType
unmapNotify =
  unsafePerformIO(
    prim_X_unmapNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_unmapNotify :: IO (Word32)
mapNotify :: EventType
mapNotify =
  unsafePerformIO(
    prim_X_mapNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mapNotify :: IO (Word32)
mapRequest :: EventType
mapRequest =
  unsafePerformIO(
    prim_X_mapRequest >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mapRequest :: IO (Word32)
reparentNotify :: EventType
reparentNotify =
  unsafePerformIO(
    prim_X_reparentNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_reparentNotify :: IO (Word32)
configureNotify :: EventType
configureNotify =
  unsafePerformIO(
    prim_X_configureNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_configureNotify :: IO (Word32)
configureRequest :: EventType
configureRequest =
  unsafePerformIO(
    prim_X_configureRequest >>= \ (res1) ->
    (return (res1)))
primitive prim_X_configureRequest :: IO (Word32)
gravityNotify :: EventType
gravityNotify =
  unsafePerformIO(
    prim_X_gravityNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gravityNotify :: IO (Word32)
resizeRequest :: EventType
resizeRequest =
  unsafePerformIO(
    prim_X_resizeRequest >>= \ (res1) ->
    (return (res1)))
primitive prim_X_resizeRequest :: IO (Word32)
circulateNotify :: EventType
circulateNotify =
  unsafePerformIO(
    prim_X_circulateNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_circulateNotify :: IO (Word32)
circulateRequest :: EventType
circulateRequest =
  unsafePerformIO(
    prim_X_circulateRequest >>= \ (res1) ->
    (return (res1)))
primitive prim_X_circulateRequest :: IO (Word32)
propertyNotify :: EventType
propertyNotify =
  unsafePerformIO(
    prim_X_propertyNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_propertyNotify :: IO (Word32)
selectionClear :: EventType
selectionClear =
  unsafePerformIO(
    prim_X_selectionClear >>= \ (res1) ->
    (return (res1)))
primitive prim_X_selectionClear :: IO (Word32)
selectionRequest :: EventType
selectionRequest =
  unsafePerformIO(
    prim_X_selectionRequest >>= \ (res1) ->
    (return (res1)))
primitive prim_X_selectionRequest :: IO (Word32)
selectionNotify :: EventType
selectionNotify =
  unsafePerformIO(
    prim_X_selectionNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_selectionNotify :: IO (Word32)
colormapNotify :: EventType
colormapNotify =
  unsafePerformIO(
    prim_X_colormapNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_colormapNotify :: IO (Word32)
clientMessage :: EventType
clientMessage =
  unsafePerformIO(
    prim_X_clientMessage >>= \ (res1) ->
    (return (res1)))
primitive prim_X_clientMessage :: IO (Word32)
mappingNotify :: EventType
mappingNotify =
  unsafePerformIO(
    prim_X_mappingNotify >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mappingNotify :: IO (Word32)
lASTEvent :: EventType
lASTEvent =
  unsafePerformIO(
    prim_X_lASTEvent >>= \ (res1) ->
    (return (res1)))
primitive prim_X_lASTEvent :: IO (Word32)

type Modifier = Mask

shiftMapIndex :: Modifier
shiftMapIndex =
  unsafePerformIO(
    prim_X_shiftMapIndex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_shiftMapIndex :: IO (Word32)
lockMapIndex :: Modifier
lockMapIndex =
  unsafePerformIO(
    prim_X_lockMapIndex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_lockMapIndex :: IO (Word32)
controlMapIndex :: Modifier
controlMapIndex =
  unsafePerformIO(
    prim_X_controlMapIndex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_controlMapIndex :: IO (Word32)
mod1MapIndex :: Modifier
mod1MapIndex =
  unsafePerformIO(
    prim_X_mod1MapIndex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod1MapIndex :: IO (Word32)
mod2MapIndex :: Modifier
mod2MapIndex =
  unsafePerformIO(
    prim_X_mod2MapIndex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod2MapIndex :: IO (Word32)
mod3MapIndex :: Modifier
mod3MapIndex =
  unsafePerformIO(
    prim_X_mod3MapIndex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod3MapIndex :: IO (Word32)
mod4MapIndex :: Modifier
mod4MapIndex =
  unsafePerformIO(
    prim_X_mod4MapIndex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod4MapIndex :: IO (Word32)
mod5MapIndex :: Modifier
mod5MapIndex =
  unsafePerformIO(
    prim_X_mod5MapIndex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod5MapIndex :: IO (Word32)
anyModifier :: Modifier
anyModifier =
  unsafePerformIO(
    prim_X_anyModifier >>= \ (res1) ->
    (return (res1)))
primitive prim_X_anyModifier :: IO (Word32)

type KeyMask = Modifier

shiftMask :: KeyMask
shiftMask =
  unsafePerformIO(
    prim_X_shiftMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_shiftMask :: IO (Word32)
lockMask :: KeyMask
lockMask =
  unsafePerformIO(
    prim_X_lockMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_lockMask :: IO (Word32)
controlMask :: KeyMask
controlMask =
  unsafePerformIO(
    prim_X_controlMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_controlMask :: IO (Word32)
mod1Mask :: KeyMask
mod1Mask =
  unsafePerformIO(
    prim_X_mod1Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod1Mask :: IO (Word32)
mod2Mask :: KeyMask
mod2Mask =
  unsafePerformIO(
    prim_X_mod2Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod2Mask :: IO (Word32)
mod3Mask :: KeyMask
mod3Mask =
  unsafePerformIO(
    prim_X_mod3Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod3Mask :: IO (Word32)
mod4Mask :: KeyMask
mod4Mask =
  unsafePerformIO(
    prim_X_mod4Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod4Mask :: IO (Word32)
mod5Mask :: KeyMask
mod5Mask =
  unsafePerformIO(
    prim_X_mod5Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mod5Mask :: IO (Word32)

type ButtonMask = Modifier

button1Mask :: ButtonMask
button1Mask =
  unsafePerformIO(
    prim_X_button1Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button1Mask :: IO (Word32)
button2Mask :: ButtonMask
button2Mask =
  unsafePerformIO(
    prim_X_button2Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button2Mask :: IO (Word32)
button3Mask :: ButtonMask
button3Mask =
  unsafePerformIO(
    prim_X_button3Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button3Mask :: IO (Word32)
button4Mask :: ButtonMask
button4Mask =
  unsafePerformIO(
    prim_X_button4Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button4Mask :: IO (Word32)
button5Mask :: ButtonMask
button5Mask =
  unsafePerformIO(
    prim_X_button5Mask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button5Mask :: IO (Word32)

type Button = Word32

button1 :: Button
button1 =
  unsafePerformIO(
    prim_X_button1 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button1 :: IO (Word32)
button2 :: Button
button2 =
  unsafePerformIO(
    prim_X_button2 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button2 :: IO (Word32)
button3 :: Button
button3 =
  unsafePerformIO(
    prim_X_button3 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button3 :: IO (Word32)
button4 :: Button
button4 =
  unsafePerformIO(
    prim_X_button4 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button4 :: IO (Word32)
button5 :: Button
button5 =
  unsafePerformIO(
    prim_X_button5 >>= \ (res1) ->
    (return (res1)))
primitive prim_X_button5 :: IO (Word32)

type NotifyMode = Int

-- NotifyNormal and NotifyHint are used as detail in XMotionEvents
notifyNormal :: NotifyMode
notifyNormal =
  unsafePerformIO(
    prim_X_notifyNormal >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyNormal :: IO (Int)
notifyGrab :: NotifyMode
notifyGrab =
  unsafePerformIO(
    prim_X_notifyGrab >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyGrab :: IO (Int)
notifyUngrab :: NotifyMode
notifyUngrab =
  unsafePerformIO(
    prim_X_notifyUngrab >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyUngrab :: IO (Int)
notifyWhileGrabbed :: NotifyMode
notifyWhileGrabbed =
  unsafePerformIO(
    prim_X_notifyWhileGrabbed >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyWhileGrabbed :: IO (Int)
notifyHint :: NotifyMode
notifyHint =
  unsafePerformIO(
    prim_X_notifyHint >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyHint :: IO (Int)

type NotifyDetail = Int

notifyAncestor :: NotifyDetail
notifyAncestor =
  unsafePerformIO(
    prim_X_notifyAncestor >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyAncestor :: IO (Int)
notifyVirtual :: NotifyDetail
notifyVirtual =
  unsafePerformIO(
    prim_X_notifyVirtual >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyVirtual :: IO (Int)
notifyInferior :: NotifyDetail
notifyInferior =
  unsafePerformIO(
    prim_X_notifyInferior >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyInferior :: IO (Int)
notifyNonlinear :: NotifyDetail
notifyNonlinear =
  unsafePerformIO(
    prim_X_notifyNonlinear >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyNonlinear :: IO (Int)
notifyNonlinearVirtual :: NotifyDetail
notifyNonlinearVirtual =
  unsafePerformIO(
    prim_X_notifyNonlinearVirtual >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyNonlinearVirtual :: IO (Int)
notifyPointer :: NotifyDetail
notifyPointer =
  unsafePerformIO(
    prim_X_notifyPointer >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyPointer :: IO (Int)
notifyPointerRoot :: NotifyDetail
notifyPointerRoot =
  unsafePerformIO(
    prim_X_notifyPointerRoot >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyPointerRoot :: IO (Int)
notifyDetailNone :: NotifyDetail
notifyDetailNone =
  unsafePerformIO(
    prim_X_notifyDetailNone >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notifyDetailNone :: IO (Int)

type Visibility = Int
visibilityUnobscured :: Visibility
visibilityUnobscured =
  unsafePerformIO(
    prim_X_visibilityUnobscured >>= \ (res1) ->
    (return (res1)))
primitive prim_X_visibilityUnobscured :: IO (Int)
visibilityPartiallyObscured :: Visibility
visibilityPartiallyObscured =
  unsafePerformIO(
    prim_X_visibilityPartiallyObscured >>= \ (res1) ->
    (return (res1)))
primitive prim_X_visibilityPartiallyObscured :: IO (Int)
visibilityFullyObscured :: Visibility
visibilityFullyObscured =
  unsafePerformIO(
    prim_X_visibilityFullyObscured >>= \ (res1) ->
    (return (res1)))
primitive prim_X_visibilityFullyObscured :: IO (Int)

-- Window's place relative to siblings (used in Circulation requests/events)
type Place = Int
placeOnTop :: Place
placeOnTop =
  unsafePerformIO(
    prim_X_placeOnTop >>= \ (res1) ->
    (return (res1)))
primitive prim_X_placeOnTop :: IO (Int)
placeOnBottom :: Place
placeOnBottom =
  unsafePerformIO(
    prim_X_placeOnBottom >>= \ (res1) ->
    (return (res1)))
primitive prim_X_placeOnBottom :: IO (Int)

type Protocol = Int
familyInternet :: Protocol
familyInternet =
  unsafePerformIO(
    prim_X_familyInternet >>= \ (res1) ->
    (return (res1)))
primitive prim_X_familyInternet :: IO (Int)
familyDECnet :: Protocol
familyDECnet =
  unsafePerformIO(
    prim_X_familyDECnet >>= \ (res1) ->
    (return (res1)))
primitive prim_X_familyDECnet :: IO (Int)
familyChaos :: Protocol
familyChaos =
  unsafePerformIO(
    prim_X_familyChaos >>= \ (res1) ->
    (return (res1)))
primitive prim_X_familyChaos :: IO (Int)

type PropertyNotification = Int
propertyNewValue :: PropertyNotification
propertyNewValue =
  unsafePerformIO(
    prim_X_propertyNewValue >>= \ (res1) ->
    (return (res1)))
primitive prim_X_propertyNewValue :: IO (Int)
propertyDelete :: PropertyNotification
propertyDelete =
  unsafePerformIO(
    prim_X_propertyDelete >>= \ (res1) ->
    (return (res1)))
primitive prim_X_propertyDelete :: IO (Int)

type ColormapNotification = Int
colormapUninstalled :: ColormapNotification
colormapUninstalled =
  unsafePerformIO(
    prim_X_colormapUninstalled >>= \ (res1) ->
    (return (res1)))
primitive prim_X_colormapUninstalled :: IO (Int)
colormapInstalled :: ColormapNotification
colormapInstalled =
  unsafePerformIO(
    prim_X_colormapInstalled >>= \ (res1) ->
    (return (res1)))
primitive prim_X_colormapInstalled :: IO (Int)


-- Grab{Pointer,Button,Keyboard,Key} Modes
type GrabMode = Int
grabModeSync :: GrabMode
grabModeSync =
  unsafePerformIO(
    prim_X_grabModeSync >>= \ (res1) ->
    (return (res1)))
primitive prim_X_grabModeSync :: IO (Int)
grabModeAsync :: GrabMode
grabModeAsync =
  unsafePerformIO(
    prim_X_grabModeAsync >>= \ (res1) ->
    (return (res1)))
primitive prim_X_grabModeAsync :: IO (Int)

-- Grab{Pointer,Keyboard} reply status

type GrabStatus = Int
grabSuccess :: GrabStatus
grabSuccess =
  unsafePerformIO(
    prim_X_grabSuccess >>= \ (res1) ->
    (return (res1)))
primitive prim_X_grabSuccess :: IO (Int)
alreadyGrabbed :: GrabStatus
alreadyGrabbed =
  unsafePerformIO(
    prim_X_alreadyGrabbed >>= \ (res1) ->
    (return (res1)))
primitive prim_X_alreadyGrabbed :: IO (Int)
grabInvalidTime :: GrabStatus
grabInvalidTime =
  unsafePerformIO(
    prim_X_grabInvalidTime >>= \ (res1) ->
    (return (res1)))
primitive prim_X_grabInvalidTime :: IO (Int)
grabNotViewable :: GrabStatus
grabNotViewable =
  unsafePerformIO(
    prim_X_grabNotViewable >>= \ (res1) ->
    (return (res1)))
primitive prim_X_grabNotViewable :: IO (Int)
grabFrozen :: GrabStatus
grabFrozen =
  unsafePerformIO(
    prim_X_grabFrozen >>= \ (res1) ->
    (return (res1)))
primitive prim_X_grabFrozen :: IO (Int)

-- AllowEvents modes
type AllowEvents = Int
asyncPointer :: AllowEvents
asyncPointer =
  unsafePerformIO(
    prim_X_asyncPointer >>= \ (res1) ->
    (return (res1)))
primitive prim_X_asyncPointer :: IO (Int)
syncPointer :: AllowEvents
syncPointer =
  unsafePerformIO(
    prim_X_syncPointer >>= \ (res1) ->
    (return (res1)))
primitive prim_X_syncPointer :: IO (Int)
replayPointer :: AllowEvents
replayPointer =
  unsafePerformIO(
    prim_X_replayPointer >>= \ (res1) ->
    (return (res1)))
primitive prim_X_replayPointer :: IO (Int)
asyncKeyboard :: AllowEvents
asyncKeyboard =
  unsafePerformIO(
    prim_X_asyncKeyboard >>= \ (res1) ->
    (return (res1)))
primitive prim_X_asyncKeyboard :: IO (Int)
syncKeyboard :: AllowEvents
syncKeyboard =
  unsafePerformIO(
    prim_X_syncKeyboard >>= \ (res1) ->
    (return (res1)))
primitive prim_X_syncKeyboard :: IO (Int)
replayKeyboard :: AllowEvents
replayKeyboard =
  unsafePerformIO(
    prim_X_replayKeyboard >>= \ (res1) ->
    (return (res1)))
primitive prim_X_replayKeyboard :: IO (Int)
asyncBoth :: AllowEvents
asyncBoth =
  unsafePerformIO(
    prim_X_asyncBoth >>= \ (res1) ->
    (return (res1)))
primitive prim_X_asyncBoth :: IO (Int)
syncBoth :: AllowEvents
syncBoth =
  unsafePerformIO(
    prim_X_syncBoth >>= \ (res1) ->
    (return (res1)))
primitive prim_X_syncBoth :: IO (Int)


-- {Set,Get}InputFocus Modes
type FocusMode = Int
revertToNone :: FocusMode
revertToNone =
  unsafePerformIO(
    prim_X_revertToNone >>= \ (res1) ->
    (return (res1)))
primitive prim_X_revertToNone :: IO (Int)
revertToPointerRoot :: FocusMode
revertToPointerRoot =
  unsafePerformIO(
    prim_X_revertToPointerRoot >>= \ (res1) ->
    (return (res1)))
primitive prim_X_revertToPointerRoot :: IO (Int)
revertToParent :: FocusMode
revertToParent =
  unsafePerformIO(
    prim_X_revertToParent >>= \ (res1) ->
    (return (res1)))
primitive prim_X_revertToParent :: IO (Int)

-- Error codes
type Status = Int
success :: Status
success =
  unsafePerformIO(
    prim_X_success >>= \ (res1) ->
    (return (res1)))
primitive prim_X_success :: IO (Int)
badRequest :: Status
badRequest =
  unsafePerformIO(
    prim_X_badRequest >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badRequest :: IO (Int)
badValue :: Status
badValue =
  unsafePerformIO(
    prim_X_badValue >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badValue :: IO (Int)
badWindow :: Status
badWindow =
  unsafePerformIO(
    prim_X_badWindow >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badWindow :: IO (Int)
badPixmap :: Status
badPixmap =
  unsafePerformIO(
    prim_X_badPixmap >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badPixmap :: IO (Int)
badAtom :: Status
badAtom =
  unsafePerformIO(
    prim_X_badAtom >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badAtom :: IO (Int)
badCursor :: Status
badCursor =
  unsafePerformIO(
    prim_X_badCursor >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badCursor :: IO (Int)
badFont :: Status
badFont =
  unsafePerformIO(
    prim_X_badFont >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badFont :: IO (Int)
badMatch :: Status
badMatch =
  unsafePerformIO(
    prim_X_badMatch >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badMatch :: IO (Int)
badDrawable :: Status
badDrawable =
  unsafePerformIO(
    prim_X_badDrawable >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badDrawable :: IO (Int)
badAccess :: Status
badAccess =
  unsafePerformIO(
    prim_X_badAccess >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badAccess :: IO (Int)
badAlloc :: Status
badAlloc =
  unsafePerformIO(
    prim_X_badAlloc >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badAlloc :: IO (Int)
badColor :: Status
badColor =
  unsafePerformIO(
    prim_X_badColor >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badColor :: IO (Int)
badGC :: Status
badGC =
  unsafePerformIO(
    prim_X_badGC >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badGC :: IO (Int)
badIDChoice :: Status
badIDChoice =
  unsafePerformIO(
    prim_X_badIDChoice >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badIDChoice :: IO (Int)
badName :: Status
badName =
  unsafePerformIO(
    prim_X_badName >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badName :: IO (Int)
badLength :: Status
badLength =
  unsafePerformIO(
    prim_X_badLength >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badLength :: IO (Int)
badImplementation :: Status
badImplementation =
  unsafePerformIO(
    prim_X_badImplementation >>= \ (res1) ->
    (return (res1)))
primitive prim_X_badImplementation :: IO (Int)
firstExtensionError :: Status
firstExtensionError =
  unsafePerformIO(
    prim_X_firstExtensionError >>= \ (res1) ->
    (return (res1)))
primitive prim_X_firstExtensionError :: IO (Int)
lastExtensionError :: Status
lastExtensionError =
  unsafePerformIO(
    prim_X_lastExtensionError >>= \ (res1) ->
    (return (res1)))
primitive prim_X_lastExtensionError :: IO (Int)

type WindowClass = Int
copyFromParent :: WindowClass
copyFromParent =
  unsafePerformIO(
    prim_X_copyFromParent >>= \ (res1) ->
    (return (res1)))
primitive prim_X_copyFromParent :: IO (Int)
inputOutput :: WindowClass
inputOutput =
  unsafePerformIO(
    prim_X_inputOutput >>= \ (res1) ->
    (return (res1)))
primitive prim_X_inputOutput :: IO (Int)
inputOnly :: WindowClass
inputOnly =
  unsafePerformIO(
    prim_X_inputOnly >>= \ (res1) ->
    (return (res1)))
primitive prim_X_inputOnly :: IO (Int)

-- Window attributes mask
type AttributeMask = Mask 

cWBackPixmap :: AttributeMask
cWBackPixmap =
  unsafePerformIO(
    prim_X_cWBackPixmap >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWBackPixmap :: IO (Word32)
cWBackPixel :: AttributeMask
cWBackPixel =
  unsafePerformIO(
    prim_X_cWBackPixel >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWBackPixel :: IO (Word32)
cWBorderPixmap :: AttributeMask
cWBorderPixmap =
  unsafePerformIO(
    prim_X_cWBorderPixmap >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWBorderPixmap :: IO (Word32)
cWBorderPixel :: AttributeMask
cWBorderPixel =
  unsafePerformIO(
    prim_X_cWBorderPixel >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWBorderPixel :: IO (Word32)
cWBitGravity :: AttributeMask
cWBitGravity =
  unsafePerformIO(
    prim_X_cWBitGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWBitGravity :: IO (Word32)
cWWinGravity :: AttributeMask
cWWinGravity =
  unsafePerformIO(
    prim_X_cWWinGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWWinGravity :: IO (Word32)
cWBackingStore :: AttributeMask
cWBackingStore =
  unsafePerformIO(
    prim_X_cWBackingStore >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWBackingStore :: IO (Word32)
cWBackingPlanes :: AttributeMask
cWBackingPlanes =
  unsafePerformIO(
    prim_X_cWBackingPlanes >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWBackingPlanes :: IO (Word32)
cWBackingPixel :: AttributeMask
cWBackingPixel =
  unsafePerformIO(
    prim_X_cWBackingPixel >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWBackingPixel :: IO (Word32)
cWOverrideRedirect :: AttributeMask
cWOverrideRedirect =
  unsafePerformIO(
    prim_X_cWOverrideRedirect >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWOverrideRedirect :: IO (Word32)
cWSaveUnder :: AttributeMask
cWSaveUnder =
  unsafePerformIO(
    prim_X_cWSaveUnder >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWSaveUnder :: IO (Word32)
cWEventMask :: AttributeMask
cWEventMask =
  unsafePerformIO(
    prim_X_cWEventMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWEventMask :: IO (Word32)
cWDontPropagate :: AttributeMask
cWDontPropagate =
  unsafePerformIO(
    prim_X_cWDontPropagate >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWDontPropagate :: IO (Word32)
cWColormap :: AttributeMask
cWColormap =
  unsafePerformIO(
    prim_X_cWColormap >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWColormap :: IO (Word32)
cWCursor :: AttributeMask
cWCursor =
  unsafePerformIO(
    prim_X_cWCursor >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cWCursor :: IO (Word32)

-- Used in ChangeCloseDownMode 
type CloseDownMode = Int 

destroyAll :: CloseDownMode
destroyAll =
  unsafePerformIO(
    prim_X_destroyAll >>= \ (res1) ->
    (return (res1)))
primitive prim_X_destroyAll :: IO (Int)
retainPermanent :: CloseDownMode
retainPermanent =
  unsafePerformIO(
    prim_X_retainPermanent >>= \ (res1) ->
    (return (res1)))
primitive prim_X_retainPermanent :: IO (Int)
retainTemporary :: CloseDownMode
retainTemporary =
  unsafePerformIO(
    prim_X_retainTemporary >>= \ (res1) ->
    (return (res1)))
primitive prim_X_retainTemporary :: IO (Int)


----------------------------------------------------------------
-- CURSOR STUFF
----------------------------------------------------------------

type QueryBestSizeClass = Int 
cursorShape :: QueryBestSizeClass
cursorShape =
  unsafePerformIO(
    prim_X_cursorShape >>= \ (res1) ->
    (return (res1)))
primitive prim_X_cursorShape :: IO (Int)
tileShape :: QueryBestSizeClass
tileShape =
  unsafePerformIO(
    prim_X_tileShape >>= \ (res1) ->
    (return (res1)))
primitive prim_X_tileShape :: IO (Int)
stippleShape :: QueryBestSizeClass
stippleShape =
  unsafePerformIO(
    prim_X_stippleShape >>= \ (res1) ->
    (return (res1)))
primitive prim_X_stippleShape :: IO (Int)

----------------------------------------------------------------
-- GRAPHICS DEFINITIONS
----------------------------------------------------------------

-- graphics functions, as in GC.alu

type   GXFunction   = Int 
gXclear :: GXFunction
gXclear =
  unsafePerformIO(
    prim_X_gXclear >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXclear :: IO (Int)
gXand :: GXFunction
gXand =
  unsafePerformIO(
    prim_X_gXand >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXand :: IO (Int)
gXandReverse :: GXFunction
gXandReverse =
  unsafePerformIO(
    prim_X_gXandReverse >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXandReverse :: IO (Int)
gXcopy :: GXFunction
gXcopy =
  unsafePerformIO(
    prim_X_gXcopy >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXcopy :: IO (Int)
gXandInverted :: GXFunction
gXandInverted =
  unsafePerformIO(
    prim_X_gXandInverted >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXandInverted :: IO (Int)
gXnoop :: GXFunction
gXnoop =
  unsafePerformIO(
    prim_X_gXnoop >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXnoop :: IO (Int)
gXxor :: GXFunction
gXxor =
  unsafePerformIO(
    prim_X_gXxor >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXxor :: IO (Int)
gXor :: GXFunction
gXor =
  unsafePerformIO(
    prim_X_gXor >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXor :: IO (Int)
gXnor :: GXFunction
gXnor =
  unsafePerformIO(
    prim_X_gXnor >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXnor :: IO (Int)
gXequiv :: GXFunction
gXequiv =
  unsafePerformIO(
    prim_X_gXequiv >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXequiv :: IO (Int)
gXinvert :: GXFunction
gXinvert =
  unsafePerformIO(
    prim_X_gXinvert >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXinvert :: IO (Int)
gXorReverse :: GXFunction
gXorReverse =
  unsafePerformIO(
    prim_X_gXorReverse >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXorReverse :: IO (Int)
gXcopyInverted :: GXFunction
gXcopyInverted =
  unsafePerformIO(
    prim_X_gXcopyInverted >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXcopyInverted :: IO (Int)
gXorInverted :: GXFunction
gXorInverted =
  unsafePerformIO(
    prim_X_gXorInverted >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXorInverted :: IO (Int)
gXnand :: GXFunction
gXnand =
  unsafePerformIO(
    prim_X_gXnand >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXnand :: IO (Int)
gXset :: GXFunction
gXset =
  unsafePerformIO(
    prim_X_gXset >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gXset :: IO (Int)

type   LineStyle   = Int 
lineSolid :: LineStyle
lineSolid =
  unsafePerformIO(
    prim_X_lineSolid >>= \ (res1) ->
    (return (res1)))
primitive prim_X_lineSolid :: IO (Int)
lineOnOffDash :: LineStyle
lineOnOffDash =
  unsafePerformIO(
    prim_X_lineOnOffDash >>= \ (res1) ->
    (return (res1)))
primitive prim_X_lineOnOffDash :: IO (Int)
lineDoubleDash :: LineStyle
lineDoubleDash =
  unsafePerformIO(
    prim_X_lineDoubleDash >>= \ (res1) ->
    (return (res1)))
primitive prim_X_lineDoubleDash :: IO (Int)

type   CapStyle   = Int 
capNotLast :: CapStyle
capNotLast =
  unsafePerformIO(
    prim_X_capNotLast >>= \ (res1) ->
    (return (res1)))
primitive prim_X_capNotLast :: IO (Int)
capButt :: CapStyle
capButt =
  unsafePerformIO(
    prim_X_capButt >>= \ (res1) ->
    (return (res1)))
primitive prim_X_capButt :: IO (Int)
capRound :: CapStyle
capRound =
  unsafePerformIO(
    prim_X_capRound >>= \ (res1) ->
    (return (res1)))
primitive prim_X_capRound :: IO (Int)
capProjecting :: CapStyle
capProjecting =
  unsafePerformIO(
    prim_X_capProjecting >>= \ (res1) ->
    (return (res1)))
primitive prim_X_capProjecting :: IO (Int)

type   JoinStyle   = Int 
joinMiter :: JoinStyle
joinMiter =
  unsafePerformIO(
    prim_X_joinMiter >>= \ (res1) ->
    (return (res1)))
primitive prim_X_joinMiter :: IO (Int)
joinRound :: JoinStyle
joinRound =
  unsafePerformIO(
    prim_X_joinRound >>= \ (res1) ->
    (return (res1)))
primitive prim_X_joinRound :: IO (Int)
joinBevel :: JoinStyle
joinBevel =
  unsafePerformIO(
    prim_X_joinBevel >>= \ (res1) ->
    (return (res1)))
primitive prim_X_joinBevel :: IO (Int)

type   FillStyle   = Int 
fillSolid :: FillStyle
fillSolid =
  unsafePerformIO(
    prim_X_fillSolid >>= \ (res1) ->
    (return (res1)))
primitive prim_X_fillSolid :: IO (Int)
fillTiled :: FillStyle
fillTiled =
  unsafePerformIO(
    prim_X_fillTiled >>= \ (res1) ->
    (return (res1)))
primitive prim_X_fillTiled :: IO (Int)
fillStippled :: FillStyle
fillStippled =
  unsafePerformIO(
    prim_X_fillStippled >>= \ (res1) ->
    (return (res1)))
primitive prim_X_fillStippled :: IO (Int)
fillOpaqueStippled :: FillStyle
fillOpaqueStippled =
  unsafePerformIO(
    prim_X_fillOpaqueStippled >>= \ (res1) ->
    (return (res1)))
primitive prim_X_fillOpaqueStippled :: IO (Int)

type   FillRule   = Int 
evenOddRule :: FillRule
evenOddRule =
  unsafePerformIO(
    prim_X_evenOddRule >>= \ (res1) ->
    (return (res1)))
primitive prim_X_evenOddRule :: IO (Int)
windingRule :: FillRule
windingRule =
  unsafePerformIO(
    prim_X_windingRule >>= \ (res1) ->
    (return (res1)))
primitive prim_X_windingRule :: IO (Int)

type   SubWindowMode   = Int 
clipByChildren :: SubWindowMode
clipByChildren =
  unsafePerformIO(
    prim_X_clipByChildren >>= \ (res1) ->
    (return (res1)))
primitive prim_X_clipByChildren :: IO (Int)
includeInferiors :: SubWindowMode
includeInferiors =
  unsafePerformIO(
    prim_X_includeInferiors >>= \ (res1) ->
    (return (res1)))
primitive prim_X_includeInferiors :: IO (Int)

-- -- SetClipRectangles ordering 
-- type   Ordering        = Int 
-- %dis   ordering      x = int x
-- %const Ordering
-- % [ Unsorted         
-- % , YSorted          
-- % , YXSorted         
-- % , YXBanded         
-- % ]

-- CoordinateMode for drawing routines 
type   CoordinateMode   = Int 
coordModeOrigin :: CoordinateMode
coordModeOrigin =
  unsafePerformIO(
    prim_X_coordModeOrigin >>= \ (res1) ->
    (return (res1)))
primitive prim_X_coordModeOrigin :: IO (Int)
coordModePrevious :: CoordinateMode
coordModePrevious =
  unsafePerformIO(
    prim_X_coordModePrevious >>= \ (res1) ->
    (return (res1)))
primitive prim_X_coordModePrevious :: IO (Int)

type   PolygonShape   = Int 
complex :: PolygonShape
complex =
  unsafePerformIO(
    prim_X_complex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_complex :: IO (Int)
nonconvex :: PolygonShape
nonconvex =
  unsafePerformIO(
    prim_X_nonconvex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_nonconvex :: IO (Int)
convex :: PolygonShape
convex =
  unsafePerformIO(
    prim_X_convex >>= \ (res1) ->
    (return (res1)))
primitive prim_X_convex :: IO (Int)

-- Arc modes for PolyFillArc 
type   ArcMode   = Int 
arcChord :: ArcMode
arcChord =
  unsafePerformIO(
    prim_X_arcChord >>= \ (res1) ->
    (return (res1)))
primitive prim_X_arcChord :: IO (Int)
arcPieSlice :: ArcMode
arcPieSlice =
  unsafePerformIO(
    prim_X_arcPieSlice >>= \ (res1) ->
    (return (res1)))
primitive prim_X_arcPieSlice :: IO (Int)

-- GC components: masks used in CreateGC, CopyGC, ChangeGC, OR'ed into
-- GC.stateChanges 

type   GCMask   = Int 
gCFunction :: GCMask
gCFunction =
  unsafePerformIO(
    prim_X_gCFunction >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCFunction :: IO (Int)
gCPlaneMask :: GCMask
gCPlaneMask =
  unsafePerformIO(
    prim_X_gCPlaneMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCPlaneMask :: IO (Int)
gCForeground :: GCMask
gCForeground =
  unsafePerformIO(
    prim_X_gCForeground >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCForeground :: IO (Int)
gCBackground :: GCMask
gCBackground =
  unsafePerformIO(
    prim_X_gCBackground >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCBackground :: IO (Int)
gCLineWidth :: GCMask
gCLineWidth =
  unsafePerformIO(
    prim_X_gCLineWidth >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCLineWidth :: IO (Int)
gCLineStyle :: GCMask
gCLineStyle =
  unsafePerformIO(
    prim_X_gCLineStyle >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCLineStyle :: IO (Int)
gCCapStyle :: GCMask
gCCapStyle =
  unsafePerformIO(
    prim_X_gCCapStyle >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCCapStyle :: IO (Int)
gCJoinStyle :: GCMask
gCJoinStyle =
  unsafePerformIO(
    prim_X_gCJoinStyle >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCJoinStyle :: IO (Int)
gCFillStyle :: GCMask
gCFillStyle =
  unsafePerformIO(
    prim_X_gCFillStyle >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCFillStyle :: IO (Int)
gCFillRule :: GCMask
gCFillRule =
  unsafePerformIO(
    prim_X_gCFillRule >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCFillRule :: IO (Int)
gCTile :: GCMask
gCTile =
  unsafePerformIO(
    prim_X_gCTile >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCTile :: IO (Int)
gCStipple :: GCMask
gCStipple =
  unsafePerformIO(
    prim_X_gCStipple >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCStipple :: IO (Int)
gCTileStipXOrigin :: GCMask
gCTileStipXOrigin =
  unsafePerformIO(
    prim_X_gCTileStipXOrigin >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCTileStipXOrigin :: IO (Int)
gCTileStipYOrigin :: GCMask
gCTileStipYOrigin =
  unsafePerformIO(
    prim_X_gCTileStipYOrigin >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCTileStipYOrigin :: IO (Int)
gCFont :: GCMask
gCFont =
  unsafePerformIO(
    prim_X_gCFont >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCFont :: IO (Int)
gCSubwindowMode :: GCMask
gCSubwindowMode =
  unsafePerformIO(
    prim_X_gCSubwindowMode >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCSubwindowMode :: IO (Int)
gCGraphicsExposures :: GCMask
gCGraphicsExposures =
  unsafePerformIO(
    prim_X_gCGraphicsExposures >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCGraphicsExposures :: IO (Int)
gCClipXOrigin :: GCMask
gCClipXOrigin =
  unsafePerformIO(
    prim_X_gCClipXOrigin >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCClipXOrigin :: IO (Int)
gCClipYOrigin :: GCMask
gCClipYOrigin =
  unsafePerformIO(
    prim_X_gCClipYOrigin >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCClipYOrigin :: IO (Int)
gCClipMask :: GCMask
gCClipMask =
  unsafePerformIO(
    prim_X_gCClipMask >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCClipMask :: IO (Int)
gCDashOffset :: GCMask
gCDashOffset =
  unsafePerformIO(
    prim_X_gCDashOffset >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCDashOffset :: IO (Int)
gCDashList :: GCMask
gCDashList =
  unsafePerformIO(
    prim_X_gCDashList >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCDashList :: IO (Int)
gCArcMode :: GCMask
gCArcMode =
  unsafePerformIO(
    prim_X_gCArcMode >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCArcMode :: IO (Int)
gCLastBit :: GCMask
gCLastBit =
  unsafePerformIO(
    prim_X_gCLastBit >>= \ (res1) ->
    (return (res1)))
primitive prim_X_gCLastBit :: IO (Int)

type   CirculationDirection = Int 
raiseLowest :: CirculationDirection
raiseLowest =
  unsafePerformIO(
    prim_X_raiseLowest >>= \ (res1) ->
    (return (res1)))
primitive prim_X_raiseLowest :: IO (Int)
lowerHighest :: CirculationDirection
lowerHighest =
  unsafePerformIO(
    prim_X_lowerHighest >>= \ (res1) ->
    (return (res1)))
primitive prim_X_lowerHighest :: IO (Int)

-- used in imageByteOrder and bitmapBitOrder 
type   ByteOrder   = Int 
lSBFirst :: ByteOrder
lSBFirst =
  unsafePerformIO(
    prim_X_lSBFirst >>= \ (res1) ->
    (return (res1)))
primitive prim_X_lSBFirst :: IO (Int)
mSBFirst :: ByteOrder
mSBFirst =
  unsafePerformIO(
    prim_X_mSBFirst >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mSBFirst :: IO (Int)

type   ColormapAlloc   = Int
allocNone :: ColormapAlloc
allocNone =
  unsafePerformIO(
    prim_X_allocNone >>= \ (res1) ->
    (return (res1)))
primitive prim_X_allocNone :: IO (Int)
allocAll :: ColormapAlloc
allocAll =
  unsafePerformIO(
    prim_X_allocAll >>= \ (res1) ->
    (return (res1)))
primitive prim_X_allocAll :: IO (Int)

type   MappingRequest   = Int
mappingModifier :: MappingRequest
mappingModifier =
  unsafePerformIO(
    prim_X_mappingModifier >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mappingModifier :: IO (Int)
mappingKeyboard :: MappingRequest
mappingKeyboard =
  unsafePerformIO(
    prim_X_mappingKeyboard >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mappingKeyboard :: IO (Int)
mappingPointer :: MappingRequest
mappingPointer =
  unsafePerformIO(
    prim_X_mappingPointer >>= \ (res1) ->
    (return (res1)))
primitive prim_X_mappingPointer :: IO (Int)


type   ChangeSaveSetMode = Int
setModeInsert :: ChangeSaveSetMode
setModeInsert =
  unsafePerformIO(
    prim_X_setModeInsert >>= \ (res1) ->
    (return (res1)))
primitive prim_X_setModeInsert :: IO (Int)
setModeDelete :: ChangeSaveSetMode
setModeDelete =
  unsafePerformIO(
    prim_X_setModeDelete >>= \ (res1) ->
    (return (res1)))
primitive prim_X_setModeDelete :: IO (Int)

type   BitGravity      = Int
forgetGravity :: BitGravity
forgetGravity =
  unsafePerformIO(
    prim_X_forgetGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_forgetGravity :: IO (Int)
northWestGravity :: BitGravity
northWestGravity =
  unsafePerformIO(
    prim_X_northWestGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_northWestGravity :: IO (Int)
northGravity :: BitGravity
northGravity =
  unsafePerformIO(
    prim_X_northGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_northGravity :: IO (Int)
northEastGravity :: BitGravity
northEastGravity =
  unsafePerformIO(
    prim_X_northEastGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_northEastGravity :: IO (Int)
westGravity :: BitGravity
westGravity =
  unsafePerformIO(
    prim_X_westGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_westGravity :: IO (Int)
centerGravity :: BitGravity
centerGravity =
  unsafePerformIO(
    prim_X_centerGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_centerGravity :: IO (Int)
eastGravity :: BitGravity
eastGravity =
  unsafePerformIO(
    prim_X_eastGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_eastGravity :: IO (Int)
southWestGravity :: BitGravity
southWestGravity =
  unsafePerformIO(
    prim_X_southWestGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_southWestGravity :: IO (Int)
southGravity :: BitGravity
southGravity =
  unsafePerformIO(
    prim_X_southGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_southGravity :: IO (Int)
southEastGravity :: BitGravity
southEastGravity =
  unsafePerformIO(
    prim_X_southEastGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_southEastGravity :: IO (Int)
staticGravity :: BitGravity
staticGravity =
  unsafePerformIO(
    prim_X_staticGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_staticGravity :: IO (Int)

-- All the BitGravity's plus ...
type   WindowGravity   = Int
unmapGravity :: WindowGravity
unmapGravity =
  unsafePerformIO(
    prim_X_unmapGravity >>= \ (res1) ->
    (return (res1)))
primitive prim_X_unmapGravity :: IO (Int)

-- Used in CreateWindow for backing-store hint 
type   BackingStore    = Int
notUseful :: BackingStore
notUseful =
  unsafePerformIO(
    prim_X_notUseful >>= \ (res1) ->
    (return (res1)))
primitive prim_X_notUseful :: IO (Int)
whenMapped :: BackingStore
whenMapped =
  unsafePerformIO(
    prim_X_whenMapped >>= \ (res1) ->
    (return (res1)))
primitive prim_X_whenMapped :: IO (Int)
always :: BackingStore
always =
  unsafePerformIO(
    prim_X_always >>= \ (res1) ->
    (return (res1)))
primitive prim_X_always :: IO (Int)

doRed :: Word8
doRed =
  unsafePerformIO(
    prim_X_doRed >>= \ (res1) ->
    let gc_res1 = ( word32ToWord8   (res1)) in
    (return (gc_res1)))
primitive prim_X_doRed :: IO (Word32)
doGreen :: Word8
doGreen =
  unsafePerformIO(
    prim_X_doGreen >>= \ (res1) ->
    let gc_res1 = ( word32ToWord8   (res1)) in
    (return (gc_res1)))
primitive prim_X_doGreen :: IO (Word32)
doBlue :: Word8
doBlue =
  unsafePerformIO(
    prim_X_doBlue >>= \ (res1) ->
    let gc_res1 = ( word32ToWord8   (res1)) in
    (return (gc_res1)))
primitive prim_X_doBlue :: IO (Word32)

type   FontDirection    = Int
fontLeftToRight :: FontDirection
fontLeftToRight =
  unsafePerformIO(
    prim_X_fontLeftToRight >>= \ (res1) ->
    (return (res1)))
primitive prim_X_fontLeftToRight :: IO (Int)
fontRightToLeft :: FontDirection
fontRightToLeft =
  unsafePerformIO(
    prim_X_fontRightToLeft >>= \ (res1) ->
    (return (res1)))
primitive prim_X_fontRightToLeft :: IO (Int)
needPrims_hugs 3
