module Xlib 
	( module X
	, module Xlib
	, free
	) where

import Xlib_StdDIS
import Monad( zipWithM_ )

import X



type Pixel        = Word32
type Position     = Int32
type Dimension    = Word32
type ScreenNumber = Word32
type Byte         = Char
type Buffer       = Int


newtype Display    = Display    Addr
newtype Screen     = Screen     Addr
newtype Visual     = Visual     Addr
newtype FontStruct = FontStruct Addr
newtype Region     = Region     ForeignObj



type GC = Addr

type Point = 
  ( Position  -- x
  , Position  -- y
  )

type Segment = 
 ( Position -- x1
 , Position -- y1
 , Position -- x2
 , Position -- y2
 )

type Rectangle = 
 ( Position  -- x
 , Position  -- y
 , Dimension -- width
 , Dimension -- height
 )

type Arc =
 ( Position  
 , Position  
 , Dimension 
 , Dimension 
 , Int       
 , Int       
 )

type Color =
 ( Pixel 
 , Word16 
 , Word16 
 , Word16 
 , Word8 
 )

-- don't forget to use %end free(arg?) in conjunction with these guys
type ListPoint       	= [Point]
type ListRectangle   	= [Rectangle]	     
type ListArc        	= [Arc]	     
type ListSegment       = [Segment]	     
type ListColor	     	= [Color]	     
type ListPixel	     	= [Pixel]
type ListWindow	     	= [Window]
-- AC, 1/9/2000: Try to define types and marshalling code for Atom lists:
type ListAtom	     	= [Atom]




marshallAddrList :: (Int -> IO Addr) -> (Addr -> Int -> a -> IO ()) -> [a] -> IO (Addr, Int)
marshallAddrList alloc write as = do
  let l = length as
  arr <- alloc l
  zipWithM_ (write arr) [0..] as
  return (arr, l)

unmarshallAddrList :: (Addr -> Int -> IO a) -> (Addr, Int) -> IO [a]
unmarshallAddrList read (ptr,l) = mapM (read ptr) [0..l-1]

writeAddr :: Addr -> Int -> Addr -> IO ()
writeAddr s i v =
  prim_Xlib_writeAddr s i v
primitive prim_Xlib_writeAddr :: Addr -> Int -> Addr -> IO ()
 
readAddr :: Addr -> Int -> IO Addr
readAddr s i =
  prim_Xlib_readAddr s i >>= \ (gc_res1) ->
  (return (gc_res1))
primitive prim_Xlib_readAddr :: Addr -> Int -> IO (Addr)

allocAddr :: Int -> IO Addr
allocAddr arg1 =
  prim_Xlib_allocAddr arg1 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_allocAddr :: Int -> IO (Addr)
  

writePoint :: Addr -> Int -> Point -> IO ()
writePoint s i gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  prim_Xlib_writePoint s i gc_arg3 gc_arg5}}}
primitive prim_Xlib_writePoint :: Addr -> Int -> Int -> Int -> IO ()
readPoint :: Addr -> Int -> IO Point
readPoint s i =
  prim_Xlib_readPoint s i >>= \ (gc_res2,gc_res4) ->
  let gc_res1 = ( intToInt32  (gc_res2)) in
  let gc_res3 = ( intToInt32  (gc_res4)) in
  (return ((gc_res1,gc_res3)))
primitive prim_Xlib_readPoint :: Addr -> Int -> IO (Int,Int)
allocPoints :: Int -> IO Addr
allocPoints arg1 =
  prim_Xlib_allocPoints arg1 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_allocPoints :: Int -> IO (Addr)

writeRectangle :: Addr -> Int -> Rectangle -> IO ()
writeRectangle s i gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg7) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  prim_Xlib_writeRectangle s i gc_arg3 gc_arg5 gc_arg6 gc_arg7}}}
primitive prim_Xlib_writeRectangle :: Addr -> Int -> Int -> Int -> Word32 -> Word32 -> IO ()
readRectangle :: Addr -> Int -> IO Rectangle
readRectangle s i =
  prim_Xlib_readRectangle s i >>= \ (gc_res2,gc_res4,gc_res5,gc_res6) ->
  let gc_res1 = ( intToInt32  (gc_res2)) in
  let gc_res3 = ( intToInt32  (gc_res4)) in
  (return ((gc_res1,gc_res3,gc_res5,gc_res6)))
primitive prim_Xlib_readRectangle :: Addr -> Int -> IO (Int,Int,Word32,Word32)
allocRectangles :: Int -> IO Addr
allocRectangles arg1 =
  prim_Xlib_allocRectangles arg1 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_allocRectangles :: Int -> IO (Addr)

writeArc :: Addr -> Int -> Arc -> IO ()
writeArc s i gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg7,gc_arg8,gc_arg9) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  prim_Xlib_writeArc s i gc_arg3 gc_arg5 gc_arg6 gc_arg7 gc_arg8 gc_arg9}}}
primitive prim_Xlib_writeArc :: Addr -> Int -> Int -> Int -> Word32 -> Word32 -> Int -> Int -> IO ()
readArc :: Addr -> Int -> IO Arc
readArc s i =
  prim_Xlib_readArc s i >>= \ (gc_res2,gc_res4,gc_res5,gc_res6,gc_res7,gc_res8) ->
  let gc_res1 = ( intToInt32  (gc_res2)) in
  let gc_res3 = ( intToInt32  (gc_res4)) in
  (return ((gc_res1,gc_res3,gc_res5,gc_res6,gc_res7,gc_res8)))
primitive prim_Xlib_readArc :: Addr -> Int -> IO (Int,Int,Word32,Word32,Int,Int)
allocArcs :: Int -> IO Addr
allocArcs arg1 =
  prim_Xlib_allocArcs arg1 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_allocArcs :: Int -> IO (Addr)

writeSegment :: Addr -> Int -> Segment -> IO ()
writeSegment s i gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg8) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  case ( int32ToInt  gc_arg6) of { gc_arg7 ->
  case ( int32ToInt  gc_arg8) of { gc_arg9 ->
  prim_Xlib_writeSegment s i gc_arg3 gc_arg5 gc_arg7 gc_arg9}}}}}
primitive prim_Xlib_writeSegment :: Addr -> Int -> Int -> Int -> Int -> Int -> IO ()
readSegment :: Addr -> Int -> IO Segment
readSegment s i =
  prim_Xlib_readSegment s i >>= \ (gc_res2,gc_res4,gc_res6,gc_res8) ->
  let gc_res1 = ( intToInt32  (gc_res2)) in
  let gc_res3 = ( intToInt32  (gc_res4)) in
  let gc_res5 = ( intToInt32  (gc_res6)) in
  let gc_res7 = ( intToInt32  (gc_res8)) in
  (return ((gc_res1,gc_res3,gc_res5,gc_res7)))
primitive prim_Xlib_readSegment :: Addr -> Int -> IO (Int,Int,Int,Int)
allocSegments :: Int -> IO Addr
allocSegments arg1 =
  prim_Xlib_allocSegments arg1 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_allocSegments :: Int -> IO (Addr)

writeColor :: Addr -> Int -> Color -> IO ()
writeColor s i gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg3,gc_arg5,gc_arg7,gc_arg9) ->
  case ( word16ToWord32  gc_arg3) of { gc_arg4 ->
  case ( word16ToWord32  gc_arg5) of { gc_arg6 ->
  case ( word16ToWord32  gc_arg7) of { gc_arg8 ->
  case ( word8ToWord32   gc_arg9) of { gc_arg10 ->
  prim_Xlib_writeColor s i gc_arg2 gc_arg4 gc_arg6 gc_arg8 gc_arg10}}}}}
primitive prim_Xlib_writeColor :: Addr -> Int -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> IO ()
readColor :: Addr -> Int -> IO Color
readColor s i =
  prim_Xlib_readColor s i >>= \ (gc_res1,gc_res3,gc_res5,gc_res7,gc_res9) ->
  let gc_res2 = ( word32ToWord16  (gc_res3)) in
  let gc_res4 = ( word32ToWord16  (gc_res5)) in
  let gc_res6 = ( word32ToWord16  (gc_res7)) in
  let gc_res8 = ( word32ToWord8   (gc_res9)) in
  (return ((gc_res1,gc_res2,gc_res4,gc_res6,gc_res8)))
primitive prim_Xlib_readColor :: Addr -> Int -> IO (Word32,Word32,Word32,Word32,Word32)
allocColors :: Int -> IO Addr
allocColors arg1 =
  prim_Xlib_allocColors arg1 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_allocColors :: Int -> IO (Addr)


marshallWord32List :: [Word32] -> IO (Addr, Int)
marshallWord32List as = do
  let l = length as
  arr <- allocWord32Star l
  zipWithM_ (writeWord32 arr) [0..] as
  return (arr, l)

unmarshallWord32List :: (Addr, Int) -> IO [Word32]
unmarshallWord32List (ptr,l) = mapM (readWord32 ptr) [0..l-1]

writeWord32 :: Addr -> Int -> Word32 -> IO ()
writeWord32 s i v =
  prim_Xlib_writeWord32 s i v
primitive prim_Xlib_writeWord32 :: Addr -> Int -> Word32 -> IO ()
 
readWord32 :: Addr -> Int -> IO Word32
readWord32 s i =
  prim_Xlib_readWord32 s i >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_readWord32 :: Addr -> Int -> IO (Word32)

allocWord32Star :: Int -> IO Addr
allocWord32Star arg1 =
  prim_Xlib_allocWord32Star arg1 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_allocWord32Star :: Int -> IO (Addr)
  

allPlanes :: Pixel
allPlanes =
  unsafePerformIO(
    prim_Xlib_allPlanes >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_allPlanes :: IO (Word32)
blackPixel :: Display -> ScreenNumber -> Pixel
blackPixel gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_blackPixel arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_blackPixel :: Addr -> Word32 -> IO (Word32)
whitePixel :: Display -> ScreenNumber -> Pixel
whitePixel gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_whitePixel arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_whitePixel :: Addr -> Word32 -> IO (Word32)

-- This may vary from one execution to another but I believe it 
-- is constant during any given execution and so it can be made PURE
-- without breaking referential transparency.
--
-- Note: underneath the opaque name, it turns out that this
-- is the file descriptor.  You need to know this if you want to
-- use select.
connectionNumber :: Display -> Int
connectionNumber gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_connectionNumber arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_connectionNumber :: Addr -> IO (Int)

defaultColormap :: Display -> ScreenNumber -> Colormap
defaultColormap gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_defaultColormap arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_defaultColormap :: Addr -> Word32 -> IO (Word32)

-- %fun XListDepths :: Display -> ScreenNumber -> ListInt using res1 = XListDepths(arg1,arg2,&res1_size)

defaultGC :: Display -> ScreenNumber -> GC
defaultGC gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_defaultGC arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_defaultGC :: Addr -> Word32 -> IO (Addr)
defaultDepth :: Display -> ScreenNumber -> Int
defaultDepth gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_defaultDepth arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_defaultDepth :: Addr -> Word32 -> IO (Int)
defaultScreen :: Display -> ScreenNumber
defaultScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_defaultScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_defaultScreen :: Addr -> IO (Word32)
defaultScreenOfDisplay :: Display -> Screen
defaultScreenOfDisplay gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_defaultScreenOfDisplay arg1 >>= \ (res1) ->
    (return ((Screen res1)))})
primitive prim_Xlib_defaultScreenOfDisplay :: Addr -> IO (Addr)
displayHeight :: Display -> ScreenNumber -> Int
displayHeight gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_displayHeight arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_displayHeight :: Addr -> Word32 -> IO (Int)
displayHeightMM :: Display -> ScreenNumber -> Int
displayHeightMM gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_displayHeightMM arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_displayHeightMM :: Addr -> Word32 -> IO (Int)
displayWidth :: Display -> ScreenNumber -> Int
displayWidth gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_displayWidth arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_displayWidth :: Addr -> Word32 -> IO (Int)
displayWidthMM :: Display -> ScreenNumber -> Int
displayWidthMM gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_displayWidthMM arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_displayWidthMM :: Addr -> Word32 -> IO (Int)
maxRequestSize :: Display -> Int
maxRequestSize gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_maxRequestSize arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_maxRequestSize :: Addr -> IO (Int)
displayMotionBufferSize :: Display -> Int
displayMotionBufferSize gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_displayMotionBufferSize arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_displayMotionBufferSize :: Addr -> IO (Int)
--Disnae exist in X11R5 %fun XExtendedMaxRequestSize :: Display -> Int
resourceManagerString :: Display -> String
resourceManagerString gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_resourceManagerString arg1 >>= \ (res1) ->
    (unmarshall_string_ res1) >>= \ gc_res1 ->
    (return (gc_res1))})
primitive prim_Xlib_resourceManagerString :: Addr -> IO (Addr)
screenResourceString :: Screen -> String
screenResourceString gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_screenResourceString arg1 >>= \ (res1) ->
    (unmarshall_string_ res1) >>= \ gc_res1 ->
    (return (gc_res1))})
primitive prim_Xlib_screenResourceString :: Addr -> IO (Addr)
displayString :: Display -> String
displayString gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_displayString arg1 >>= \ (res1) ->
    (unmarshall_string_ res1) >>= \ gc_res1 ->
    (return (gc_res1))})
primitive prim_Xlib_displayString :: Addr -> IO (Addr)
imageByteOrder :: Display -> Int
imageByteOrder gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_imageByteOrder arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_imageByteOrder :: Addr -> IO (Int)
protocolRevision :: Display -> Int
protocolRevision gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_protocolRevision arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_protocolRevision :: Addr -> IO (Int)
protocolVersion :: Display -> Int
protocolVersion gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_protocolVersion arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_protocolVersion :: Addr -> IO (Int)
serverVendor :: Display -> String
serverVendor gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_serverVendor arg1 >>= \ (res1) ->
    (unmarshall_string_ res1) >>= \ gc_res1 ->
    (return (gc_res1))})
primitive prim_Xlib_serverVendor :: Addr -> IO (Addr)
--Disnae exist: %fun XServerRelease          :: Display -> Int    
screenCount :: Display -> Int
screenCount gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_screenCount arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_screenCount :: Addr -> IO (Int)
defaultVisual :: Display -> ScreenNumber -> Visual
defaultVisual gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_defaultVisual arg1 arg2 >>= \ (res1) ->
    (return ((Visual res1)))})
primitive prim_Xlib_defaultVisual :: Addr -> Word32 -> IO (Addr)
displayCells :: Display -> ScreenNumber -> Int
displayCells gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_displayCells arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_displayCells :: Addr -> Word32 -> IO (Int)
displayPlanes :: Display -> ScreenNumber -> Int
displayPlanes gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_displayPlanes arg1 arg2 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_displayPlanes :: Addr -> Word32 -> IO (Int)
screenOfDisplay :: Display -> ScreenNumber -> Screen
screenOfDisplay gc_arg1 arg2 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_screenOfDisplay arg1 arg2 >>= \ (res1) ->
    (return ((Screen res1)))})
primitive prim_Xlib_screenOfDisplay :: Addr -> Word32 -> IO (Addr)
defaultRootWindow :: Display -> Window
defaultRootWindow gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_defaultRootWindow arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_defaultRootWindow :: Addr -> IO (Word32)

-- The following are believed to be order dependent

rootWindow :: Display -> ScreenNumber -> IO Window
rootWindow gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_rootWindow arg1 arg2 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_rootWindow :: Addr -> Word32 -> IO (Word32)
qLength :: Display -> IO Int
qLength gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_qLength arg1 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_qLength :: Addr -> IO (Int)
     		    	     
noOp :: Display -> IO ()
noOp gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_noOp arg1}
primitive prim_Xlib_noOp :: Addr -> IO ()

openDisplay :: String -> IO Display
openDisplay gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_Xlib_openDisplay arg1 >>= \ (res1,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return ((Display res1)))
primitive prim_Xlib_openDisplay :: Addr -> IO (Addr,Int,Addr)

closeDisplay :: Display -> IO ()
closeDisplay gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_closeDisplay arg1}
primitive prim_Xlib_closeDisplay :: Addr -> IO ()

-- I'm not sure why I added this since I don't have any of the related
-- functions.
rmInitialize :: IO ()
rmInitialize =
  prim_Xlib_rmInitialize
primitive prim_Xlib_rmInitialize :: IO ()

-- %fun XGetDefault :: Display -> String -> String -> IO ()

autoRepeatOff :: Display -> IO ()
autoRepeatOff gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_autoRepeatOff arg1}
primitive prim_Xlib_autoRepeatOff :: Addr -> IO ()
autoRepeatOn :: Display -> IO ()
autoRepeatOn gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_autoRepeatOn arg1}
primitive prim_Xlib_autoRepeatOn :: Addr -> IO ()
bell :: Display -> Int -> IO ()
bell gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_bell arg1 arg2}
primitive prim_Xlib_bell :: Addr -> Int -> IO ()
setCloseDownMode :: Display -> CloseDownMode -> IO ()
setCloseDownMode gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setCloseDownMode arg1 arg2}
primitive prim_Xlib_setCloseDownMode :: Addr -> Int -> IO ()
lastKnownRequestProcessed :: Display -> IO Int
lastKnownRequestProcessed gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_lastKnownRequestProcessed arg1 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_lastKnownRequestProcessed :: Addr -> IO (Int)

getInputFocus :: Display -> IO (Window,FocusMode)
getInputFocus gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_getInputFocus arg1}
primitive prim_Xlib_getInputFocus :: Addr -> IO (Word32,Int)

setInputFocus :: Display -> Window -> FocusMode -> Time -> IO ()
setInputFocus gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setInputFocus arg1 arg2 arg3 arg4}
primitive prim_Xlib_setInputFocus :: Addr -> Word32 -> Int -> Word32 -> IO ()

-- XAllocID omitted
-- XKillClient omitted
-- XFetchName omitted
-- XGetKeyboardControl omitted
-- XChangeKeyboardControl omitted
-- XChangeKeyboardMapping omitted
-- XChangePointerControl omitted

grabButton :: Display -> Button -> ButtonMask -> Window -> Bool -> EventMask -> GrabMode -> GrabMode -> Window -> Cursor -> IO ()
grabButton gc_arg1 arg2 arg3 arg4 gc_arg2 arg6 arg7 arg8 arg9 arg10 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_bool_ gc_arg2) >>= \ (arg5) ->
  prim_Xlib_grabButton arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10}
primitive prim_Xlib_grabButton :: Addr -> Word32 -> Word32 -> Word32 -> Int -> Word32 -> Int -> Int -> Word32 -> Word32 -> IO ()
ungrabButton :: Display -> Button -> ButtonMask -> Window -> IO ()
ungrabButton gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_ungrabButton arg1 arg2 arg3 arg4}
primitive prim_Xlib_ungrabButton :: Addr -> Word32 -> Word32 -> Word32 -> IO ()

grabPointer :: Display -> Window -> Bool -> EventMask -> GrabMode -> GrabMode -> Window -> Cursor -> Time -> IO GrabStatus
grabPointer gc_arg1 arg2 gc_arg2 arg4 arg5 arg6 arg7 arg8 arg9 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_bool_ gc_arg2) >>= \ (arg3) ->
  prim_Xlib_grabPointer arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_grabPointer :: Addr -> Word32 -> Int -> Word32 -> Int -> Int -> Word32 -> Word32 -> Word32 -> IO (Int)
ungrabPointer :: Display -> Time -> IO ()
ungrabPointer gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_ungrabPointer arg1 arg2}
primitive prim_Xlib_ungrabPointer :: Addr -> Word32 -> IO ()

grabKey :: Display -> KeyCode -> ButtonMask -> Window -> Bool -> GrabMode -> GrabMode -> IO ()
grabKey gc_arg1 arg2 arg3 arg4 gc_arg2 arg6 arg7 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_bool_ gc_arg2) >>= \ (arg5) ->
  prim_Xlib_grabKey arg1 arg2 arg3 arg4 arg5 arg6 arg7}
primitive prim_Xlib_grabKey :: Addr -> Char -> Word32 -> Word32 -> Int -> Int -> Int -> IO ()
ungrabKey :: Display -> KeyCode -> ButtonMask -> Window -> IO ()
ungrabKey gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_ungrabKey arg1 arg2 arg3 arg4}
primitive prim_Xlib_ungrabKey :: Addr -> Char -> Word32 -> Word32 -> IO ()

grabKeyboard :: Display -> Window -> Bool -> GrabMode -> GrabMode -> Time -> IO GrabStatus
grabKeyboard gc_arg1 arg2 gc_arg2 arg4 arg5 arg6 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_bool_ gc_arg2) >>= \ (arg3) ->
  prim_Xlib_grabKeyboard arg1 arg2 arg3 arg4 arg5 arg6 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_grabKeyboard :: Addr -> Word32 -> Int -> Int -> Int -> Word32 -> IO (Int)
ungrabKeyboard :: Display -> Time -> IO ()
ungrabKeyboard gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_ungrabKeyboard arg1 arg2}
primitive prim_Xlib_ungrabKeyboard :: Addr -> Word32 -> IO ()

grabServer :: Display -> IO ()
grabServer gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_grabServer arg1}
primitive prim_Xlib_grabServer :: Addr -> IO ()
ungrabServer :: Display -> IO ()
ungrabServer gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_ungrabServer arg1}
primitive prim_Xlib_ungrabServer :: Addr -> IO ()

-- XChangeActivePointerGrab omitted

-- XFree omitted
-- XFreeStringList omitted

queryBestTile :: Display -> Drawable -> Dimension -> Dimension -> IO (Dimension,Dimension)
queryBestTile gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_queryBestTile arg1 arg2 arg3 arg4 >>= \ (res1,res2,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return ((res1,res2)))}
primitive prim_Xlib_queryBestTile :: Addr -> Word32 -> Word32 -> Word32 -> IO (Word32,Word32,Int,Addr)

queryBestStipple :: Display -> Drawable -> Dimension -> Dimension -> IO (Dimension,Dimension)
queryBestStipple gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_queryBestStipple arg1 arg2 arg3 arg4 >>= \ (res1,res2,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return ((res1,res2)))}
primitive prim_Xlib_queryBestStipple :: Addr -> Word32 -> Word32 -> Word32 -> IO (Word32,Word32,Int,Addr)

queryBestCursor :: Display -> Drawable -> Dimension -> Dimension -> IO (Dimension,Dimension)
queryBestCursor gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_queryBestCursor arg1 arg2 arg3 arg4 >>= \ (res1,res2,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return ((res1,res2)))}
primitive prim_Xlib_queryBestCursor :: Addr -> Word32 -> Word32 -> Word32 -> IO (Word32,Word32,Int,Addr)

queryBestSize :: Display -> Drawable -> QueryBestSizeClass -> Dimension -> Dimension -> IO (Dimension,Dimension)
queryBestSize gc_arg1 arg2 arg3 arg4 arg5 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_queryBestSize arg1 arg2 arg3 arg4 arg5 >>= \ (res1,res2,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return ((res1,res2)))}
primitive prim_Xlib_queryBestSize :: Addr -> Word32 -> Int -> Word32 -> Word32 -> IO (Word32,Word32,Int,Addr)

-- Note: Returns false if pointer not in window w (and win_x = win_y = 0)
-- ToDo: more effective use of Maybes?
queryPointer :: Display -> Window -> IO (Bool,Window,Window,Int,Int,Int,Int,Modifier)
queryPointer gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_queryPointer arg1 arg2 >>= \ (res1,res2,res3,res4,res5,res6,res7,res8) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return ((gc_res1,res2,res3,res4,res5,res6,res7,res8)))}
primitive prim_Xlib_queryPointer :: Addr -> Word32 -> IO (Int,Word32,Word32,Int,Int,Int,Int,Word32)

-- XSetSelectionOwner omitted

-- XOpenOM omitted
-- XCloseOM omitted
-- XSetOMValues omitted
-- XGetOMValues omitted
-- DisplayOfOM omitted
-- XLocaleOfOM omitted

-- XCreateOC omitted
-- XDestroyOC omitted
-- XOMOfOC omitted
-- XSetOCValues omitted
-- XGetOCValues omitted

-- XVaCreateNestedList omitted

----------------------------------------------------------------
-- Error reporting
----------------------------------------------------------------

displayName :: String -> String
displayName gc_arg1 =
  unsafePerformIO(
    (marshall_string_ gc_arg1) >>= \ (arg1) ->
    prim_Xlib_displayName arg1 >>= \ (res1) ->
    (unmarshall_string_ res1) >>= \ gc_res1 ->
    (return (gc_res1)))
primitive prim_Xlib_displayName :: Addr -> IO (Addr)

-- type ErrorHandler   = Display -> ErrorEvent -> IO Int
-- %dis errorHandler x = (stable x)
-- 
-- type IOErrorHandler = Display ->                IO Int
-- %dis ioErrorHandler x = (stable x)

-- Sadly, this code doesn't work because hugs->runIO creates a fresh
-- stack of exception handlers so the exception gets thrown to the 
-- wrong place.
-- 
-- %C
-- % static HugsStablePtr ioErrorHandlerPtr; 
-- % 
-- % int genericIOErrorHandler(Display *d)
-- % {
-- %     if (ioErrorHandlerPtr >= 0) {
-- %     	  hugs->putStablePtr(ioErrorHandlerPtr);
-- %     	  hugs->putAddr(d);  
-- %     	  if (hugs->runIO(1)) { /* exitWith value returned */
-- %     	   return hugs->getInt();
-- %     	  } else {
-- %     	   return hugs->getWord();
-- %     	  }
-- %     }
-- %     return 1;
-- % }

-- Here's what we might do instead.  The two error handlers set flags
-- when they fire and every single call to X contains the line:
--
--   %fail { errorFlags != 0 } { XError(errorFlags) }
--
-- This really sucks.
-- Oh, and it won't even work with IOErrors since they terminate
-- the process if the handler returns.  I don't know what the hell they
-- think they're doing taking it upon themselves to terminate MY
-- process when THEIR library has a problem but I don't think anyone 
-- ever accused X of being well-designed.
-- 
-- % static int genericIOErrorHandler(Display *d)
-- % {
-- %     if (ioErrorHandlerPtr >= 0) {
-- %     	  hugs->putStablePtr(ioErrorHandlerPtr);
-- %     	  hugs->putAddr(d);  
-- %     	  if (hugs->runIO(1)) { /* exitWith value returned */
-- %     	   return hugs->getInt();
-- %     	  } else {
-- %     	   return hugs->getWord();
-- %     	  }
-- %     }
-- %     return 1;
-- % }


-- HN 2001-02-06
-- Moved to auxiliaries.c to make it easier to use the inlining option.
-- -- Sigh, for now we just use an error handler that prints an error
-- -- message on the screen
-- %C
-- % static int defaultErrorHandler(Display *d, XErrorEvent *ev)
-- % {
-- % 	  char buffer[1000];
-- % 	  XGetErrorText(d,ev->error_code,buffer,1000);
-- % 	  printf("Error: %s\n", buffer);
-- % 	  return 0;
-- % }


setDefaultErrorHandler :: IO ()
setDefaultErrorHandler =
  prim_Xlib_setDefaultErrorHandler
primitive prim_Xlib_setDefaultErrorHandler :: IO ()


-- %fun XSetIOErrorHandler :: IOErrorHandler -> IO IOErrorHandler
-- %fun XSetErrorHandler   :: ErrorHandler   -> IO ErrorHandler

-- XGetErrorDatabaseText omitted
-- XGetErrorText omitted

-- ----------------------------------------------------------------
-- -- Buffers
-- ----------------------------------------------------------------
-- 
-- -- OLD: Would arrays be more appropriate?
-- --
-- -- IMPURE void	XStoreBytes(display, bytes, nbytes)
-- -- IN Display*		display
-- -- VAR Int			nbytes
-- -- IN list[nbytes] Byte	bytes
-- -- 
-- -- IMPURE list[nbytes] Byte	XFetchBytes(display, &nbytes)
-- -- IN Display*	display
-- -- VAR Int		nbytes
-- -- 
-- -- IMPURE void	XStoreBuffer(display, bytes, nbytes, buffer)
-- -- IN Display*		display
-- -- VAR Int			nbytes
-- -- IN list[nbytes] Byte	bytes
-- -- IN Buffer		buffer
-- -- 
-- -- IMPURE list[nbytes] Byte	XFetchBuffer(display, &nbytes, buffer)
-- -- IN Display*	display
-- -- VAR Int		nbytes
-- -- IN Buffer	buffer
-- -- 
-- -- IMPURE void	XRotateBuffers(display, rotate)
-- -- IN Display*	display
-- -- VAR Int		rotate

----------------------------------------------------------------
-- Extensions
----------------------------------------------------------------

-- ToDo: Use XFreeExtensionList
-- %fun XListExtensions :: Display -> IO ListString using res1 = XListExtensions(arg1,&res1_size)

-- %errfun False XQueryExtension :: Display -> String -> IO (Int,Int,Int) using res4 = XQueryExtension(arg1,arg2,&res1,&res2,&res3)->(res1,res2,res3)
-- %fun XInitExtensions :: Display -> String -> IO XExtCodes
-- %fun XAddExtensions  :: Display ->           IO XExtCodes

-- XAddToExtensionList omitted
-- XFindOnExtensionList omitted
-- XEHeadOfExtensionList omitted

----------------------------------------------------------------
-- Hosts
----------------------------------------------------------------

-- ToDo: operations to construct and destruct an XHostAddress

-- %fun XAddHost :: Display -> XHostAddress -> IO ()
-- %fun XRemoveHost :: Display -> XHostAddress -> IO ()
-- 
-- %fun XAddHosts    :: Display -> ListXHostAddress -> IO () using XAddHosts(arg1,arg2,arg2_size) 
-- %fun XRemoveHosts :: Display -> ListXHostAddress -> IO () using XRemoveHosts(arg1,arg2,arg2_size) 
-- 
-- # Uses %prim to let us call XFree
-- %prim XListHosts :: Display -> IO (ListXHostAddress, Bool)
-- Bool state;
-- Int r_size;
-- XHostAddress* r = XListHosts(arg1,&r_size,&state);
-- %update(r,state);
-- XFree(r);
-- return;

-- %fun XEnableAccessControl  :: Display -> IO ()
-- %fun XDisableAccessControl :: Display -> IO ()
-- %fun XSetAccessControl     :: Display -> Access -> IO ()


----------------------------------------------------------------
-- Events
----------------------------------------------------------------

type   QueuedMode   = Int
queuedAlready :: QueuedMode
queuedAlready =
  unsafePerformIO(
    prim_Xlib_queuedAlready >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_queuedAlready :: IO (Int)
queuedAfterFlush :: QueuedMode
queuedAfterFlush =
  unsafePerformIO(
    prim_Xlib_queuedAfterFlush >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_queuedAfterFlush :: IO (Int)
queuedAfterReading :: QueuedMode
queuedAfterReading =
  unsafePerformIO(
    prim_Xlib_queuedAfterReading >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_queuedAfterReading :: IO (Int)

-- Because of the way the corresponding C types are defined,
-- These "structs" are somewhat unusual - they omit fields which can
-- be found in more general structs.
-- For example, XAnyEvent omits type since it is in XEvent.
-- Therefore, to get the complete contents of an event one typically
-- writes:
--   do
--     ty <- get_XEvent e
--     (serial,send_event,display,window) <- get_XAnyEvent
--     window' <- get_XDestroyWindowEvent

type XEvent = 
 ( EventType
 )
type XEventPtr   = Addr

allocXEvent :: IO XEventPtr
allocXEvent =
  prim_Xlib_allocXEvent >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_allocXEvent :: IO (Addr)

get_EventType :: XEventPtr -> IO EventType
get_EventType arg1 =
  prim_Xlib_get_EventType arg1 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_get_EventType :: Addr -> IO (Word32)

get_Window :: XEventPtr -> IO Window
get_Window arg1 =
  prim_Xlib_get_Window arg1 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_get_Window :: Addr -> IO (Word32)

-- %struct : XAnyEvent : XAnyEvent arg1
--   Int32     : serial            # # of last request processed by server
--   Bool      : send_event        # true if this came from a SendEvent request
--   Display   : display           # Display the event was read from
--   Window    : window            # window on which event was requested in event mask

type XKeyEvent =
 ( Window    -- root window that the event occured on 
 , Window    -- child window 
 , Time      -- milliseconds 
 , Int       -- pointer x, y coordinates in event window 
 , Int       -- 
 , Int       -- coordinates relative to root 
 , Int       -- 
 , Modifier  -- key or button mask 
 , KeyCode   -- detail 
 , Bool      -- same screen flag 
 )
type XKeyEventPtr   = Addr

type XButtonEvent = 
 ( Window    --	root window that the event occured on 
 , Window    --	child window 
 , Time      --	milliseconds 
 , Int       --	pointer x, y coordinates in event window 
 , Int       
 , Int       --	coordinates relative to root 
 , Int       
 , Modifier  --	key or button mask 
 , Button    --	detail 
 , Bool      --	same screen flag 
 )

get_KeyEvent :: XEventPtr -> IO XKeyEvent
get_KeyEvent arg1 =
  prim_Xlib_get_KeyEvent arg1 >>= \ (gc_res1,gc_res2,gc_res3,gc_res4,gc_res5,gc_res6,gc_res7,gc_res8,gc_res9,gc_res11) ->
  (unmarshall_bool_ gc_res11) >>= \ gc_res10 ->
  (return ((gc_res1,gc_res2,gc_res3,gc_res4,gc_res5,gc_res6,gc_res7,gc_res8,gc_res9,gc_res10)))
primitive prim_Xlib_get_KeyEvent :: Addr -> IO (Word32,Word32,Word32,Int,Int,Int,Int,Word32,Char,Int)

get_ButtonEvent :: XEventPtr -> IO XButtonEvent
get_ButtonEvent arg1 =
  prim_Xlib_get_ButtonEvent arg1 >>= \ (gc_res1,gc_res2,gc_res3,gc_res4,gc_res5,gc_res6,gc_res7,gc_res8,gc_res9,gc_res11) ->
  (unmarshall_bool_ gc_res11) >>= \ gc_res10 ->
  (return ((gc_res1,gc_res2,gc_res3,gc_res4,gc_res5,gc_res6,gc_res7,gc_res8,gc_res9,gc_res10)))
primitive prim_Xlib_get_ButtonEvent :: Addr -> IO (Word32,Word32,Word32,Int,Int,Int,Int,Word32,Word32,Int)

get_MotionEvent :: XEventPtr -> IO XMotionEvent
get_MotionEvent arg1 =
  prim_Xlib_get_MotionEvent arg1 >>= \ (gc_res1,gc_res2,gc_res3,gc_res4,gc_res5,gc_res6,gc_res7,gc_res8,gc_res9,gc_res11) ->
  (unmarshall_bool_ gc_res11) >>= \ gc_res10 ->
  (return ((gc_res1,gc_res2,gc_res3,gc_res4,gc_res5,gc_res6,gc_res7,gc_res8,gc_res9,gc_res10)))
primitive prim_Xlib_get_MotionEvent :: Addr -> IO (Word32,Word32,Word32,Int,Int,Int,Int,Word32,Int,Int)


type XMotionEvent =
 ( Window      -- root window that the event occured on 
 , Window      -- child window 
 , Time        -- milliseconds 
 , Int         -- pointer x, y coordinates in event window 
 , Int          
 , Int         -- coordinates relative to root 
 , Int          
 , Modifier    -- key or button mask 
 , NotifyMode  -- detail 
 , Bool        -- same screen flag 
 )


-- %struct : XCrossingEvent : XCrossingEvent arg1
--   Window       : root 	        # root window that the event occured on 
--   Window       : subwindow 	# child window 
--   Time         : time 		# milliseconds 
--   Int          : x 		# pointer x, y coordinates in event window 
--   Int          : y
--   Int          : x_root	 	# coordinates relative to root 
--   Int          : y_root
--   NotifyMode   : mode              
--   NotifyDetail : detail
--   Bool         : same_screen	# same screen flag
--   Bool         : focus		# boolean focus
--   Modifier     : state	        # key or button mask 
-- 
-- %struct : XFocusChangeEvent : XFocusChangeEvent arg1
--   NotifyMode   : mode
--   NotifyDetail : detail
-- 
-- -- omitted: should be translated into bitmaps
-- -- PURE void	getKeymapEvent(event)
-- -- IN XEvent*	event
-- -- OUT Window	window	 	= ((XKeymapEvent*)event)->window
-- -- OUT array[32] Char key_vector 	= ((XKeymapEvent*)event)->key_vector
-- -- RESULT: 

type XExposeEvent =
 ( Position	-- x	 	
 , Position	-- y	 	
 , Dimension	-- width	 	
 , Dimension	-- height	
 , Int		-- count	 	
 )

get_ExposeEvent :: XEventPtr -> IO XExposeEvent
get_ExposeEvent arg1 =
  prim_Xlib_get_ExposeEvent arg1 >>= \ (gc_res2,gc_res4,gc_res5,gc_res6,gc_res7) ->
  let gc_res1 = ( intToInt32  (gc_res2)) in
  let gc_res3 = ( intToInt32  (gc_res4)) in
  (return ((gc_res1,gc_res3,gc_res5,gc_res6,gc_res7)))
primitive prim_Xlib_get_ExposeEvent :: Addr -> IO (Int,Int,Word32,Word32,Int)

-- %struct : XGraphicsExposeEvent : XGraphicsExposeEvent arg1
--   Position	: x	 	
--   Position	: y	 	
--   Dimension	: width	 	.
--   Dimension	: height	
--   Int		: count	 	
--   Int		: major_code 	
--   Int		: minor_code 	
-- 
-- %struct : XCirculateEvent : XCirculateEvent arg1
--   Window	: window	 	
--   Place		: place		
-- 
-- %struct : XConfigureEvent : XConfigureEvent arg1
--   Window	: window	
--   Position	: x	 	
--   Position	: y	 	
--   Dimension	: width	 	
--   Dimension	: height	
--   Dimension	: border_width 	
--   Window	: above	 	
--   Bool	        : override_redirect
-- 
-- %struct : XCreateWindowEvent : XCreateWindowEvent arg1
--   Window	: window	 	
--   Position	: x	 	
--   Position	: y	 	
--   Dimension	: width	 	
--   Dimension	: height	 	
--   Dimension	: border_width 	
--   Bool	        : override_redirect
-- 
-- %struct : XDestroyWindowEvent : XDestroyWindowEvent arg1
--   Window	: window
-- 
-- %struct : XGravityEvent : XGravityEvent arg1
--   Window	: window	
--   Position	: x	 	
--   Position	: y	 	
-- 
-- %struct : XMapEvent : XMapEvent arg1
--   Bool	        : override_redirect

type XMappingEvent =
 ( MappingRequest -- request	
 , KeyCode	  -- first_keycode
 , Int		  -- count	
 )

type XConfigureEvent =
 ( Position
 , Position
 , Dimension 
 , Dimension 
 )
get_ConfigureEvent :: XEventPtr -> IO XConfigureEvent
get_ConfigureEvent arg1 =
  prim_Xlib_get_ConfigureEvent arg1 >>= \ (gc_res2,gc_res4,gc_res5,gc_res6) ->
  let gc_res1 = ( intToInt32  (gc_res2)) in
  let gc_res3 = ( intToInt32  (gc_res4)) in
  (return ((gc_res1,gc_res3,gc_res5,gc_res6)))
primitive prim_Xlib_get_ConfigureEvent :: Addr -> IO (Int,Int,Word32,Word32)


-- %struct : XResizeRequestEvent : XResizeRequestEvent arg1
--   Dimension	: width	 
--   Dimension	: height	
-- 

-- %struct : XReparentEvent : XReparentEvent arg1
--   Window	: window	
--   Window	: parent	
--   Position	: x	 	
--   Position	: y	 	
--   Bool	        : override_redirect
-- 
-- %struct : XUnmapEvent : XUnmapEvent arg1
--   Window	: window	 	
--   Bool	        : from_configure	
-- 
-- %struct : XVisibilityEvent : XVisibilityEvent arg1
--   Visibility	: state
-- 
-- %struct : XCirculateRequestEvent : XCirculateRequestEvent arg1
--   Place	        : place
-- 
-- -- omitted because valuemask looks tricky
-- -- %struct : XConfigureRequestEvent : XConfigureRequestEvent arg1
-- --   Window	 : window	
-- --   Position	 : x		
-- --   Position	 : y		
-- --   Dimension	 : width	
-- --   Dimension	 : height	
-- --   Dimension	 : border_width	
-- --   Window	 : above	
-- --   StackingMethod : detail	
-- --   ???	         : valuemask	
-- 
-- %struct : XMapRequestEvent : XMapRequestEvent arg1
--   Window	: window
-- 
-- %struct : XColormapEvent : XColormapEvent arg1
--   Colormap		: colormap
--   Bool		        : new	  
--   ColormapNotification	: state   
-- 
-- -- getClientMessageEvent omitted
-- -- getPropertyEvent omitted
-- -- getSelectionClearEvent omitted
-- -- getSelectionRequestEvent omitted
-- -- getSelectionEvent omitted

-- functions

-- The following is useful if you want to do a read with timeout.
-- Returns True if timeout occurs.
waitForEvent :: Display -> Word32 -> IO Bool
waitForEvent gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_waitForEvent arg1 arg2 >>= \ (gc_res2) ->
  (unmarshall_bool_ gc_res2) >>= \ gc_res1 ->
  (return (gc_res1))}
primitive prim_Xlib_waitForEvent :: Addr -> Word32 -> IO (Int)

-- The following is somewhat compatible with Win32's TimeGetTime
gettimeofday_in_milliseconds :: IO Integer
gettimeofday_in_milliseconds = do
  (sec,usec) <- gettimeofday_in_milliseconds_internal
  return (toInteger sec * 1000 + toInteger usec `div` 1000)

gettimeofday_in_milliseconds_internal :: IO (Word32,Word32)
gettimeofday_in_milliseconds_internal =
  prim_Xlib_gettimeofday_in_milliseconds_internal
primitive prim_Xlib_gettimeofday_in_milliseconds_internal :: IO (Word32,Word32)

flush :: Display -> IO ()
flush gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_flush arg1}
primitive prim_Xlib_flush :: Addr -> IO ()
sync :: Display -> Bool -> IO ()
sync gc_arg1 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_bool_ gc_arg2) >>= \ (arg2) ->
  prim_Xlib_sync arg1 arg2}
primitive prim_Xlib_sync :: Addr -> Int -> IO ()
pending :: Display -> IO Int
pending gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_pending arg1 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_pending :: Addr -> IO (Int)
eventsQueued :: Display -> QueuedMode -> IO Int
eventsQueued gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_eventsQueued arg1 arg2 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_eventsQueued :: Addr -> Int -> IO (Int)
nextEvent :: Display -> XEventPtr -> IO ()
nextEvent gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_nextEvent arg1 arg2}
primitive prim_Xlib_nextEvent :: Addr -> Addr -> IO ()
allowEvents :: Display -> AllowEvents -> Time -> IO ()
allowEvents gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_allowEvents arg1 arg2 arg3}
primitive prim_Xlib_allowEvents :: Addr -> Int -> Word32 -> IO ()

-- ToDo: XFree(res1) after constructing result
-- %fun XGetMotionEvents :: Display -> Window -> Time -> Time -> IO ListXTimeCoord
-- %code res1 = XGetMotionEvents(arg1,arg2,arg3,arg4,&res1_size)

selectInput :: Display -> Window -> EventMask -> IO ()
selectInput gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_selectInput arg1 arg2 arg3}
primitive prim_Xlib_selectInput :: Addr -> Word32 -> Word32 -> IO ()
sendEvent :: Display -> Window -> Bool -> EventMask -> XEventPtr -> IO ()
sendEvent gc_arg1 arg2 gc_arg2 arg4 arg5 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_bool_ gc_arg2) >>= \ (arg3) ->
  prim_Xlib_sendEvent arg1 arg2 arg3 arg4 arg5 >>= \ (gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
primitive prim_Xlib_sendEvent :: Addr -> Word32 -> Int -> Word32 -> Addr -> IO (Int,Addr)

windowEvent :: Display -> Window -> EventMask -> XEventPtr -> IO ()
windowEvent gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_windowEvent arg1 arg2 arg3 arg4}
primitive prim_Xlib_windowEvent :: Addr -> Word32 -> Word32 -> Addr -> IO ()
checkWindowEvent :: Display -> Window -> EventMask -> XEventPtr -> IO Bool
checkWindowEvent gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_checkWindowEvent arg1 arg2 arg3 arg4 >>= \ (res1) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))}
primitive prim_Xlib_checkWindowEvent :: Addr -> Word32 -> Word32 -> Addr -> IO (Int)

maskEvent :: Display -> EventMask -> XEventPtr -> IO ()
maskEvent gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_maskEvent arg1 arg2 arg3}
primitive prim_Xlib_maskEvent :: Addr -> Word32 -> Addr -> IO ()
checkMaskEvent :: Display -> EventMask -> XEventPtr -> IO Bool
checkMaskEvent gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_checkMaskEvent arg1 arg2 arg3 >>= \ (res1) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))}
primitive prim_Xlib_checkMaskEvent :: Addr -> Word32 -> Addr -> IO (Int)
checkTypedEvent :: Display -> EventType -> XEventPtr -> IO Bool
checkTypedEvent gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_checkTypedEvent arg1 arg2 arg3 >>= \ (res1) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))}
primitive prim_Xlib_checkTypedEvent :: Addr -> Word32 -> Addr -> IO (Int)
checkTypedWindowEvent :: Display -> Window -> EventType -> XEventPtr -> IO Bool
checkTypedWindowEvent gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_checkTypedWindowEvent arg1 arg2 arg3 arg4 >>= \ (res1) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))}
primitive prim_Xlib_checkTypedWindowEvent :: Addr -> Word32 -> Word32 -> Addr -> IO (Int)
putBackEvent :: Display -> XEventPtr -> IO ()
putBackEvent gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_putBackEvent arg1 arg2}
primitive prim_Xlib_putBackEvent :: Addr -> Addr -> IO ()
peekEvent :: Display -> XEventPtr -> IO ()
peekEvent gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_peekEvent arg1 arg2}
primitive prim_Xlib_peekEvent :: Addr -> Addr -> IO ()

-- XFilterEvent omitted (can't find documentation)
-- XIfEvent omitted (can't pass predicates (yet))
-- XCheckIfEvent omitted (can't pass predicates (yet))
-- XPeekIfEvent omitted (can't pass predicates (yet))

refreshKeyboardMapping :: XMappingEvent -> IO ()
refreshKeyboardMapping gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg3,gc_arg4) ->
  prim_Xlib_refreshKeyboardMapping gc_arg2 gc_arg3 gc_arg4}
primitive prim_Xlib_refreshKeyboardMapping :: Int -> Char -> Int -> IO ()

-- XSynchronize omitted (returns C function)
-- XSetAfterFunction omitted (can't pass functions (yet))

----------------------------------------------------------------
-- Geometry
----------------------------------------------------------------

geometry :: Display -> Int -> String -> String -> Dimension -> Dimension -> Dimension -> Int -> Int -> IO (Int,Position,Position,Dimension,Dimension)
geometry gc_arg1 arg2 gc_arg2 gc_arg3 arg5 arg6 arg7 arg8 arg9 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg3) ->
  (marshall_string_ gc_arg3) >>= \ (arg4) ->
  prim_Xlib_geometry arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 >>= \ (res1,res2,res3,res4,res5) ->
  let gc_res1 = ( intToInt32  (res2)) in
  let gc_res2 = ( intToInt32  (res3)) in
  (return ((res1,gc_res1,gc_res2,res4,res5)))}
primitive prim_Xlib_geometry :: Addr -> Int -> Addr -> Addr -> Word32 -> Word32 -> Word32 -> Int -> Int -> IO (Int,Int,Int,Word32,Word32)

getGeometry :: Display -> Int -> Drawable -> IO (Window,Position,Position,Dimension,Dimension,Dimension,Int)
getGeometry gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_getGeometry arg1 arg2 arg3 >>= \ (res1,res2,res3,res4,res5,res6,res7,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( intToInt32  (res2)) in
       let gc_res2 = ( intToInt32  (res3)) in
       (return ((res1,gc_res1,gc_res2,res4,res5,res6,res7)))}
primitive prim_Xlib_getGeometry :: Addr -> Int -> Word32 -> IO (Word32,Int,Int,Word32,Word32,Word32,Int,Int,Addr)

-- XParseGeometry omitted (returned bitset too weird)

----------------------------------------------------------------
-- Locale
----------------------------------------------------------------

supportsLocale :: IO Bool
supportsLocale =
  prim_Xlib_supportsLocale >>= \ (res1) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
primitive prim_Xlib_supportsLocale :: IO (Int)
setLocaleModifiers :: String -> IO String
setLocaleModifiers gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_Xlib_setLocaleModifiers arg1 >>= \ (res1) ->
  (unmarshall_string_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
primitive prim_Xlib_setLocaleModifiers :: Addr -> IO (Addr)

----------------------------------------------------------------
-- Screen Saver
----------------------------------------------------------------

type AllowExposuresMode = Int
dontAllowExposures :: AllowExposuresMode
dontAllowExposures =
  unsafePerformIO(
    prim_Xlib_dontAllowExposures >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_dontAllowExposures :: IO (Int)
allowExposures :: AllowExposuresMode
allowExposures =
  unsafePerformIO(
    prim_Xlib_allowExposures >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_allowExposures :: IO (Int)
defaultExposures :: AllowExposuresMode
defaultExposures =
  unsafePerformIO(
    prim_Xlib_defaultExposures >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_defaultExposures :: IO (Int)

type PreferBlankingMode = Int
dontPreferBlanking :: PreferBlankingMode
dontPreferBlanking =
  unsafePerformIO(
    prim_Xlib_dontPreferBlanking >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_dontPreferBlanking :: IO (Int)
preferBlanking :: PreferBlankingMode
preferBlanking =
  unsafePerformIO(
    prim_Xlib_preferBlanking >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_preferBlanking :: IO (Int)
defaultBlanking :: PreferBlankingMode
defaultBlanking =
  unsafePerformIO(
    prim_Xlib_defaultBlanking >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_defaultBlanking :: IO (Int)

type ScreenSaverMode = Int
screenSaverActive :: ScreenSaverMode
screenSaverActive =
  unsafePerformIO(
    prim_Xlib_screenSaverActive >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_screenSaverActive :: IO (Int)
screenSaverReset :: ScreenSaverMode
screenSaverReset =
  unsafePerformIO(
    prim_Xlib_screenSaverReset >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_screenSaverReset :: IO (Int)

getScreenSaver :: Display -> IO (Int,Int,PreferBlankingMode,AllowExposuresMode)
getScreenSaver gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_getScreenSaver arg1}
primitive prim_Xlib_getScreenSaver :: Addr -> IO (Int,Int,Int,Int)

setScreenSaver :: Display -> Int -> Int -> PreferBlankingMode -> AllowExposuresMode -> IO ()
setScreenSaver gc_arg1 arg2 arg3 arg4 arg5 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setScreenSaver arg1 arg2 arg3 arg4 arg5}
primitive prim_Xlib_setScreenSaver :: Addr -> Int -> Int -> Int -> Int -> IO ()
activateScreenSaver :: Display -> IO ()
activateScreenSaver gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_activateScreenSaver arg1}
primitive prim_Xlib_activateScreenSaver :: Addr -> IO ()
resetScreenSaver :: Display -> IO ()
resetScreenSaver gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_resetScreenSaver arg1}
primitive prim_Xlib_resetScreenSaver :: Addr -> IO ()
forceScreenSaver :: Display -> ScreenSaverMode -> IO ()
forceScreenSaver gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_forceScreenSaver arg1 arg2}
primitive prim_Xlib_forceScreenSaver :: Addr -> Int -> IO ()


----------------------------------------------------------------
-- Pointer
----------------------------------------------------------------

getPointerControl :: Display -> IO (Int,Int,Int)
getPointerControl gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_getPointerControl arg1}
primitive prim_Xlib_getPointerControl :: Addr -> IO (Int,Int,Int)

warpPointer :: Display -> Window -> Window -> Position -> Position -> Dimension -> Dimension -> Position -> Position -> IO ()
warpPointer gc_arg1 arg2 arg3 gc_arg2 gc_arg3 arg6 arg7 gc_arg4 gc_arg5 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  case ( int32ToInt  gc_arg4) of { arg8 ->
  case ( int32ToInt  gc_arg5) of { arg9 ->
  prim_Xlib_warpPointer arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9}}}}}
primitive prim_Xlib_warpPointer :: Addr -> Word32 -> Word32 -> Int -> Int -> Word32 -> Word32 -> Int -> Int -> IO ()

-- XGetPointerMapping omitted
-- XSetPointerMapping omitted

----------------------------------------------------------------
-- Visuals
----------------------------------------------------------------

-- XVisualIDFromVisual omitted


----------------------------------------------------------------
-- Threads
----------------------------------------------------------------

-- XInitThreads omitted (leary of thread stuff)
-- XLockDisplay omitted (leary of thread stuff)
-- XUnlockDisplay omitted (leary of thread stuff)

----------------------------------------------------------------
-- Screen
----------------------------------------------------------------

-- Many flags assumed to be PURE.

blackPixelOfScreen :: Screen -> Pixel
blackPixelOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_blackPixelOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_blackPixelOfScreen :: Addr -> IO (Word32)
whitePixelOfScreen :: Screen -> Pixel
whitePixelOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_whitePixelOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_whitePixelOfScreen :: Addr -> IO (Word32)
cellsOfScreen :: Screen -> Int
cellsOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_cellsOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_cellsOfScreen :: Addr -> IO (Int)
defaultColormapOfScreen :: Screen -> Colormap
defaultColormapOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_defaultColormapOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_defaultColormapOfScreen :: Addr -> IO (Word32)
defaultDepthOfScreen :: Screen -> Int
defaultDepthOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_defaultDepthOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_defaultDepthOfScreen :: Addr -> IO (Int)
defaultGCOfScreen :: Screen -> GC
defaultGCOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_defaultGCOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_defaultGCOfScreen :: Addr -> IO (Addr)
defaultVisualOfScreen :: Screen -> Visual
defaultVisualOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_defaultVisualOfScreen arg1 >>= \ (res1) ->
    (return ((Visual res1)))})
primitive prim_Xlib_defaultVisualOfScreen :: Addr -> IO (Addr)
doesBackingStore :: Screen -> Bool
doesBackingStore gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_doesBackingStore arg1 >>= \ (res1) ->
    (unmarshall_bool_ res1) >>= \ gc_res1 ->
    (return (gc_res1))})
primitive prim_Xlib_doesBackingStore :: Addr -> IO (Int)
doesSaveUnders :: Screen -> Bool
doesSaveUnders gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_doesSaveUnders arg1 >>= \ (res1) ->
    (unmarshall_bool_ res1) >>= \ gc_res1 ->
    (return (gc_res1))})
primitive prim_Xlib_doesSaveUnders :: Addr -> IO (Int)
displayOfScreen :: Screen -> Display
displayOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_displayOfScreen arg1 >>= \ (res1) ->
    (return ((Display res1)))})
primitive prim_Xlib_displayOfScreen :: Addr -> IO (Addr)

-- event mask at connection setup time - not current event mask!
eventMaskOfScreen :: Screen -> EventMask
eventMaskOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_eventMaskOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_eventMaskOfScreen :: Addr -> IO (Word32)

minCmapsOfScreen :: Screen -> Int
minCmapsOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_minCmapsOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_minCmapsOfScreen :: Addr -> IO (Int)
maxCmapsOfScreen :: Screen -> Int
maxCmapsOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_maxCmapsOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_maxCmapsOfScreen :: Addr -> IO (Int)
rootWindowOfScreen :: Screen -> Window
rootWindowOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_rootWindowOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_rootWindowOfScreen :: Addr -> IO (Word32)
widthOfScreen :: Screen -> Dimension
widthOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_widthOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_widthOfScreen :: Addr -> IO (Word32)
widthMMOfScreen :: Screen -> Dimension
widthMMOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_widthMMOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_widthMMOfScreen :: Addr -> IO (Word32)
heightOfScreen :: Screen -> Dimension
heightOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_heightOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_heightOfScreen :: Addr -> IO (Word32)
heightMMOfScreen :: Screen -> Dimension
heightMMOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_heightMMOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_heightMMOfScreen :: Addr -> IO (Word32)
planesOfScreen :: Screen -> Int
planesOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_planesOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_planesOfScreen :: Addr -> IO (Int)
screenNumberOfScreen :: Screen -> ScreenNumber
screenNumberOfScreen gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Screen arg1) ->
    prim_Xlib_screenNumberOfScreen arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_screenNumberOfScreen :: Addr -> IO (Word32)


----------------------------------------------------------------
-- Graphics contexts
----------------------------------------------------------------

-- Convenience functions

setArcMode :: Display -> GC -> ArcMode -> IO ()
setArcMode gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setArcMode arg1 arg2 arg3}
primitive prim_Xlib_setArcMode :: Addr -> Addr -> Int -> IO ()
setBackground :: Display -> GC -> Pixel -> IO ()
setBackground gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setBackground arg1 arg2 arg3}
primitive prim_Xlib_setBackground :: Addr -> Addr -> Word32 -> IO ()
setForeground :: Display -> GC -> Pixel -> IO ()
setForeground gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setForeground arg1 arg2 arg3}
primitive prim_Xlib_setForeground :: Addr -> Addr -> Word32 -> IO ()
setFunction :: Display -> GC -> GXFunction -> IO ()
setFunction gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setFunction arg1 arg2 arg3}
primitive prim_Xlib_setFunction :: Addr -> Addr -> Int -> IO ()
setGraphicsExposures :: Display -> GC -> Bool -> IO ()
setGraphicsExposures gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_bool_ gc_arg2) >>= \ (arg3) ->
  prim_Xlib_setGraphicsExposures arg1 arg2 arg3}
primitive prim_Xlib_setGraphicsExposures :: Addr -> Addr -> Int -> IO ()
setClipMask :: Display -> GC -> Pixmap -> IO ()
setClipMask gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setClipMask arg1 arg2 arg3}
primitive prim_Xlib_setClipMask :: Addr -> Addr -> Word32 -> IO ()
setClipOrigin :: Display -> GC -> Position -> Position -> IO ()
setClipOrigin gc_arg1 arg2 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  prim_Xlib_setClipOrigin arg1 arg2 arg3 arg4}}}
primitive prim_Xlib_setClipOrigin :: Addr -> Addr -> Int -> Int -> IO ()

-- XSetClipRectangles omitted because it's not clear when it's safe to delete the
-- array of rectangles

setDashes :: Display -> GC -> Int -> String -> Int -> IO ()
setDashes gc_arg1 arg2 arg3 gc_arg2 arg5 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg4) ->
  prim_Xlib_setDashes arg1 arg2 arg3 arg4 arg5}
primitive prim_Xlib_setDashes :: Addr -> Addr -> Int -> Addr -> Int -> IO ()
setFillRule :: Display -> GC -> FillRule -> IO ()
setFillRule gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setFillRule arg1 arg2 arg3}
primitive prim_Xlib_setFillRule :: Addr -> Addr -> Int -> IO ()
setFillStyle :: Display -> GC -> FillStyle -> IO ()
setFillStyle gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setFillStyle arg1 arg2 arg3}
primitive prim_Xlib_setFillStyle :: Addr -> Addr -> Int -> IO ()
setFont :: Display -> GC -> Font -> IO ()
setFont gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setFont arg1 arg2 arg3}
primitive prim_Xlib_setFont :: Addr -> Addr -> Word32 -> IO ()
setLineAttributes :: Display -> GC -> Int -> LineStyle -> CapStyle -> JoinStyle -> IO ()
setLineAttributes gc_arg1 arg2 arg3 arg4 arg5 arg6 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setLineAttributes arg1 arg2 arg3 arg4 arg5 arg6}
primitive prim_Xlib_setLineAttributes :: Addr -> Addr -> Int -> Int -> Int -> Int -> IO ()
setPlaneMask :: Display -> GC -> Pixel -> IO ()
setPlaneMask gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setPlaneMask arg1 arg2 arg3}
primitive prim_Xlib_setPlaneMask :: Addr -> Addr -> Word32 -> IO ()
setState :: Display -> GC -> Pixel -> Pixel -> GXFunction -> Pixel -> IO ()
setState gc_arg1 arg2 arg3 arg4 arg5 arg6 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setState arg1 arg2 arg3 arg4 arg5 arg6}
primitive prim_Xlib_setState :: Addr -> Addr -> Word32 -> Word32 -> Int -> Word32 -> IO ()
setStipple :: Display -> GC -> Pixmap -> IO ()
setStipple gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setStipple arg1 arg2 arg3}
primitive prim_Xlib_setStipple :: Addr -> Addr -> Word32 -> IO ()
setSubwindowMode :: Display -> GC -> SubWindowMode -> IO ()
setSubwindowMode gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setSubwindowMode arg1 arg2 arg3}
primitive prim_Xlib_setSubwindowMode :: Addr -> Addr -> Int -> IO ()
setTSOrigin :: Display -> GC -> Position -> Position -> IO ()
setTSOrigin gc_arg1 arg2 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  prim_Xlib_setTSOrigin arg1 arg2 arg3 arg4}}}
primitive prim_Xlib_setTSOrigin :: Addr -> Addr -> Int -> Int -> IO ()
setTile :: Display -> GC -> Pixmap -> IO ()
setTile gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setTile arg1 arg2 arg3}
primitive prim_Xlib_setTile :: Addr -> Addr -> Word32 -> IO ()

-- ToDo: create a real interface to this
createGC :: Display -> Drawable -> IO GC
createGC gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_createGC arg1 arg2 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_createGC :: Addr -> Word32 -> IO (Addr)

-- OLD: 
-- %synonym : GCValueSet : Ptr
--   in rtsDummy
-- 
-- {%
-- typedef unsigned long GCMask; /* cf XtGCMask */
-- typedef struct _gcvalues {
--     GCMask	mask;
--     XGCValues	values;
-- }* GCValueSet;
-- %}
--
-- IMPURE GCValueSet	emptyGCValueSet()
-- RESULT: (RETVAL = (GCValueSet) malloc(sizeof(struct _gcvalues))) ? RETVAL->mask = 0, RETVAL : RETVAL;
-- POST: RETVAL != NULL
-- 
-- IMPURE void	setGCForeground(colour, set)
-- IN Pixel	colour
-- IN GCValueSet	set
-- RESULT: set->mask |= GCForeground; set->values.foreground = colour
-- 
-- IMPURE void	setGCBackground(colour, set)
-- IN Pixel	colour
-- IN GCValueSet	set
-- RESULT: set->mask |= GCBackground; set->values.background = colour
-- 
-- IMPURE void	freeGCValueSet(set)
-- IN GCValueSet	set
-- RESULT: free(set)
-- 
-- IMPURE GC	XCreateGC(display, d, set->mask, &(set->values))
-- NAME: xCreateGC
-- IN Display*	display
-- IN Drawable	d
-- IN GCValueSet	set
-- 
-- IMPURE void	XChangeGC(display, gc, set->mask, &(set->values))
-- NAME: xChangeGC
-- IN Display*	display
-- IN GC		gc
-- IN GCValueSet	set
-- 
-- STARTH
-- -- Code that packages GCValueSets up in a clean monoidic way.
-- 
-- data GCSetter = GCSetter (GCValueSet -> IO ()) -- should be newtype 
-- 
-- createGC :: Display -> Drawable -> GCSetter -> IO GC
-- createGC display d (GCSetter setter) =
--   emptyGCValueSet        >>= \ set ->
--   setter set             >>
--   xCreateGC display d set >>= \ gc ->
--   freeGCValueSet set     >>
--   return gc
-- 
-- changeGC :: Display -> Drawable -> GC -> GCSetter -> IO ()
-- changeGC display d gc (GCSetter setter) =
--   emptyGCValueSet        >>= \ set ->
--   setter set             >>
--   xChangeGC display d set >>= \ gc ->
--   freeGCValueSet set
-- 
-- instance Monoid GCSetter where
--   (GCSetter m) >>> (GCSetter k) 
--     = GCSetter (\ settings -> m settings >> k settings)
--   unit = GCSetter (\ _ -> return ())
-- 
-- set_Background :: Pixel -> GCSetter
-- set_Background c = GCSetter (setGCBackground c)
-- 
-- set_Foreground :: Pixel -> GCSetter
-- set_Foreground c = GCSetter (setGCForeground c)
-- ENDH

gContextFromGC :: GC -> GContext
gContextFromGC arg1 =
  unsafePerformIO(
    prim_Xlib_gContextFromGC arg1 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_gContextFromGC :: Addr -> IO (Word32)

freeGC :: Display -> GC -> IO ()
freeGC gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_freeGC arg1 arg2}
primitive prim_Xlib_freeGC :: Addr -> Addr -> IO ()
flushGC :: Display -> GC -> IO ()
flushGC gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_flushGC arg1 arg2}
primitive prim_Xlib_flushGC :: Addr -> Addr -> IO ()

copyGC :: Display -> GC -> Mask -> GC -> IO ()
copyGC gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_copyGC arg1 arg2 arg3 arg4}
primitive prim_Xlib_copyGC :: Addr -> Addr -> Word32 -> Addr -> IO ()

----------------------------------------------------------------
-- Pixmaps
----------------------------------------------------------------

createPixmap :: Display -> Drawable -> Dimension -> Dimension -> Int -> IO Pixmap
createPixmap gc_arg1 arg2 arg3 arg4 arg5 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_createPixmap arg1 arg2 arg3 arg4 arg5 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_createPixmap :: Addr -> Word32 -> Word32 -> Word32 -> Int -> IO (Word32)
freePixmap :: Display -> Pixmap -> IO ()
freePixmap gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_freePixmap arg1 arg2}
primitive prim_Xlib_freePixmap :: Addr -> Word32 -> IO ()

-- XCreatePixmapFromBitmapData omitted (type looks strange)

-- %fun XListPixmapFormatValues = res1 = XListPixmapFormatValues(display, &res1_size) :: Display -> ListXPixmapFormatValues

----------------------------------------------------------------
-- Bitmaps
----------------------------------------------------------------

-- ToDo: do these need to be available to the programmer?
-- Maybe I could just wire them into all other operations?

bitmapBitOrder :: Display -> ByteOrder
bitmapBitOrder gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_bitmapBitOrder arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_bitmapBitOrder :: Addr -> IO (Int)
bitmapUnit :: Display -> Int
bitmapUnit gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_bitmapUnit arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_bitmapUnit :: Addr -> IO (Int)
bitmapPad :: Display -> Int
bitmapPad gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_bitmapPad arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_bitmapPad :: Addr -> IO (Int)

-- ToDo: make sure that initialisation works correctly for x/y_hot
-- omitted
-- IMPURE void	XWriteBitmapFile(display, filename, bitmap, width, height, x_hot, y_hot) RAISES Either
-- RETURNTYPE	BitmapFileStatus
-- GLOBAL ERROR BitmapFileStatus	RETVAL
-- IN Display*	display
-- IN String	filename
-- IN Pixmap	bitmap
-- IN Dimension	width
-- IN Dimension	height
-- IN Maybe Int	x_hot = -1
-- IN Maybe Int	y_hot = -1
-- POST: RETVAL == BitmapSuccess

-- omitted
-- IMPURE void	XReadBitmapFile(display, d, filename, bitmap, width, height, x_hot, y_hot) RAISES Either
-- RETURNTYPE	BitmapFileStatus
-- GLOBAL ERROR BitmapFileStatus	RETVAL
-- IN Display*	display
-- IN Drawable	d
-- IN String	filename
-- OUT Pixmap	bitmap
-- OUT Dimension	width
-- OUT Dimension	height
-- OUT Int		x_hot RAISES Maybe IF x_hot == -1
-- OUT Int		y_hot RAISES Maybe IF x_hot == -1
-- POST: RETVAL == BitmapSuccess

-- XCreateBitmapFromData omitted (awkward looking type)
-- XReadBitmapFileData omitted (awkward looking type)

----------------------------------------------------------------
-- Color and Colormaps
----------------------------------------------------------------

lookupColor :: Display -> Colormap -> String -> IO (Color,Color)
lookupColor gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg3) ->
  prim_Xlib_lookupColor arg1 arg2 arg3 >>= \ (gc_res1,gc_res3,gc_res5,gc_res7,gc_res9,gc_res10,gc_res12,gc_res14,gc_res16,gc_res18,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res2 = ( word32ToWord16  (gc_res3)) in
       let gc_res4 = ( word32ToWord16  (gc_res5)) in
       let gc_res6 = ( word32ToWord16  (gc_res7)) in
       let gc_res8 = ( word32ToWord8   (gc_res9)) in
       let gc_res11 = ( word32ToWord16  (gc_res12)) in
       let gc_res13 = ( word32ToWord16  (gc_res14)) in
       let gc_res15 = ( word32ToWord16  (gc_res16)) in
       let gc_res17 = ( word32ToWord8   (gc_res18)) in
       (return (((gc_res1,gc_res2,gc_res4,gc_res6,gc_res8),(gc_res10,gc_res11,gc_res13,gc_res15,gc_res17))))}
primitive prim_Xlib_lookupColor :: Addr -> Word32 -> Addr -> IO (Word32,Word32,Word32,Word32,Word32,Word32,Word32,Word32,Word32,Word32,Int,Addr)

allocNamedColor :: Display -> Colormap -> String -> IO (Color,Color)
allocNamedColor gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg3) ->
  prim_Xlib_allocNamedColor arg1 arg2 arg3 >>= \ (gc_res1,gc_res3,gc_res5,gc_res7,gc_res9,gc_res10,gc_res12,gc_res14,gc_res16,gc_res18,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res2 = ( word32ToWord16  (gc_res3)) in
       let gc_res4 = ( word32ToWord16  (gc_res5)) in
       let gc_res6 = ( word32ToWord16  (gc_res7)) in
       let gc_res8 = ( word32ToWord8   (gc_res9)) in
       let gc_res11 = ( word32ToWord16  (gc_res12)) in
       let gc_res13 = ( word32ToWord16  (gc_res14)) in
       let gc_res15 = ( word32ToWord16  (gc_res16)) in
       let gc_res17 = ( word32ToWord8   (gc_res18)) in
       (return (((gc_res1,gc_res2,gc_res4,gc_res6,gc_res8),(gc_res10,gc_res11,gc_res13,gc_res15,gc_res17))))}
primitive prim_Xlib_allocNamedColor :: Addr -> Word32 -> Addr -> IO (Word32,Word32,Word32,Word32,Word32,Word32,Word32,Word32,Word32,Word32,Int,Addr)

allocColor :: Display -> Colormap -> Color -> IO Color
allocColor gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg4,gc_arg6,gc_arg8,gc_arg10) ->
  case ( word16ToWord32  gc_arg4) of { gc_arg5 ->
  case ( word16ToWord32  gc_arg6) of { gc_arg7 ->
  case ( word16ToWord32  gc_arg8) of { gc_arg9 ->
  case ( word8ToWord32   gc_arg10) of { gc_arg11 ->
  prim_Xlib_allocColor arg1 arg2 gc_arg3 gc_arg5 gc_arg7 gc_arg9 gc_arg11 >>= \ (gc_res1,gc_res3,gc_res5,gc_res7,gc_res9,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res2 = ( word32ToWord16  (gc_res3)) in
       let gc_res4 = ( word32ToWord16  (gc_res5)) in
       let gc_res6 = ( word32ToWord16  (gc_res7)) in
       let gc_res8 = ( word32ToWord8   (gc_res9)) in
       (return ((gc_res1,gc_res2,gc_res4,gc_res6,gc_res8)))}}}}}}
primitive prim_Xlib_allocColor :: Addr -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> IO (Word32,Word32,Word32,Word32,Word32,Int,Addr)

parseColor :: Display -> Colormap -> String -> IO Color
parseColor gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg3) ->
  prim_Xlib_parseColor arg1 arg2 arg3 >>= \ (gc_res1,gc_res3,gc_res5,gc_res7,gc_res9,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res2 = ( word32ToWord16  (gc_res3)) in
       let gc_res4 = ( word32ToWord16  (gc_res5)) in
       let gc_res6 = ( word32ToWord16  (gc_res7)) in
       let gc_res8 = ( word32ToWord8   (gc_res9)) in
       (return ((gc_res1,gc_res2,gc_res4,gc_res6,gc_res8)))}
primitive prim_Xlib_parseColor :: Addr -> Word32 -> Addr -> IO (Word32,Word32,Word32,Word32,Word32,Int,Addr)

-- ToDo: Can't express relationship between arg4 and res1 properly (or arg5, res2)
-- %errfun Zero XAllocColorCells :: Display -> Colormap -> Bool -> Int -> Int -> IO (ListPixel, ListPixel) using err = XAllocColorCells(arg1,arg2,arg3,arg4_size,res1,arg5_size,res2) 

-- ToDo: Can't express relationship between arg4 and res1 properly
-- %errfun Zero XAllocColorPlanes :: Display -> Colormap -> Bool -> Int -> Int -> Int -> Int IO (ListPixel, Pixel, Pixel, Pixel) using err = XAllocColorPlanes(...)

freeColors :: Display -> Colormap -> ListPixel -> Pixel -> IO ()
freeColors gc_arg1 arg2 gc_arg2 arg4 =
  case gc_arg1 of { (Display arg1) ->
  (marshallWord32List gc_arg2) >>= \ (arg3,arg3_size) ->
  prim_Xlib_freeColors arg1 arg2 arg3 arg3_size arg4}
primitive prim_Xlib_freeColors :: Addr -> Word32 -> Addr -> Int -> Word32 -> IO ()

storeColor :: Display -> Colormap -> Color -> IO ()
storeColor gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg4,gc_arg6,gc_arg8,gc_arg10) ->
  case ( word16ToWord32  gc_arg4) of { gc_arg5 ->
  case ( word16ToWord32  gc_arg6) of { gc_arg7 ->
  case ( word16ToWord32  gc_arg8) of { gc_arg9 ->
  case ( word8ToWord32   gc_arg10) of { gc_arg11 ->
  prim_Xlib_storeColor arg1 arg2 gc_arg3 gc_arg5 gc_arg7 gc_arg9 gc_arg11}}}}}}
primitive prim_Xlib_storeColor :: Addr -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> IO ()

-- %fun XStoreColors :: Display -> Colormap -> ListColor -> IO ()         
-- %code XStoreColors(arg1,arg2,arg3,arg3_size) 
-- %fun XStoreNamedColor :: Display -> Colormap -> String -> Pixel -> PrimaryMask -> IO ()

queryColor :: Display -> Colormap -> Color -> IO Color
queryColor gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg4,gc_arg6,gc_arg8,gc_arg10) ->
  case ( word16ToWord32  gc_arg4) of { gc_arg5 ->
  case ( word16ToWord32  gc_arg6) of { gc_arg7 ->
  case ( word16ToWord32  gc_arg8) of { gc_arg9 ->
  case ( word8ToWord32   gc_arg10) of { gc_arg11 ->
  prim_Xlib_queryColor arg1 arg2 gc_arg3 gc_arg5 gc_arg7 gc_arg9 gc_arg11 >>= \ (gc_res1,gc_res3,gc_res5,gc_res7,gc_res9) ->
  let gc_res2 = ( word32ToWord16  (gc_res3)) in
  let gc_res4 = ( word32ToWord16  (gc_res5)) in
  let gc_res6 = ( word32ToWord16  (gc_res7)) in
  let gc_res8 = ( word32ToWord8   (gc_res9)) in
  (return ((gc_res1,gc_res2,gc_res4,gc_res6,gc_res8)))}}}}}}
primitive prim_Xlib_queryColor :: Addr -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> IO (Word32,Word32,Word32,Word32,Word32)

queryColors :: Display -> Colormap -> ListColor -> IO ListColor
queryColors gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshallAddrList allocColors writeColor gc_arg2) >>= \ (arg3,arg3_size) ->
  prim_Xlib_queryColors arg1 arg2 arg3 arg3_size >>= \ (gc_res2,gc_res3) ->
  (unmarshallAddrList readColor (gc_res2,gc_res3)) >>= \ gc_res1 ->
  (return (gc_res1))}
primitive prim_Xlib_queryColors :: Addr -> Word32 -> Addr -> Int -> IO (Addr,Int)

installColormap :: Display -> Colormap -> IO ()
installColormap gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_installColormap arg1 arg2}
primitive prim_Xlib_installColormap :: Addr -> Word32 -> IO ()
uninstallColormap :: Display -> Colormap -> IO ()
uninstallColormap gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_uninstallColormap arg1 arg2}
primitive prim_Xlib_uninstallColormap :: Addr -> Word32 -> IO ()
copyColormapAndFree :: Display -> Colormap -> IO Colormap
copyColormapAndFree gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_copyColormapAndFree arg1 arg2 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_copyColormapAndFree :: Addr -> Word32 -> IO (Word32)
createColormap :: Display -> Window -> Visual -> ColormapAlloc -> IO Colormap
createColormap gc_arg1 arg2 gc_arg2 arg4 =
  case gc_arg1 of { (Display arg1) ->
  case gc_arg2 of { (Visual arg3) ->
  prim_Xlib_createColormap arg1 arg2 arg3 arg4 >>= \ (res1) ->
  (return (res1))}}
primitive prim_Xlib_createColormap :: Addr -> Word32 -> Addr -> Int -> IO (Word32)
freeColormap :: Display -> Colormap -> IO ()
freeColormap gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_freeColormap arg1 arg2}
primitive prim_Xlib_freeColormap :: Addr -> Word32 -> IO ()


----------------------------------------------------------------
-- Fonts
----------------------------------------------------------------

-- A glyph (or Char2b) is a 16 bit character identification.
-- The top 8 bits are zero in many fonts.
type Glyph = Int

-- Disnae exist: %fun LoadFont       :: Display -> String -> IO Font
-- Disnae exist: %fun UnloadFont     :: Display -> Font -> IO ()

-- Argument can be a Font or a GContext.
-- But, if it's a GContext, the fontStruct will use the GContext as the 
-- FontID - which will cause most things to break so it's probably
-- safer using XGetGCValues to get a genuine font ID
queryFont :: Display -> Font -> IO FontStruct
queryFont gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_queryFont arg1 arg2 >>= \ (res1) ->
  (return ((FontStruct res1)))}
primitive prim_Xlib_queryFont :: Addr -> Word32 -> IO (Addr)

-- Note that this _WILL NOT WORK_ unless you have explicitly set the font.
-- I'm slowly but surely coming to the conclusion that Xlib is a pile of
-- steaming shit.
fontFromGC :: Display -> GC -> IO Font
fontFromGC gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_fontFromGC arg1 arg2 >>= \ (gc_res1,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (gc_res1))}
primitive prim_Xlib_fontFromGC :: Addr -> Addr -> IO (Word32,Int,Addr)

loadQueryFont :: Display -> String -> IO FontStruct
loadQueryFont gc_arg1 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg2) ->
  prim_Xlib_loadQueryFont arg1 arg2 >>= \ (res1,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return ((FontStruct res1)))}
primitive prim_Xlib_loadQueryFont :: Addr -> Addr -> IO (Addr,Int,Addr)

freeFont :: Display -> FontStruct -> IO ()
freeFont gc_arg1 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  case gc_arg2 of { (FontStruct arg2) ->
  prim_Xlib_freeFont arg1 arg2}}
primitive prim_Xlib_freeFont :: Addr -> Addr -> IO ()
-- %fun XSetFontPath  :: Display -> ListString  -> IO () using XSetFontPath(arg1,arg2,arg2_size)

fontFromFontStruct :: FontStruct -> Font
fontFromFontStruct gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (FontStruct arg1) ->
    prim_Xlib_fontFromFontStruct arg1 >>= \ (res1) ->
    (return (res1))})
primitive prim_Xlib_fontFromFontStruct :: Addr -> IO (Word32)
ascentFromFontStruct :: FontStruct -> Int32
ascentFromFontStruct gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (FontStruct arg1) ->
    prim_Xlib_ascentFromFontStruct arg1 >>= \ (res1) ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1))})
primitive prim_Xlib_ascentFromFontStruct :: Addr -> IO (Int)
descentFromFontStruct :: FontStruct -> Int32
descentFromFontStruct gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (FontStruct arg1) ->
    prim_Xlib_descentFromFontStruct arg1 >>= \ (res1) ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1))})
primitive prim_Xlib_descentFromFontStruct :: Addr -> IO (Int)

-- %prim XGetFontPath :: Display -> IO ListString
--Int r_size;
--String* r = XGetFontPath(arg1,&r_size);
-- %update(r);
--XFreeFontPath(r);
--return;

-- %prim XListFonts :: Display -> String -> Int -> IO ListString
--Int r_size;
--String *r = XListFonts(arg1,arg2,arg3,&r_size);
-- %update(r);
--XFreeFontNames(r);
--return;

-- XListFontsWithInfo omitted (no support for FontStruct yet)

-- XQueryTextExtents omitted (no support for CharStruct yet)
-- XQueryTextExtents16 omitted (no support for CharStruct yet)

-- We marshall this across right away because it's usually one-off info
type CharStruct =
 ( Int            -- lbearing (origin to left edge of raster)
 , Int            -- rbearing (origin to right edge of raster)
 , Int            -- width    (advance to next char's origin)
 , Int            -- ascent   (baseline to top edge of raster)
 , Int            -- descent  (baseline to bottom edge of raster)
-- attributes omitted
 )


-- No need to put ths in the IO monad - this info is essentially constant
textExtents :: FontStruct -> String -> (FontDirection,Int32,Int32,CharStruct)
textExtents gc_arg1 gc_arg2 =
  unsafePerformIO(
    case gc_arg1 of { (FontStruct f) ->
    (marshall_stringLen_ gc_arg2) >>= \ (s,s_len) ->
    prim_Xlib_textExtents f s s_len >>= \ (direction,font_ascent,font_descent,gc_res3,gc_res4,gc_res5,gc_res6,gc_res7) ->
    let gc_res1 = ( intToInt32  (font_ascent)) in
    let gc_res2 = ( intToInt32  (font_descent)) in
    (return ((direction,gc_res1,gc_res2,(gc_res3,gc_res4,gc_res5,gc_res6,gc_res7))))})
primitive prim_Xlib_textExtents :: Addr -> Addr -> Int -> IO (Int,Int,Int,Int,Int,Int,Int,Int)

-- No need to put ths in the IO monad - this info is essentially constant
textWidth :: FontStruct -> String -> Int32
textWidth gc_arg1 gc_arg2 =
  unsafePerformIO(
    case gc_arg1 of { (FontStruct f) ->
    (marshall_stringLen_ gc_arg2) >>= \ (s,s_len) ->
    prim_Xlib_textWidth f s s_len >>= \ (res1) ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1))})
primitive prim_Xlib_textWidth :: Addr -> Addr -> Int -> IO (Int)

-- XTextExtents16 omitted
-- XTextWidth16 omitted

-- XGetFontProperty omitted
-- XFreeFontInfo omitted
-- XFreeFontNames omitted

-- XCreateFontSet omitted (no documentation available)
-- XFreeFontSet omitted (no documentation available)
-- XFontsOfFontSet omitted (no documentation available)
-- XBaseFontNameListOfFontSet omitted (no documentation available)
-- XLocaleOfFontSet omitted (no documentation available)
-- XExtentsOfFontSet omitted (no documentation available)

-- XContextDependentDrawing omitted
-- XDirectionalDependentDrawing omitted
-- XContextualDrawing omitted

-- XmbTextEscapement omitted
-- XwcTextEscapement omitted
-- XmbTextExtents omitted
-- XwcTextExtents omitted
-- XmbTextPerCharExtents omitted
-- XwcTextPerCharExtents omitted
-- XmbDrawText omitted
-- XwcDrawText omitted
-- XmbDrawString omitted
-- XwcDrawString omitted
-- XmbDrawImageString omitted
-- XwcDrawImageString omitted

-- XOpenIM omitted
-- XCloseIM omitted
-- XGetIMValues omitted
-- XSetIMValues omitted
-- DisplayOfIM omitted
-- XLocaleOfIM omitted

-- XCreateIC omitted
-- XDestroyIC omitted
-- XSetICFocus omitted
-- XUnsetICFocus omitted
-- XwcResetIC omitted
-- XmbResetIC omitted
-- XSetICValues omitted
-- XGetICValues omitted
-- XIMOfIC omitted

-- XRegisterIMInstantiateCallback omitted
-- XUnregisterIMInstantiateCallback omitted

-- XInternalConnectionNumbers omitted
-- XProcessInternalConnection omitted
-- XAddConnectionWatch omitted
-- XRemoveConnectionWatch omitted

-- XmbLookupString omitted
-- XwcLookupString omitted

----------------------------------------------------------------
-- Atoms
----------------------------------------------------------------

-- AC, 1/9/2000: Added definition for XInternAtom
internAtom :: Display -> String -> Bool -> IO Atom
internAtom gc_arg1 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg2) ->
  (marshall_bool_ gc_arg3) >>= \ (arg3) ->
  prim_Xlib_internAtom arg1 arg2 arg3 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_internAtom :: Addr -> Addr -> Int -> IO (Word32)

-- XInternAtoms omitted
-- XGetAtomName omitted
-- XGetAtomNames omitted
-- XConvertSelection omitted
-- XListProperties omitted
-- XChangeProperty omitted
-- XDeleteProperty omitted

----------------------------------------------------------------
-- Keycodes
----------------------------------------------------------------

displayKeycodes :: Display -> (Int,Int)
displayKeycodes gc_arg1 =
  unsafePerformIO(
    case gc_arg1 of { (Display arg1) ->
    prim_Xlib_displayKeycodes arg1})
primitive prim_Xlib_displayKeycodes :: Addr -> IO (Int,Int)
lookupKeysym :: XKeyEventPtr -> Int -> IO KeySym
lookupKeysym arg1 arg2 =
  prim_Xlib_lookupKeysym arg1 arg2 >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_lookupKeysym :: Addr -> Int -> IO (Word32)
keycodeToKeysym :: Display -> KeyCode -> Int -> IO KeySym
keycodeToKeysym gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_keycodeToKeysym arg1 arg2 arg3 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_keycodeToKeysym :: Addr -> Char -> Int -> IO (Word32)
keysymToKeycode :: Display -> KeySym -> IO KeyCode
keysymToKeycode gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_keysymToKeycode arg1 arg2 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_keysymToKeycode :: Addr -> Word32 -> IO (Char)
keysymToString :: KeySym -> String
keysymToString arg1 =
  unsafePerformIO(
    prim_Xlib_keysymToString arg1 >>= \ (res1) ->
    (unmarshall_string_ res1) >>= \ gc_res1 ->
    (return (gc_res1)))
primitive prim_Xlib_keysymToString :: Word32 -> IO (Addr)
stringToKeysym :: String -> KeySym
stringToKeysym gc_arg1 =
  unsafePerformIO(
    (marshall_string_ gc_arg1) >>= \ (arg1) ->
    prim_Xlib_stringToKeysym arg1 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_stringToKeysym :: Addr -> IO (Word32)

-- I should not need to do this: the argument to maybeT below _should_
-- be treated as a C expression.
noSymbol :: KeySym
noSymbol =
  unsafePerformIO(
    prim_Xlib_noSymbol >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_noSymbol :: IO (Word32)

-- I tried to allocate the buffer below on the stack, but that was not a
-- good idea since the unmarshalling takes place in another stack frame.
-- I could use malloc, but then it seems tricky to free _after_ unmarshalling.
-- (%end free(buf) does not work: frees buffer too early.)
-- Making the buffer static works, but is potentially not thread safe.
-- But: the graphics library does not use X in a threadsafe way anyway
-- (does not import/call XInitThreads) and GHC is single threaded as far as
-- the external world is concerned(?).
-- OK, go static for now. Introduce a mutex if needs be.
-- XLookupString cannot handle compose, it seems.
lookupString :: XKeyEventPtr -> IO (Maybe KeySym,String)
lookupString e =
  prim_Xlib_lookupString e >>= \ (ks,buf,n) ->
  (if noSymbol == (ks)
   then return Nothing
   else (return ((Just ks)))) >>= \ gc_res1 ->
  (unmarshall_stringLen_ buf n) >>= \ gc_res2 ->
  (return ((gc_res1,gc_res2)))
primitive prim_Xlib_lookupString :: Addr -> IO (Word32,Addr,Int)

-- XQueryKeymap omitted
-- XRebindKeysym omitted
-- XDeleteModifiermapEntry omitted
-- XInsertModifiermapEntry omitted
-- XNewModifiermap omitted
-- XFreeModifiermap omitted
-- XSetModifierMapping omitted
-- XGetModifierMapping omitted
-- XGetKeyboardMapping omitted

----------------------------------------------------------------
-- Image
----------------------------------------------------------------

-- XCreateImage omitted
-- XInitImage omitted
-- XGetImage omitted
-- XPutImage omitted
-- XGetSubImage omitted

----------------------------------------------------------------
-- Icons
----------------------------------------------------------------

getIconName :: Display -> Window -> IO String
getIconName gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_getIconName arg1 arg2 >>= \ (res1,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (unmarshall_string_ res1) >>= \ gc_res1 ->
       (return (gc_res1))}
primitive prim_Xlib_getIconName :: Addr -> Word32 -> IO (Addr,Int,Addr)

setIconName :: Display -> Window -> String -> IO ()
setIconName gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg3) ->
  prim_Xlib_setIconName arg1 arg2 arg3}
primitive prim_Xlib_setIconName :: Addr -> Word32 -> Addr -> IO ()

----------------------------------------------------------------
-- Cursors
----------------------------------------------------------------

defineCursor :: Display -> Window -> Cursor -> IO ()
defineCursor gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_defineCursor arg1 arg2 arg3}
primitive prim_Xlib_defineCursor :: Addr -> Word32 -> Word32 -> IO ()
undefineCursor :: Display -> Window -> IO ()
undefineCursor gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_undefineCursor arg1 arg2}
primitive prim_Xlib_undefineCursor :: Addr -> Word32 -> IO ()

createPixmapCursor :: Display -> Pixmap -> Pixmap -> Color -> Color -> Dimension -> Dimension -> IO Cursor
createPixmapCursor gc_arg1 arg2 arg3 gc_arg2 gc_arg13 arg6 arg7 =
  case gc_arg1 of { (Display arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg4,gc_arg6,gc_arg8,gc_arg10) ->
  case ( word16ToWord32  gc_arg4) of { gc_arg5 ->
  case ( word16ToWord32  gc_arg6) of { gc_arg7 ->
  case ( word16ToWord32  gc_arg8) of { gc_arg9 ->
  case ( word8ToWord32   gc_arg10) of { gc_arg11 ->
  case gc_arg13 of { (gc_arg14,gc_arg15,gc_arg17,gc_arg19,gc_arg21) ->
  case ( word16ToWord32  gc_arg15) of { gc_arg16 ->
  case ( word16ToWord32  gc_arg17) of { gc_arg18 ->
  case ( word16ToWord32  gc_arg19) of { gc_arg20 ->
  case ( word8ToWord32   gc_arg21) of { gc_arg22 ->
  prim_Xlib_createPixmapCursor arg1 arg2 arg3 gc_arg3 gc_arg5 gc_arg7 gc_arg9 gc_arg11 gc_arg14 gc_arg16 gc_arg18 gc_arg20 gc_arg22 arg6 arg7 >>= \ (res1) ->
  (return (res1))}}}}}}}}}}}
primitive prim_Xlib_createPixmapCursor :: Addr -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> IO (Word32)

createGlyphCursor :: Display -> Font -> Font -> Glyph -> Glyph -> Color -> Color -> IO Cursor
createGlyphCursor gc_arg1 arg2 arg3 arg4 arg5 gc_arg2 gc_arg13 =
  case gc_arg1 of { (Display arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg4,gc_arg6,gc_arg8,gc_arg10) ->
  case ( word16ToWord32  gc_arg4) of { gc_arg5 ->
  case ( word16ToWord32  gc_arg6) of { gc_arg7 ->
  case ( word16ToWord32  gc_arg8) of { gc_arg9 ->
  case ( word8ToWord32   gc_arg10) of { gc_arg11 ->
  case gc_arg13 of { (gc_arg14,gc_arg15,gc_arg17,gc_arg19,gc_arg21) ->
  case ( word16ToWord32  gc_arg15) of { gc_arg16 ->
  case ( word16ToWord32  gc_arg17) of { gc_arg18 ->
  case ( word16ToWord32  gc_arg19) of { gc_arg20 ->
  case ( word8ToWord32   gc_arg21) of { gc_arg22 ->
  prim_Xlib_createGlyphCursor arg1 arg2 arg3 arg4 arg5 gc_arg3 gc_arg5 gc_arg7 gc_arg9 gc_arg11 gc_arg14 gc_arg16 gc_arg18 gc_arg20 gc_arg22 >>= \ (res1) ->
  (return (res1))}}}}}}}}}}}
primitive prim_Xlib_createGlyphCursor :: Addr -> Word32 -> Word32 -> Int -> Int -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> IO (Word32)

createFontCursor :: Display -> Glyph -> IO Cursor
createFontCursor gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_createFontCursor arg1 arg2 >>= \ (res1) ->
  (return (res1))}
primitive prim_Xlib_createFontCursor :: Addr -> Int -> IO (Word32)
freeCursor :: Display -> Font -> IO ()
freeCursor gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_freeCursor arg1 arg2}
primitive prim_Xlib_freeCursor :: Addr -> Word32 -> IO ()
recolorCursor :: Display -> Cursor -> Color -> Color -> IO ()
recolorCursor gc_arg1 arg2 gc_arg2 gc_arg13 =
  case gc_arg1 of { (Display arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg4,gc_arg6,gc_arg8,gc_arg10) ->
  case ( word16ToWord32  gc_arg4) of { gc_arg5 ->
  case ( word16ToWord32  gc_arg6) of { gc_arg7 ->
  case ( word16ToWord32  gc_arg8) of { gc_arg9 ->
  case ( word8ToWord32   gc_arg10) of { gc_arg11 ->
  case gc_arg13 of { (gc_arg14,gc_arg15,gc_arg17,gc_arg19,gc_arg21) ->
  case ( word16ToWord32  gc_arg15) of { gc_arg16 ->
  case ( word16ToWord32  gc_arg17) of { gc_arg18 ->
  case ( word16ToWord32  gc_arg19) of { gc_arg20 ->
  case ( word8ToWord32   gc_arg21) of { gc_arg22 ->
  prim_Xlib_recolorCursor arg1 arg2 gc_arg3 gc_arg5 gc_arg7 gc_arg9 gc_arg11 gc_arg14 gc_arg16 gc_arg18 gc_arg20 gc_arg22}}}}}}}}}}}
primitive prim_Xlib_recolorCursor :: Addr -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> Word32 -> IO ()

----------------------------------------------------------------
-- Window Manager stuff
----------------------------------------------------------------

-- XConfigureWMWindow omitted (can't find documentation)
-- XReconfigureWMWindow omitted (can't find documentation)
-- XWMGeometry omitted (can't find documentation)
-- XGetWMColormapWindows omitted (can't find documentation)
-- XSetWMColormapWindows omitted (can't find documentation)
-- XGetWMProtocols omitted

-- AC, 1/9/2000: Added definition for XSetWMProtocols
setWMProtocols :: Display -> Window -> ListAtom -> IO ()
setWMProtocols gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshallWord32List gc_arg2) >>= \ (arg3,arg3_size) ->
  prim_Xlib_setWMProtocols arg1 arg2 arg3 arg3_size}
primitive prim_Xlib_setWMProtocols :: Addr -> Word32 -> Addr -> Int -> IO ()


----------------------------------------------------------------
-- Set Window Attributes
----------------------------------------------------------------

-- The following code is based on what you get from the %ptr declaration.
-- ToDo: generate this kind of stuff automatically.

type XSetWindowAttributesPtr = Addr
--  toXSetWindowAttributesPtr   :: Addr -> XSetWindowAttributesPtr,
--  fromXSetWindowAttributesPtr :: XSetWindowAttributesPtr -> Ptr

allocXSetWindowAttributes :: IO XSetWindowAttributesPtr
allocXSetWindowAttributes =
  prim_Xlib_allocXSetWindowAttributes >>= \ (res1) ->
  (return (res1))
primitive prim_Xlib_allocXSetWindowAttributes :: IO (Addr)


-- toXSetWindowAttributesPtr   x = x 
-- fromXSetWindowAttributesPtr x = x
-- 
-- instance Pointer XSetWindowAttributesPtr where
--   toPtr     = fromXSetWindowAttributesPtr
--   fromPtr   = toXSetWindowAttributesPtr
--   alloc     = malloc sizeofXSetWindowAttributes
--   plus p x  = fromPtr (plusPtr (toPtr p) (x * sizeofXSetWindowAttributes))
--   minus p q = (toPtr p `minusPtr` toPtr q) `div` sizeofXSetWindowAttributes
-- %}}
-- 
-- %type : XSetWindowAttributesPtr : XSetWindowAttributes* arg1 : %pack(Ptr,arg1);% : %unpack(Ptr,arg1,arg2);%
-- 
-- %const Int sizeofXSetWindowAttributes = sizeof(XSetWindowAttributes)

---------------- Access to individual fields ----------------

set_background_pixmap :: XSetWindowAttributesPtr -> Pixmap -> IO ()
set_background_pixmap arg1 arg2 =
  prim_Xlib_set_background_pixmap arg1 arg2
primitive prim_Xlib_set_background_pixmap :: Addr -> Word32 -> IO ()

set_background_pixel :: XSetWindowAttributesPtr -> Pixel -> IO ()
set_background_pixel arg1 arg2 =
  prim_Xlib_set_background_pixel arg1 arg2
primitive prim_Xlib_set_background_pixel :: Addr -> Word32 -> IO ()

set_border_pixmap :: XSetWindowAttributesPtr -> Pixmap -> IO ()
set_border_pixmap arg1 arg2 =
  prim_Xlib_set_border_pixmap arg1 arg2
primitive prim_Xlib_set_border_pixmap :: Addr -> Word32 -> IO ()

set_border_pixel :: XSetWindowAttributesPtr -> Pixel -> IO ()
set_border_pixel arg1 arg2 =
  prim_Xlib_set_border_pixel arg1 arg2
primitive prim_Xlib_set_border_pixel :: Addr -> Word32 -> IO ()

set_bit_gravity :: XSetWindowAttributesPtr -> BitGravity -> IO ()
set_bit_gravity arg1 arg2 =
  prim_Xlib_set_bit_gravity arg1 arg2
primitive prim_Xlib_set_bit_gravity :: Addr -> Int -> IO ()

set_win_gravity :: XSetWindowAttributesPtr -> WindowGravity -> IO ()
set_win_gravity arg1 arg2 =
  prim_Xlib_set_win_gravity arg1 arg2
primitive prim_Xlib_set_win_gravity :: Addr -> Int -> IO ()

set_backing_store :: XSetWindowAttributesPtr -> BackingStore -> IO ()
set_backing_store arg1 arg2 =
  prim_Xlib_set_backing_store arg1 arg2
primitive prim_Xlib_set_backing_store :: Addr -> Int -> IO ()

set_backing_planes :: XSetWindowAttributesPtr -> Pixel -> IO ()
set_backing_planes arg1 arg2 =
  prim_Xlib_set_backing_planes arg1 arg2
primitive prim_Xlib_set_backing_planes :: Addr -> Word32 -> IO ()

set_backing_pixel :: XSetWindowAttributesPtr -> Pixel -> IO ()
set_backing_pixel arg1 arg2 =
  prim_Xlib_set_backing_pixel arg1 arg2
primitive prim_Xlib_set_backing_pixel :: Addr -> Word32 -> IO ()

set_save_under :: XSetWindowAttributesPtr -> Bool -> IO ()
set_save_under arg1 gc_arg1 =
  (marshall_bool_ gc_arg1) >>= \ (arg2) ->
  prim_Xlib_set_save_under arg1 arg2
primitive prim_Xlib_set_save_under :: Addr -> Int -> IO ()

set_event_mask :: XSetWindowAttributesPtr -> EventMask -> IO ()
set_event_mask arg1 arg2 =
  prim_Xlib_set_event_mask arg1 arg2
primitive prim_Xlib_set_event_mask :: Addr -> Word32 -> IO ()

set_do_not_propagate_mask :: XSetWindowAttributesPtr -> EventMask -> IO ()
set_do_not_propagate_mask arg1 arg2 =
  prim_Xlib_set_do_not_propagate_mask arg1 arg2
primitive prim_Xlib_set_do_not_propagate_mask :: Addr -> Word32 -> IO ()

set_override_redirect :: XSetWindowAttributesPtr -> Bool -> IO ()
set_override_redirect arg1 gc_arg1 =
  (marshall_bool_ gc_arg1) >>= \ (arg2) ->
  prim_Xlib_set_override_redirect arg1 arg2
primitive prim_Xlib_set_override_redirect :: Addr -> Int -> IO ()

set_colormap :: XSetWindowAttributesPtr -> Colormap -> IO ()
set_colormap arg1 arg2 =
  prim_Xlib_set_colormap arg1 arg2
primitive prim_Xlib_set_colormap :: Addr -> Word32 -> IO ()

set_cursor :: XSetWindowAttributesPtr -> Cursor -> IO ()
set_cursor arg1 arg2 =
  prim_Xlib_set_cursor arg1 arg2
primitive prim_Xlib_set_cursor :: Addr -> Word32 -> IO ()

----------------------------------------------------------------
-- Windows
----------------------------------------------------------------

storeName :: Display -> Window -> String -> IO ()
storeName gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_string_ gc_arg2) >>= \ (arg3) ->
  prim_Xlib_storeName arg1 arg2 arg3}
primitive prim_Xlib_storeName :: Addr -> Word32 -> Addr -> IO ()
createSimpleWindow :: Display -> Window -> Position -> Position -> Dimension -> Dimension -> Int -> Pixel -> Pixel -> IO Window
createSimpleWindow gc_arg1 arg2 gc_arg2 gc_arg3 arg5 arg6 arg7 arg8 arg9 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  prim_Xlib_createSimpleWindow arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 >>= \ (res1) ->
  (return (res1))}}}
primitive prim_Xlib_createSimpleWindow :: Addr -> Word32 -> Int -> Int -> Word32 -> Word32 -> Int -> Word32 -> Word32 -> IO (Word32)

createWindow :: Display -> Window -> Position -> Position -> Dimension -> Dimension -> Int -> Int -> WindowClass -> Visual -> AttributeMask -> XSetWindowAttributesPtr -> IO Window
createWindow gc_arg1 arg2 gc_arg2 gc_arg3 arg5 arg6 arg7 arg8 arg9 gc_arg4 arg11 arg12 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  case gc_arg4 of { (Visual arg10) ->
  prim_Xlib_createWindow arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10 arg11 arg12 >>= \ (res1) ->
  (return (res1))}}}}
primitive prim_Xlib_createWindow :: Addr -> Word32 -> Int -> Int -> Word32 -> Word32 -> Int -> Int -> Int -> Addr -> Word32 -> Addr -> IO (Word32)

----------------------------------------------------------------

--ToDo: find an effective way to use Maybes
translateCoordinates :: Display -> Window -> Window -> Position -> Position -> IO (Bool,Position,Position,Window)
translateCoordinates gc_arg1 arg2 arg3 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  prim_Xlib_translateCoordinates arg1 arg2 arg3 arg4 arg5 >>= \ (res1,res2,res3,res4) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  let gc_res2 = ( intToInt32  (res2)) in
  let gc_res3 = ( intToInt32  (res3)) in
  (return ((gc_res1,gc_res2,gc_res3,res4)))}}}
primitive prim_Xlib_translateCoordinates :: Addr -> Word32 -> Word32 -> Int -> Int -> IO (Int,Int,Int,Word32)

moveResizeWindow :: Display -> Window -> Position -> Position -> Dimension -> Dimension -> IO ()
moveResizeWindow gc_arg1 arg2 gc_arg2 gc_arg3 arg5 arg6 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  prim_Xlib_moveResizeWindow arg1 arg2 arg3 arg4 arg5 arg6}}}
primitive prim_Xlib_moveResizeWindow :: Addr -> Word32 -> Int -> Int -> Word32 -> Word32 -> IO ()
resizeWindow :: Display -> Window -> Dimension -> Dimension -> IO ()
resizeWindow gc_arg1 arg2 arg3 arg4 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_resizeWindow arg1 arg2 arg3 arg4}
primitive prim_Xlib_resizeWindow :: Addr -> Word32 -> Word32 -> Word32 -> IO ()
moveWindow :: Display -> Window -> Position -> Position -> IO ()
moveWindow gc_arg1 arg2 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  prim_Xlib_moveWindow arg1 arg2 arg3 arg4}}}
primitive prim_Xlib_moveWindow :: Addr -> Word32 -> Int -> Int -> IO ()
reparentWindow :: Display -> Window -> Window -> Position -> Position -> IO ()
reparentWindow gc_arg1 arg2 arg3 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  prim_Xlib_reparentWindow arg1 arg2 arg3 arg4 arg5}}}
primitive prim_Xlib_reparentWindow :: Addr -> Word32 -> Word32 -> Int -> Int -> IO ()
mapSubwindows :: Display -> Window -> IO ()
mapSubwindows gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_mapSubwindows arg1 arg2}
primitive prim_Xlib_mapSubwindows :: Addr -> Word32 -> IO ()
unmapSubwindows :: Display -> Window -> IO ()
unmapSubwindows gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_unmapSubwindows arg1 arg2}
primitive prim_Xlib_unmapSubwindows :: Addr -> Word32 -> IO ()
mapWindow :: Display -> Window -> IO ()
mapWindow gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_mapWindow arg1 arg2}
primitive prim_Xlib_mapWindow :: Addr -> Word32 -> IO ()
-- Disnae exist: %fun XUnmapWindows                :: Display -> Window -> IO ()
-- Disnae exist: %fun XMapRaisedWindow             :: Display -> Window -> IO ()
lowerWindow :: Display -> Window -> IO ()
lowerWindow gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_lowerWindow arg1 arg2}
primitive prim_Xlib_lowerWindow :: Addr -> Word32 -> IO ()
raiseWindow :: Display -> Window -> IO ()
raiseWindow gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_raiseWindow arg1 arg2}
primitive prim_Xlib_raiseWindow :: Addr -> Word32 -> IO ()
circulateSubwindowsDown :: Display -> Window -> IO ()
circulateSubwindowsDown gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_circulateSubwindowsDown arg1 arg2}
primitive prim_Xlib_circulateSubwindowsDown :: Addr -> Word32 -> IO ()
circulateSubwindowsUp :: Display -> Window -> IO ()
circulateSubwindowsUp gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_circulateSubwindowsUp arg1 arg2}
primitive prim_Xlib_circulateSubwindowsUp :: Addr -> Word32 -> IO ()
circulateSubwindows :: Display -> Window -> CirculationDirection -> IO ()
circulateSubwindows gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_circulateSubwindows arg1 arg2 arg3}
primitive prim_Xlib_circulateSubwindows :: Addr -> Word32 -> Int -> IO ()
iconifyWindow :: Display -> Window -> ScreenNumber -> IO ()
iconifyWindow gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_iconifyWindow arg1 arg2 arg3 >>= \ (gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
primitive prim_Xlib_iconifyWindow :: Addr -> Word32 -> Word32 -> IO (Int,Addr)
withdrawWindow :: Display -> Window -> ScreenNumber -> IO ()
withdrawWindow gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_withdrawWindow arg1 arg2 arg3 >>= \ (gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
primitive prim_Xlib_withdrawWindow :: Addr -> Word32 -> Word32 -> IO (Int,Addr)
destroyWindow :: Display -> Window -> IO ()
destroyWindow gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_destroyWindow arg1 arg2}
primitive prim_Xlib_destroyWindow :: Addr -> Word32 -> IO ()
destroySubwindows :: Display -> Window -> IO ()
destroySubwindows gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_destroySubwindows arg1 arg2}
primitive prim_Xlib_destroySubwindows :: Addr -> Word32 -> IO ()

setWindowBorder :: Display -> Window -> Pixel -> IO ()
setWindowBorder gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setWindowBorder arg1 arg2 arg3}
primitive prim_Xlib_setWindowBorder :: Addr -> Word32 -> Word32 -> IO ()
setWindowBorderPixmap :: Display -> Window -> Pixmap -> IO ()
setWindowBorderPixmap gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setWindowBorderPixmap arg1 arg2 arg3}
primitive prim_Xlib_setWindowBorderPixmap :: Addr -> Word32 -> Word32 -> IO ()
setWindowBorderWidth :: Display -> Window -> Dimension -> IO ()
setWindowBorderWidth gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setWindowBorderWidth arg1 arg2 arg3}
primitive prim_Xlib_setWindowBorderWidth :: Addr -> Word32 -> Word32 -> IO ()
setWindowBackground :: Display -> Window -> Pixel -> IO ()
setWindowBackground gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setWindowBackground arg1 arg2 arg3}
primitive prim_Xlib_setWindowBackground :: Addr -> Word32 -> Word32 -> IO ()
setWindowBackgroundPixmap :: Display -> Window -> Pixmap -> IO ()
setWindowBackgroundPixmap gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setWindowBackgroundPixmap arg1 arg2 arg3}
primitive prim_Xlib_setWindowBackgroundPixmap :: Addr -> Word32 -> Word32 -> IO ()
setWindowColormap :: Display -> Window -> Colormap -> IO ()
setWindowColormap gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_setWindowColormap arg1 arg2 arg3}
primitive prim_Xlib_setWindowColormap :: Addr -> Word32 -> Word32 -> IO ()

addToSaveSet :: Display -> Window -> IO ()
addToSaveSet gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_addToSaveSet arg1 arg2}
primitive prim_Xlib_addToSaveSet :: Addr -> Word32 -> IO ()
removeFromSaveSet :: Display -> Window -> IO ()
removeFromSaveSet gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_removeFromSaveSet arg1 arg2}
primitive prim_Xlib_removeFromSaveSet :: Addr -> Word32 -> IO ()
changeSaveSet :: Display -> Window -> ChangeSaveSetMode -> IO ()
changeSaveSet gc_arg1 arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_changeSaveSet arg1 arg2 arg3}
primitive prim_Xlib_changeSaveSet :: Addr -> Word32 -> Int -> IO ()

clearWindow :: Display -> Window -> IO ()
clearWindow gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_clearWindow arg1 arg2}
primitive prim_Xlib_clearWindow :: Addr -> Word32 -> IO ()
clearArea :: Display -> Window -> Position -> Position -> Dimension -> Dimension -> Bool -> IO ()
clearArea gc_arg1 arg2 gc_arg2 gc_arg3 arg5 arg6 gc_arg4 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  case ( int32ToInt  gc_arg3) of { arg4 ->
  (marshall_bool_ gc_arg4) >>= \ (arg7) ->
  prim_Xlib_clearArea arg1 arg2 arg3 arg4 arg5 arg6 arg7}}}
primitive prim_Xlib_clearArea :: Addr -> Word32 -> Int -> Int -> Word32 -> Word32 -> Int -> IO ()

-- -- This is almost good enough - but doesn't call XFree
-- -- %errfun BadStatus XQueryTree :: Display -> Window -> IO (Window, Window, ListWindow) using err = XQueryTree(arg1,arg2,&res1,&res2,&res3,&res3_size)
-- %prim XQueryTree :: Display -> Window -> IO (Window, Window, ListWindow)
-- Window root_w, parent;
-- Int children_size;
-- Window *children;
-- Status r = XQueryTree(arg1,arg2,&root_w, &parent, &children, &children_size);
-- if (Success != r) { %failWith(BadStatus,r); }
-- %update(root_w,parent,children);
-- XFree(children);
-- return;

restackWindows :: Display -> ListWindow -> IO ()
restackWindows gc_arg1 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshallWord32List gc_arg2) >>= \ (arg2,arg2_size) ->
  prim_Xlib_restackWindows arg1 arg2 arg2_size}
primitive prim_Xlib_restackWindows :: Addr -> Addr -> Int -> IO ()

-- -- ToDo: I want to be able to write this
-- -- %fun XListInstalledColormaps :: Display -> Window -> IO ListColormap using res1 = XListInstalledColormaps(arg1,arg2,&res1_size) 
-- -- But I have to write this instead - need to add a notion of cleanup code!
-- %prim XListInstalledColormaps :: Display -> Window -> IO ListColormap
-- Int r_size;
-- Colormap* r = XListInstalledColormaps(arg1,arg2,&r_size);
-- %update(r);
-- XFree(r);
-- return;
-- 
-- -- Again, this is almost good enough
-- -- %errfun BadStatus XGetCommand :: Display -> Window -> IO ListString using err = XGetCommand(arg1,arg2,&res1,&res1_size)
-- -- but not quite
-- -- %prim XGetCommand :: Display -> Window -> IO ListString
-- --Int    argv_size;
-- --String *argv;
-- --Status r = XGetCommand(arg1,arg2,&argv,&argv_size);
-- --if (Success != r) { %failWith(BadStatus, r); }
-- -- %update(argv);
-- --XFreeStringList(argv);
-- --return;
-- 
-- -- %fun XSetCommand :: Display -> Window -> ListString -> IO ()            using XSetCommand(arg1,arg2,arg3,res3_size)
-- 
-- %errfun BadStatus XGetTransientForHint :: Display -> Window -> IO Window using err = XGetTransientForHint(arg1,arg2,&res1)
-- 
-- %fun XSetTransientForHint :: Display -> Window -> Window -> IO ()
-- 
-- -- XRotateWindowProperties omitted
-- -- XGetWindowProperty omitted
-- 
-- -- XGetWindowAttributes omitted
-- -- XChangeWindowAttributes omitted

----------------------------------------------------------------
-- Drawing
----------------------------------------------------------------

drawPoint :: Display -> Drawable -> GC -> Position -> Position -> IO ()
drawPoint gc_arg1 arg2 arg3 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  prim_Xlib_drawPoint arg1 arg2 arg3 arg4 arg5}}}
primitive prim_Xlib_drawPoint :: Addr -> Word32 -> Addr -> Int -> Int -> IO ()

drawPoints :: Display -> Drawable -> GC -> ListPoint -> CoordinateMode -> IO ()
drawPoints gc_arg1 arg2 arg3 gc_arg2 arg5 =
  case gc_arg1 of { (Display arg1) ->
  (marshallAddrList allocPoints writePoint gc_arg2) >>= \ (arg4,arg4_size) ->
  prim_Xlib_drawPoints arg1 arg2 arg3 arg4 arg4_size arg5}
primitive prim_Xlib_drawPoints :: Addr -> Word32 -> Addr -> Addr -> Int -> Int -> IO ()

drawLine :: Display -> Drawable -> GC -> Position -> Position -> Position -> Position -> IO ()
drawLine gc_arg1 arg2 arg3 gc_arg2 gc_arg3 gc_arg4 gc_arg5 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  case ( int32ToInt  gc_arg4) of { arg6 ->
  case ( int32ToInt  gc_arg5) of { arg7 ->
  prim_Xlib_drawLine arg1 arg2 arg3 arg4 arg5 arg6 arg7}}}}}
primitive prim_Xlib_drawLine :: Addr -> Word32 -> Addr -> Int -> Int -> Int -> Int -> IO ()

drawLines :: Display -> Drawable -> GC -> ListPoint -> CoordinateMode -> IO ()
drawLines gc_arg1 arg2 arg3 gc_arg2 arg5 =
  case gc_arg1 of { (Display arg1) ->
  (marshallAddrList allocPoints writePoint gc_arg2) >>= \ (arg4,arg4_size) ->
  prim_Xlib_drawLines arg1 arg2 arg3 arg4 arg4_size arg5}
primitive prim_Xlib_drawLines :: Addr -> Word32 -> Addr -> Addr -> Int -> Int -> IO ()

drawSegments :: Display -> Drawable -> GC -> ListSegment -> IO ()
drawSegments gc_arg1 arg2 arg3 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshallAddrList allocSegments writeSegment gc_arg2) >>= \ (arg4,arg4_size) ->
  prim_Xlib_drawSegments arg1 arg2 arg3 arg4 arg4_size}
primitive prim_Xlib_drawSegments :: Addr -> Word32 -> Addr -> Addr -> Int -> IO ()

drawRectangle :: Display -> Drawable -> GC -> Position -> Position -> Dimension -> Dimension -> IO ()
drawRectangle gc_arg1 arg2 arg3 gc_arg2 gc_arg3 arg6 arg7 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  prim_Xlib_drawRectangle arg1 arg2 arg3 arg4 arg5 arg6 arg7}}}
primitive prim_Xlib_drawRectangle :: Addr -> Word32 -> Addr -> Int -> Int -> Word32 -> Word32 -> IO ()

drawRectangles :: Display -> Drawable -> GC -> ListRectangle -> IO ()
drawRectangles gc_arg1 arg2 arg3 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshallAddrList allocRectangles writeRectangle gc_arg2) >>= \ (arg4,arg4_size) ->
  prim_Xlib_drawRectangles arg1 arg2 arg3 arg4 arg4_size}
primitive prim_Xlib_drawRectangles :: Addr -> Word32 -> Addr -> Addr -> Int -> IO ()

drawArc :: Display -> Drawable -> GC -> Position -> Position -> Dimension -> Dimension -> Int -> Int -> IO ()
drawArc gc_arg1 arg2 arg3 gc_arg2 gc_arg3 arg6 arg7 arg8 arg9 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  prim_Xlib_drawArc arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9}}}
primitive prim_Xlib_drawArc :: Addr -> Word32 -> Addr -> Int -> Int -> Word32 -> Word32 -> Int -> Int -> IO ()

drawArcs :: Display -> Drawable -> GC -> ListArc -> IO ()
drawArcs gc_arg1 arg2 arg3 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshallAddrList allocArcs writeArc gc_arg2) >>= \ (arg4,arg4_size) ->
  prim_Xlib_drawArcs arg1 arg2 arg3 arg4 arg4_size}
primitive prim_Xlib_drawArcs :: Addr -> Word32 -> Addr -> Addr -> Int -> IO ()

fillRectangle :: Display -> Drawable -> GC -> Position -> Position -> Dimension -> Dimension -> IO ()
fillRectangle gc_arg1 arg2 arg3 gc_arg2 gc_arg3 arg6 arg7 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  prim_Xlib_fillRectangle arg1 arg2 arg3 arg4 arg5 arg6 arg7}}}
primitive prim_Xlib_fillRectangle :: Addr -> Word32 -> Addr -> Int -> Int -> Word32 -> Word32 -> IO ()

fillRectangles :: Display -> Drawable -> GC -> ListRectangle -> IO ()
fillRectangles gc_arg1 arg2 arg3 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshallAddrList allocRectangles writeRectangle gc_arg2) >>= \ (arg4,arg4_size) ->
  prim_Xlib_fillRectangles arg1 arg2 arg3 arg4 arg4_size}
primitive prim_Xlib_fillRectangles :: Addr -> Word32 -> Addr -> Addr -> Int -> IO ()

fillPolygon :: Display -> Drawable -> GC -> ListPoint -> PolygonShape -> CoordinateMode -> IO ()
fillPolygon gc_arg1 arg2 arg3 gc_arg2 arg5 arg6 =
  case gc_arg1 of { (Display arg1) ->
  (marshallAddrList allocPoints writePoint gc_arg2) >>= \ (arg4,arg4_size) ->
  prim_Xlib_fillPolygon arg1 arg2 arg3 arg4 arg4_size arg5 arg6}
primitive prim_Xlib_fillPolygon :: Addr -> Word32 -> Addr -> Addr -> Int -> Int -> Int -> IO ()

fillArc :: Display -> Drawable -> GC -> Position -> Position -> Dimension -> Dimension -> Int -> Int -> IO ()
fillArc gc_arg1 arg2 arg3 gc_arg2 gc_arg3 arg6 arg7 arg8 arg9 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  prim_Xlib_fillArc arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9}}}
primitive prim_Xlib_fillArc :: Addr -> Word32 -> Addr -> Int -> Int -> Word32 -> Word32 -> Int -> Int -> IO ()

fillArcs :: Display -> Drawable -> GC -> ListArc -> IO ()
fillArcs gc_arg1 arg2 arg3 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshallAddrList allocArcs writeArc gc_arg2) >>= \ (arg4,arg4_size) ->
  prim_Xlib_fillArcs arg1 arg2 arg3 arg4 arg4_size}
primitive prim_Xlib_fillArcs :: Addr -> Word32 -> Addr -> Addr -> Int -> IO ()

copyArea :: Display -> Drawable -> Drawable -> GC -> Position -> Position -> Dimension -> Dimension -> Position -> Position -> IO ()
copyArea gc_arg1 arg2 arg3 arg4 gc_arg2 gc_arg3 arg7 arg8 gc_arg4 gc_arg5 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg5 ->
  case ( int32ToInt  gc_arg3) of { arg6 ->
  case ( int32ToInt  gc_arg4) of { arg9 ->
  case ( int32ToInt  gc_arg5) of { arg10 ->
  prim_Xlib_copyArea arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10}}}}}
primitive prim_Xlib_copyArea :: Addr -> Word32 -> Word32 -> Addr -> Int -> Int -> Word32 -> Word32 -> Int -> Int -> IO ()
copyPlane :: Display -> Drawable -> Drawable -> GC -> Position -> Position -> Dimension -> Dimension -> Position -> Position -> Pixel -> IO ()
copyPlane gc_arg1 arg2 arg3 arg4 gc_arg2 gc_arg3 arg7 arg8 gc_arg4 gc_arg5 arg11 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg5 ->
  case ( int32ToInt  gc_arg3) of { arg6 ->
  case ( int32ToInt  gc_arg4) of { arg9 ->
  case ( int32ToInt  gc_arg5) of { arg10 ->
  prim_Xlib_copyPlane arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10 arg11}}}}}
primitive prim_Xlib_copyPlane :: Addr -> Word32 -> Word32 -> Addr -> Int -> Int -> Word32 -> Word32 -> Int -> Int -> Word32 -> IO ()

-- draw characters over existing background
drawString :: Display -> Drawable -> GC -> Position -> Position -> String -> IO ()
drawString gc_arg1 arg2 arg3 gc_arg2 gc_arg3 gc_arg4 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  (marshall_stringLen_ gc_arg4) >>= \ (arg6,arg6_size) ->
  prim_Xlib_drawString arg1 arg2 arg3 arg4 arg5 arg6 arg6_size}}}
primitive prim_Xlib_drawString :: Addr -> Word32 -> Addr -> Int -> Int -> Addr -> Int -> IO ()

-- draw characters over a blank rectangle of current background colour
drawImageString :: Display -> Drawable -> GC -> Position -> Position -> String -> IO ()
drawImageString gc_arg1 arg2 arg3 gc_arg2 gc_arg3 gc_arg4 =
  case gc_arg1 of { (Display arg1) ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  case ( int32ToInt  gc_arg3) of { arg5 ->
  (marshall_stringLen_ gc_arg4) >>= \ (arg6,arg6_size) ->
  prim_Xlib_drawImageString arg1 arg2 arg3 arg4 arg5 arg6 arg6_size}}}
primitive prim_Xlib_drawImageString :: Addr -> Word32 -> Addr -> Int -> Int -> Addr -> Int -> IO ()

-- XDrawString16 omitted (16bit chars not supported)
-- XDrawImageString16 omitted (16bit chars not supported)
-- XDrawText omitted (XTextItem not supported)
-- XDrawText16 omitted (XTextItem not supported)

----------------------------------------------------------------
-- Cut and paste buffers
----------------------------------------------------------------

storeBuffer :: Display -> String -> Int -> IO ()
storeBuffer gc_arg1 gc_arg2 arg3 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_stringLen_ gc_arg2) >>= \ (arg2,arg2_size) ->
  prim_Xlib_storeBuffer arg1 arg2 arg2_size arg3 >>= \ (gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
primitive prim_Xlib_storeBuffer :: Addr -> Addr -> Int -> Int -> IO (Int,Addr)

storeBytes :: Display -> String -> IO ()
storeBytes gc_arg1 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_stringLen_ gc_arg2) >>= \ (arg2,arg2_size) ->
  prim_Xlib_storeBytes arg1 arg2 arg2_size >>= \ (gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
primitive prim_Xlib_storeBytes :: Addr -> Addr -> Int -> IO (Int,Addr)

fetchBuffer :: Display -> Int -> IO String
fetchBuffer gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_fetchBuffer arg1 arg2 >>= \ (res1,nbytes,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (unmarshall_stringLen_ res1 nbytes) >>= \ gc_res1 ->
       (return (gc_res1))}
primitive prim_Xlib_fetchBuffer :: Addr -> Int -> IO (Addr,Int,Int,Addr)

fetchBytes :: Display -> IO String
fetchBytes gc_arg1 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_fetchBytes arg1 >>= \ (res1,nbytes,gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (unmarshall_stringLen_ res1 nbytes) >>= \ gc_res1 ->
       (return (gc_res1))}
primitive prim_Xlib_fetchBytes :: Addr -> IO (Addr,Int,Int,Addr)

rotateBuffers :: Display -> Int -> IO ()
rotateBuffers gc_arg1 arg2 =
  case gc_arg1 of { (Display arg1) ->
  prim_Xlib_rotateBuffers arg1 arg2 >>= \ (gc_failed,gc_failstring) ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))}
primitive prim_Xlib_rotateBuffers :: Addr -> Int -> IO (Int,Addr)

----------------------------------------------------------------
-- Atoms
----------------------------------------------------------------

a_PRIMARY :: Atom
a_PRIMARY =
  unsafePerformIO(
    prim_Xlib_a_PRIMARY >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_PRIMARY :: IO (Word32)
a_SECONDARY :: Atom
a_SECONDARY =
  unsafePerformIO(
    prim_Xlib_a_SECONDARY >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_SECONDARY :: IO (Word32)
a_ARC :: Atom
a_ARC =
  unsafePerformIO(
    prim_Xlib_a_ARC >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_ARC :: IO (Word32)
a_ATOM :: Atom
a_ATOM =
  unsafePerformIO(
    prim_Xlib_a_ATOM >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_ATOM :: IO (Word32)
a_BITMAP :: Atom
a_BITMAP =
  unsafePerformIO(
    prim_Xlib_a_BITMAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_BITMAP :: IO (Word32)
a_CARDINAL :: Atom
a_CARDINAL =
  unsafePerformIO(
    prim_Xlib_a_CARDINAL >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CARDINAL :: IO (Word32)
a_COLORMAP :: Atom
a_COLORMAP =
  unsafePerformIO(
    prim_Xlib_a_COLORMAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_COLORMAP :: IO (Word32)
a_CURSOR :: Atom
a_CURSOR =
  unsafePerformIO(
    prim_Xlib_a_CURSOR >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CURSOR :: IO (Word32)
a_CUT_BUFFER0 :: Atom
a_CUT_BUFFER0 =
  unsafePerformIO(
    prim_Xlib_a_CUT_BUFFER0 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CUT_BUFFER0 :: IO (Word32)
a_CUT_BUFFER1 :: Atom
a_CUT_BUFFER1 =
  unsafePerformIO(
    prim_Xlib_a_CUT_BUFFER1 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CUT_BUFFER1 :: IO (Word32)
a_CUT_BUFFER2 :: Atom
a_CUT_BUFFER2 =
  unsafePerformIO(
    prim_Xlib_a_CUT_BUFFER2 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CUT_BUFFER2 :: IO (Word32)
a_CUT_BUFFER3 :: Atom
a_CUT_BUFFER3 =
  unsafePerformIO(
    prim_Xlib_a_CUT_BUFFER3 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CUT_BUFFER3 :: IO (Word32)
a_CUT_BUFFER4 :: Atom
a_CUT_BUFFER4 =
  unsafePerformIO(
    prim_Xlib_a_CUT_BUFFER4 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CUT_BUFFER4 :: IO (Word32)
a_CUT_BUFFER5 :: Atom
a_CUT_BUFFER5 =
  unsafePerformIO(
    prim_Xlib_a_CUT_BUFFER5 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CUT_BUFFER5 :: IO (Word32)
a_CUT_BUFFER6 :: Atom
a_CUT_BUFFER6 =
  unsafePerformIO(
    prim_Xlib_a_CUT_BUFFER6 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CUT_BUFFER6 :: IO (Word32)
a_CUT_BUFFER7 :: Atom
a_CUT_BUFFER7 =
  unsafePerformIO(
    prim_Xlib_a_CUT_BUFFER7 >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CUT_BUFFER7 :: IO (Word32)
a_DRAWABLE :: Atom
a_DRAWABLE =
  unsafePerformIO(
    prim_Xlib_a_DRAWABLE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_DRAWABLE :: IO (Word32)
a_FONT :: Atom
a_FONT =
  unsafePerformIO(
    prim_Xlib_a_FONT >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_FONT :: IO (Word32)
a_INTEGER :: Atom
a_INTEGER =
  unsafePerformIO(
    prim_Xlib_a_INTEGER >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_INTEGER :: IO (Word32)
a_PIXMAP :: Atom
a_PIXMAP =
  unsafePerformIO(
    prim_Xlib_a_PIXMAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_PIXMAP :: IO (Word32)
a_POINT :: Atom
a_POINT =
  unsafePerformIO(
    prim_Xlib_a_POINT >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_POINT :: IO (Word32)
a_RECTANGLE :: Atom
a_RECTANGLE =
  unsafePerformIO(
    prim_Xlib_a_RECTANGLE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RECTANGLE :: IO (Word32)
a_RESOURCE_MANAGER :: Atom
a_RESOURCE_MANAGER =
  unsafePerformIO(
    prim_Xlib_a_RESOURCE_MANAGER >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RESOURCE_MANAGER :: IO (Word32)
a_RGB_COLOR_MAP :: Atom
a_RGB_COLOR_MAP =
  unsafePerformIO(
    prim_Xlib_a_RGB_COLOR_MAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RGB_COLOR_MAP :: IO (Word32)
a_RGB_BEST_MAP :: Atom
a_RGB_BEST_MAP =
  unsafePerformIO(
    prim_Xlib_a_RGB_BEST_MAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RGB_BEST_MAP :: IO (Word32)
a_RGB_BLUE_MAP :: Atom
a_RGB_BLUE_MAP =
  unsafePerformIO(
    prim_Xlib_a_RGB_BLUE_MAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RGB_BLUE_MAP :: IO (Word32)
a_RGB_DEFAULT_MAP :: Atom
a_RGB_DEFAULT_MAP =
  unsafePerformIO(
    prim_Xlib_a_RGB_DEFAULT_MAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RGB_DEFAULT_MAP :: IO (Word32)
a_RGB_GRAY_MAP :: Atom
a_RGB_GRAY_MAP =
  unsafePerformIO(
    prim_Xlib_a_RGB_GRAY_MAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RGB_GRAY_MAP :: IO (Word32)
a_RGB_GREEN_MAP :: Atom
a_RGB_GREEN_MAP =
  unsafePerformIO(
    prim_Xlib_a_RGB_GREEN_MAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RGB_GREEN_MAP :: IO (Word32)
a_RGB_RED_MAP :: Atom
a_RGB_RED_MAP =
  unsafePerformIO(
    prim_Xlib_a_RGB_RED_MAP >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RGB_RED_MAP :: IO (Word32)
a_STRING :: Atom
a_STRING =
  unsafePerformIO(
    prim_Xlib_a_STRING >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_STRING :: IO (Word32)
a_VISUALID :: Atom
a_VISUALID =
  unsafePerformIO(
    prim_Xlib_a_VISUALID >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_VISUALID :: IO (Word32)
a_WINDOW :: Atom
a_WINDOW =
  unsafePerformIO(
    prim_Xlib_a_WINDOW >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WINDOW :: IO (Word32)
a_WM_COMMAND :: Atom
a_WM_COMMAND =
  unsafePerformIO(
    prim_Xlib_a_WM_COMMAND >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_COMMAND :: IO (Word32)
a_WM_HINTS :: Atom
a_WM_HINTS =
  unsafePerformIO(
    prim_Xlib_a_WM_HINTS >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_HINTS :: IO (Word32)
a_WM_CLIENT_MACHINE :: Atom
a_WM_CLIENT_MACHINE =
  unsafePerformIO(
    prim_Xlib_a_WM_CLIENT_MACHINE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_CLIENT_MACHINE :: IO (Word32)
a_WM_ICON_NAME :: Atom
a_WM_ICON_NAME =
  unsafePerformIO(
    prim_Xlib_a_WM_ICON_NAME >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_ICON_NAME :: IO (Word32)
a_WM_ICON_SIZE :: Atom
a_WM_ICON_SIZE =
  unsafePerformIO(
    prim_Xlib_a_WM_ICON_SIZE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_ICON_SIZE :: IO (Word32)
a_WM_NAME :: Atom
a_WM_NAME =
  unsafePerformIO(
    prim_Xlib_a_WM_NAME >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_NAME :: IO (Word32)
a_WM_NORMAL_HINTS :: Atom
a_WM_NORMAL_HINTS =
  unsafePerformIO(
    prim_Xlib_a_WM_NORMAL_HINTS >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_NORMAL_HINTS :: IO (Word32)
a_WM_SIZE_HINTS :: Atom
a_WM_SIZE_HINTS =
  unsafePerformIO(
    prim_Xlib_a_WM_SIZE_HINTS >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_SIZE_HINTS :: IO (Word32)
a_WM_ZOOM_HINTS :: Atom
a_WM_ZOOM_HINTS =
  unsafePerformIO(
    prim_Xlib_a_WM_ZOOM_HINTS >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_ZOOM_HINTS :: IO (Word32)
a_MIN_SPACE :: Atom
a_MIN_SPACE =
  unsafePerformIO(
    prim_Xlib_a_MIN_SPACE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_MIN_SPACE :: IO (Word32)
a_NORM_SPACE :: Atom
a_NORM_SPACE =
  unsafePerformIO(
    prim_Xlib_a_NORM_SPACE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_NORM_SPACE :: IO (Word32)
a_MAX_SPACE :: Atom
a_MAX_SPACE =
  unsafePerformIO(
    prim_Xlib_a_MAX_SPACE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_MAX_SPACE :: IO (Word32)
a_END_SPACE :: Atom
a_END_SPACE =
  unsafePerformIO(
    prim_Xlib_a_END_SPACE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_END_SPACE :: IO (Word32)
a_SUPERSCRIPT_X :: Atom
a_SUPERSCRIPT_X =
  unsafePerformIO(
    prim_Xlib_a_SUPERSCRIPT_X >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_SUPERSCRIPT_X :: IO (Word32)
a_SUPERSCRIPT_Y :: Atom
a_SUPERSCRIPT_Y =
  unsafePerformIO(
    prim_Xlib_a_SUPERSCRIPT_Y >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_SUPERSCRIPT_Y :: IO (Word32)
a_SUBSCRIPT_X :: Atom
a_SUBSCRIPT_X =
  unsafePerformIO(
    prim_Xlib_a_SUBSCRIPT_X >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_SUBSCRIPT_X :: IO (Word32)
a_SUBSCRIPT_Y :: Atom
a_SUBSCRIPT_Y =
  unsafePerformIO(
    prim_Xlib_a_SUBSCRIPT_Y >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_SUBSCRIPT_Y :: IO (Word32)
a_UNDERLINE_POSITION :: Atom
a_UNDERLINE_POSITION =
  unsafePerformIO(
    prim_Xlib_a_UNDERLINE_POSITION >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_UNDERLINE_POSITION :: IO (Word32)
a_UNDERLINE_THICKNESS :: Atom
a_UNDERLINE_THICKNESS =
  unsafePerformIO(
    prim_Xlib_a_UNDERLINE_THICKNESS >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_UNDERLINE_THICKNESS :: IO (Word32)
a_STRIKEOUT_ASCENT :: Atom
a_STRIKEOUT_ASCENT =
  unsafePerformIO(
    prim_Xlib_a_STRIKEOUT_ASCENT >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_STRIKEOUT_ASCENT :: IO (Word32)
a_STRIKEOUT_DESCENT :: Atom
a_STRIKEOUT_DESCENT =
  unsafePerformIO(
    prim_Xlib_a_STRIKEOUT_DESCENT >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_STRIKEOUT_DESCENT :: IO (Word32)
a_ITALIC_ANGLE :: Atom
a_ITALIC_ANGLE =
  unsafePerformIO(
    prim_Xlib_a_ITALIC_ANGLE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_ITALIC_ANGLE :: IO (Word32)
a_X_HEIGHT :: Atom
a_X_HEIGHT =
  unsafePerformIO(
    prim_Xlib_a_X_HEIGHT >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_X_HEIGHT :: IO (Word32)
a_QUAD_WIDTH :: Atom
a_QUAD_WIDTH =
  unsafePerformIO(
    prim_Xlib_a_QUAD_WIDTH >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_QUAD_WIDTH :: IO (Word32)
a_WEIGHT :: Atom
a_WEIGHT =
  unsafePerformIO(
    prim_Xlib_a_WEIGHT >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WEIGHT :: IO (Word32)
a_POINT_SIZE :: Atom
a_POINT_SIZE =
  unsafePerformIO(
    prim_Xlib_a_POINT_SIZE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_POINT_SIZE :: IO (Word32)
a_RESOLUTION :: Atom
a_RESOLUTION =
  unsafePerformIO(
    prim_Xlib_a_RESOLUTION >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_RESOLUTION :: IO (Word32)
a_COPYRIGHT :: Atom
a_COPYRIGHT =
  unsafePerformIO(
    prim_Xlib_a_COPYRIGHT >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_COPYRIGHT :: IO (Word32)
a_NOTICE :: Atom
a_NOTICE =
  unsafePerformIO(
    prim_Xlib_a_NOTICE >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_NOTICE :: IO (Word32)
a_FONT_NAME :: Atom
a_FONT_NAME =
  unsafePerformIO(
    prim_Xlib_a_FONT_NAME >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_FONT_NAME :: IO (Word32)
a_FAMILY_NAME :: Atom
a_FAMILY_NAME =
  unsafePerformIO(
    prim_Xlib_a_FAMILY_NAME >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_FAMILY_NAME :: IO (Word32)
a_FULL_NAME :: Atom
a_FULL_NAME =
  unsafePerformIO(
    prim_Xlib_a_FULL_NAME >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_FULL_NAME :: IO (Word32)
a_CAP_HEIGHT :: Atom
a_CAP_HEIGHT =
  unsafePerformIO(
    prim_Xlib_a_CAP_HEIGHT >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_CAP_HEIGHT :: IO (Word32)
a_WM_CLASS :: Atom
a_WM_CLASS =
  unsafePerformIO(
    prim_Xlib_a_WM_CLASS >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_CLASS :: IO (Word32)
a_WM_TRANSIENT_FOR :: Atom
a_WM_TRANSIENT_FOR =
  unsafePerformIO(
    prim_Xlib_a_WM_TRANSIENT_FOR >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_WM_TRANSIENT_FOR :: IO (Word32)
a_LAST_PREDEFINED :: Atom
a_LAST_PREDEFINED =
  unsafePerformIO(
    prim_Xlib_a_LAST_PREDEFINED >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_a_LAST_PREDEFINED :: IO (Word32)

----------------------------------------------------------------
-- Window properties
----------------------------------------------------------------

setTextProperty :: Display -> Window -> String -> Atom -> IO ()
setTextProperty gc_arg1 arg2 gc_arg2 arg4 =
  case gc_arg1 of { (Display arg1) ->
  (marshall_stringLen_ gc_arg2) >>= \ (arg3,arg3_size) ->
  prim_Xlib_setTextProperty arg1 arg2 arg3 arg3_size arg4}
primitive prim_Xlib_setTextProperty :: Addr -> Word32 -> Addr -> Int -> Word32 -> IO ()

-- %fun XSetStandardProperties :: Display -> Window -> String -> String -> Pixmap -> [String] -> XSizeHints -> IO ()
-- %code Status err = XSetStandardProperties(arg1,arg2,arg3,arg4,arg5,arg6,arg6_size,&arg7)
-- %fail { Success != err }{ BadStatus(err,XSetStandardProperties) }

----------------------------------------------------------------
-- Regions
----------------------------------------------------------------

type RectInRegionResult = Int

-- Return values from XRectInRegion()
rectangleOut :: RectInRegionResult
rectangleOut =
  unsafePerformIO(
    prim_Xlib_rectangleOut >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_rectangleOut :: IO (Int)
rectangleIn :: RectInRegionResult
rectangleIn =
  unsafePerformIO(
    prim_Xlib_rectangleIn >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_rectangleIn :: IO (Int)
rectanglePart :: RectInRegionResult
rectanglePart =
  unsafePerformIO(
    prim_Xlib_rectanglePart >>= \ (res1) ->
    (return (res1)))
primitive prim_Xlib_rectanglePart :: IO (Int)
 
-- regions deallocation is handled by the GC (ForeignObj magic)
-- so we don't provide XDestroyRegion explicitly
-- no idea what the int is for
-- %fun XDestroyRegion :: Region -> IO Int

----------------------------------------------------------------
-- Creating regions
----------------------------------------------------------------

-- an empty region 
-- (often used as "out argument" to binary operators which return regions)
createRegion :: IO Region
createRegion =
  prim_Xlib_createRegion >>= \ (gc_res3,gc_res1) ->
  (makeForeignObjPrim gc_res1 gc_res3) >>= \ gc_res2 ->
  (return ((Region gc_res2)))
primitive prim_Xlib_createRegion :: IO (Addr,Addr)

polygonRegion :: ListPoint -> FillRule -> IO Region
polygonRegion gc_arg1 arg3 =
  (marshallAddrList allocPoints writePoint gc_arg1) >>= \ (arg1,arg2) ->
  prim_Xlib_polygonRegion arg1 arg2 arg3 >>= \ (gc_res3,gc_res1) ->
  (makeForeignObjPrim gc_res1 gc_res3) >>= \ gc_res2 ->
  (return ((Region gc_res2)))
primitive prim_Xlib_polygonRegion :: Addr -> Int -> Int -> IO (Addr,Addr)

----------------------------------------------------------------
-- Combining Regions
--
-- The usual shoddy state of Xlib documentation fails to mention
-- what the Int is for.
--
-- All operations overwrite the region in their third argument
-- which is usually a freshly created region.
----------------------------------------------------------------

intersectRegion :: Region -> Region -> Region -> IO Int
intersectRegion gc_arg1 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Region arg1) ->
  case gc_arg2 of { (Region arg2) ->
  case gc_arg3 of { (Region arg3) ->
  prim_Xlib_intersectRegion arg1 arg2 arg3 >>= \ (res1) ->
  (return (res1))}}}
primitive prim_Xlib_intersectRegion :: ForeignObj -> ForeignObj -> ForeignObj -> IO (Int)
subtractRegion :: Region -> Region -> Region -> IO Int
subtractRegion gc_arg1 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Region arg1) ->
  case gc_arg2 of { (Region arg2) ->
  case gc_arg3 of { (Region arg3) ->
  prim_Xlib_subtractRegion arg1 arg2 arg3 >>= \ (res1) ->
  (return (res1))}}}
primitive prim_Xlib_subtractRegion :: ForeignObj -> ForeignObj -> ForeignObj -> IO (Int)
unionRectWithRegion :: Rectangle -> Region -> Region -> IO Int
unionRectWithRegion gc_arg1 gc_arg9 gc_arg10 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg7) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  case gc_arg9 of { (Region arg2) ->
  case gc_arg10 of { (Region arg3) ->
  prim_Xlib_unionRectWithRegion gc_arg3 gc_arg5 gc_arg6 gc_arg7 arg2 arg3 >>= \ (res1) ->
  (return (res1))}}}}}
primitive prim_Xlib_unionRectWithRegion :: Int -> Int -> Word32 -> Word32 -> ForeignObj -> ForeignObj -> IO (Int)
unionRegion :: Region -> Region -> Region -> IO Int
unionRegion gc_arg1 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Region arg1) ->
  case gc_arg2 of { (Region arg2) ->
  case gc_arg3 of { (Region arg3) ->
  prim_Xlib_unionRegion arg1 arg2 arg3 >>= \ (res1) ->
  (return (res1))}}}
primitive prim_Xlib_unionRegion :: ForeignObj -> ForeignObj -> ForeignObj -> IO (Int)
xorRegion :: Region -> Region -> Region -> IO Int
xorRegion gc_arg1 gc_arg2 gc_arg3 =
  case gc_arg1 of { (Region arg1) ->
  case gc_arg2 of { (Region arg2) ->
  case gc_arg3 of { (Region arg3) ->
  prim_Xlib_xorRegion arg1 arg2 arg3 >>= \ (res1) ->
  (return (res1))}}}
primitive prim_Xlib_xorRegion :: ForeignObj -> ForeignObj -> ForeignObj -> IO (Int)

----------------------------------------------------------------
-- Examining regions (tests, bounding boxes, etc)
----------------------------------------------------------------

emptyRegion :: Region -> IO Bool
emptyRegion gc_arg1 =
  case gc_arg1 of { (Region arg1) ->
  prim_Xlib_emptyRegion arg1 >>= \ (res1) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))}
primitive prim_Xlib_emptyRegion :: ForeignObj -> IO (Int)
equalRegion :: Region -> Region -> IO Bool
equalRegion gc_arg1 gc_arg2 =
  case gc_arg1 of { (Region arg1) ->
  case gc_arg2 of { (Region arg2) ->
  prim_Xlib_equalRegion arg1 arg2 >>= \ (res1) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))}}
primitive prim_Xlib_equalRegion :: ForeignObj -> ForeignObj -> IO (Int)
pointInRegion :: Region -> Point -> IO Bool
pointInRegion gc_arg1 gc_arg2 =
  case gc_arg1 of { (Region arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg5) ->
  case ( int32ToInt  gc_arg3) of { gc_arg4 ->
  case ( int32ToInt  gc_arg5) of { gc_arg6 ->
  prim_Xlib_pointInRegion arg1 gc_arg4 gc_arg6 >>= \ (res1) ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))}}}}
primitive prim_Xlib_pointInRegion :: ForeignObj -> Int -> Int -> IO (Int)
rectInRegion :: Region -> Rectangle -> IO RectInRegionResult
rectInRegion gc_arg1 gc_arg2 =
  case gc_arg1 of { (Region arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg5,gc_arg7,gc_arg8) ->
  case ( int32ToInt  gc_arg3) of { gc_arg4 ->
  case ( int32ToInt  gc_arg5) of { gc_arg6 ->
  prim_Xlib_rectInRegion arg1 gc_arg4 gc_arg6 gc_arg7 gc_arg8 >>= \ (res1) ->
  (return (res1))}}}}
primitive prim_Xlib_rectInRegion :: ForeignObj -> Int -> Int -> Word32 -> Word32 -> IO (Int)

-- I have no idea what the int is for
clipBox :: Region -> IO (Rectangle,Int)
clipBox gc_arg1 =
  case gc_arg1 of { (Region arg1) ->
  prim_Xlib_clipBox arg1 >>= \ (gc_res2,gc_res4,gc_res5,gc_res6,res2) ->
  let gc_res1 = ( intToInt32  (gc_res2)) in
  let gc_res3 = ( intToInt32  (gc_res4)) in
  (return (((gc_res1,gc_res3,gc_res5,gc_res6),res2)))}
primitive prim_Xlib_clipBox :: ForeignObj -> IO (Int,Int,Word32,Word32,Int)

----------------------------------------------------------------
-- Modifying regions
-- (If you use any of these, you can't make regions look like
--  first class data structures.)
----------------------------------------------------------------

-- translate region
offsetRegion :: Region -> Point -> IO Int
offsetRegion gc_arg1 gc_arg2 =
  case gc_arg1 of { (Region arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg5) ->
  case ( int32ToInt  gc_arg3) of { gc_arg4 ->
  case ( int32ToInt  gc_arg5) of { gc_arg6 ->
  prim_Xlib_offsetRegion arg1 gc_arg4 gc_arg6 >>= \ (res1) ->
  (return (res1))}}}}
primitive prim_Xlib_offsetRegion :: ForeignObj -> Int -> Int -> IO (Int)

-- increase size of region by +ve or -ve number of pixels
-- while preserving the centre of the region (ie half the pixels
-- come off the left, and half off the right)
shrinkRegion :: Region -> Point -> IO Int
shrinkRegion gc_arg1 gc_arg2 =
  case gc_arg1 of { (Region arg1) ->
  case gc_arg2 of { (gc_arg3,gc_arg5) ->
  case ( int32ToInt  gc_arg3) of { gc_arg4 ->
  case ( int32ToInt  gc_arg5) of { gc_arg6 ->
  prim_Xlib_shrinkRegion arg1 gc_arg4 gc_arg6 >>= \ (res1) ->
  (return (res1))}}}}
primitive prim_Xlib_shrinkRegion :: ForeignObj -> Int -> Int -> IO (Int)

----------------------------------------------------------------
-- Graphics Context
----------------------------------------------------------------

-- set clip mask of GC
setRegion :: Display -> GC -> Region -> IO Int
setRegion gc_arg1 arg2 gc_arg2 =
  case gc_arg1 of { (Display arg1) ->
  case gc_arg2 of { (Region arg3) ->
  prim_Xlib_setRegion arg1 arg2 arg3 >>= \ (res1) ->
  (return (res1))}}
primitive prim_Xlib_setRegion :: Addr -> Addr -> ForeignObj -> IO (Int)

----------------------------------------------------------------
-- End
----------------------------------------------------------------
needPrims_hugs 3
