/*
 * Copyright (c) 1991, 1992 Fujitsu Oita Software Laboratory Limited
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice and this permission notice appear in
 * all copies of the software and related documentation, and the name of
 * Fujitsu Oita Software Laboratory may not be used in any advertising or
 * publicity relating to the software without specific, prior written
 * prior permission of Fujitsu Oita Software Laboratory. 
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL FUJITSU OITA SOFTWARE LABORATORY BE LIABLE FOR ANY
 * SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY
 * OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Toshihisa Eto, Fujitsu Oita Software Laboratory Limited, Japan
 * 	E-Mail: eto@ai.cs.fujitsu.co.jp
 * 	Nifty:	HBG02665
 */

#ifdef JIV

class KinputRep;
class Window;
class Font;

class Kinput {
  public:
    // Instance handling method
    Kinput(Window*);
    ~Kinput();

    // method for communicate with kinput
    void BeginConversion();
    void BeginConversion(int, int);
    void EndConversion();

    // method for kinput event handling
    boolean IsKinputEvent(const Event& ev);
    boolean Handle(Event& ev);

    // get result string
    const char* GetConvertedString();

    // set property for over-the-spot conversion (not implemented yet)
    void	SetFont(Font*);
    void	SetColor(const char*);
    void	SetConversionSpot(int, int);


    // Public method for search current status
    boolean IsActive();

  private:
    KinputRep*	rep;
};

#endif	/* JIV */
