#!/usr/bin/env python
#  example of using piddle with the PDF backend
#  replace piddlePDF and PDFCanvas with whichever backend you wish to use
#  for exaple, to use PIL instead of PDF, you would use
#  from piddlePIL import *
#  canvas = PILCanvas(...)

from piddlePDF import *          # change these to whatever

canvas = PDFCanvas(size=(300,300),    # size=(width,height) in units of 1/72 of an inch
                   name="example-basics.pdf" # name of file that holds the PDF document
                   )


## stuff below this line is independent of which backend canvas you are using
#----------------------------------------------------------------------------


# first draw a grid of lines in light blue

canvas.defaultLineColor = Color(0.7,0.7,1.0)    # (light blue)
canvas.drawLines( map(lambda i:(i*10,0,i*10,300), range(30)) )
canvas.drawLines( map(lambda i:(0,i*10,300,i*10), range(30)) )


canvas.defaultLineColor = black 

# draw a line
canvas.drawLine(10,200, 20,190, color=red)


# examples of using each of the drawing primitives
canvas.drawEllipse( 130,30, 200,100, fillColor=yellow, edgeWidth=4 )

canvas.drawArc( 130,30, 200,100, 45,50, fillColor=blue, edgeColor=navy, edgeWidth=4 )

canvas.defaultLineWidth = 4
canvas.drawRoundRect( 30,30, 100,100, fillColor=blue, edgeColor=maroon )

canvas.drawCurve( 20,20, 100,50, 50,100, 160,160 )

canvas.drawString("This is a test!", 30,130, Font(face="times",size=16,bold=1),
                                             color=green, angle=-45)

polypoints = [ (160,120), (130,190), (210,145), (110,145), (190,190) ]

canvas.drawPolygon(polypoints, fillColor=lime, edgeColor=red, edgeWidth=3, closed=1)

canvas.drawRect( 200,200,260,260, edgeColor=yellow, edgeWidth=5 )
# draw some colored lines over two sides of the rectangle drawn just above
canvas.drawLine( 200,260,260,260, color=green, width=5 )
canvas.drawLine( 260,200,260,260, color=red, width=5 )

canvas.flush()  # required to signal piddle to send drawing commands to output device
print "saving output to example-basics.pdf"
