'''\
a demo of a piddleWxDc.py
piddleWxDcDemo.py
by Jeffrey Kunce

This demo app is based on the wxPython ScrolledWindow.py demo.

'''

from wxPython.wx import *
import piddle
from piddleWxDc import PiddleWxDc

class PiddleWXDemoCanvas(wxScrolledWindow):
	'''based on wxPython ScrolledWindow.py demo'''

	def __init__(self, parent, id = -1, size = wxDefaultSize):
 		wxScrolledWindow.__init__(self, parent, id, wxPoint(0, 0), size, wxSUNKEN_BORDER)

		self.lines = []
		self.maxWidth  = 1000
		self.maxHeight = 1000

		self.SetBackgroundColour(wxNamedColor("WHITE"))
		self.Connect(-1, -1, wxEVT_LEFT_DOWN, self.OnLeftButtonEvent)
		self.Connect(-1, -1, wxEVT_LEFT_UP,   self.OnLeftButtonEvent)
		self.Connect(-1, -1, wxEVT_MOTION,	self.OnLeftButtonEvent)

		self.SetCursor(wxStockCursor(wxCURSOR_PENCIL))
		self.im = None
                try:
                        import Image
			self.im = Image.open('test2.bmp')  #also works:'image.jpg'
		except: pass

		self.SetScrollbars(20, 20, self.maxWidth/20, self.maxHeight/20)

	def getWidth(self):
		return self.maxWidth

	def getHeight(self):
		return self.maxHeight

	def OnPaint(self, event):
		dc = wxPaintDC(self)
		self.PrepareDC(dc)
		self.DoDrawing(dc)


	def DoDrawing(self, dc):
		pdc = PiddleWxDc(dc)

		pdc.drawRect(5, 5, 50, 50, edgeColor=piddle.red)

		pdc.drawRect(15, 15, 50, 50, edgeColor=piddle.blue, edgeWidth=4, fillColor=piddle.lightgrey)

		s = "Hello World"
		pFont = piddle.Font(face="swiss",size=14)
		tew = pdc.stringWidth(s, font=pFont)
		teh = pdc.fontHeight(font=pFont)
		pdc.drawString("Hello World", 60, 65, pFont, piddle.Color(0xFF, 0x20, 0xFF))

		pdc.drawLine(60, 65+4, 60+tew, 65+4, color=piddle.violet, width=4)

		lst1 = [(100,110), (150,110), (150,160), (100,160)]
		lst2 = []
		lst3 = []
		for i1 in range(len(lst1)):
			x1, y1 = lst1[i1]
			lst3.append((x1+75,y1))
			try: x2, y2 = lst1[i1+1]
			except IndexError: pass
			else: lst2.append((x1-60,y1,x2-60,y2))
		pdc.drawLines(lst2, color=piddle.violet, width=4)
		pdc.drawPolygon(lst3, edgeColor=piddle.black, fillColor=piddle.grey, closed=1)

		#not implemented in piddle: dc.DrawSpline(lst+[(100,100)])

		if (self.im):
			pdc.drawImage(self.im, 200, 20)		#resize works if desired: , 300, 120)
			pdc.drawString("a bitmap", 200, 85+pdc.fontHeight(), color=piddle.Color(0, 0xFF, 0x80))

		#draw saved lines
		for lines in self.lines:
			pdc.drawLines(lines, color=piddle.darkolivegreen, width=4)


	def SetXY(self, event):
		self.x, self.y = self.ConvertEventCoords(event)

	def ConvertEventCoords(self, event):
		xView, yView = self.ViewStart()
		xDelta, yDelta = self.GetScrollPixelsPerUnit()
		return (event.GetX() + (xView * xDelta),
				event.GetY() + (yView * yDelta))

	def OnLeftButtonEvent(self, event):
		if event.LeftDown():
			self.SetXY(event)
			self.curLine = []

		elif event.Dragging():
			dc = wxClientDC(self)
			self.PrepareDC(dc)
			pdc = PiddleWxDc(dc)
			nextX, nextY = self.ConvertEventCoords(event)
			coords = (self.x, self.y, nextX, nextY)
			self.curLine.append(coords)
			pdc.drawLine(self.x, self.y, nextX, nextY, color=piddle.darkolivegreen, width=4)
			self.SetXY(event)

		elif event.LeftUp():
			self.lines.append(self.curLine)
			self.curLine = []
			
			
class PiddleWXDemoFrame(wxFrame):
	def __init__(self, parent, id, title):
		wxFrame.__init__(self, parent, -1, title, size = (725, 550))
		self.Centre(wxBOTH)
		self.window = PiddleWXDemoCanvas(self, id = -1, size = wxDefaultSize)

class PiddleWXDemoApp(wxApp):

	def OnInit(self):
 		wxImage_AddHandler(wxJPEGHandler())
		wxImage_AddHandler(wxPNGHandler())
		wxImage_AddHandler(wxGIFHandler())
		frame = PiddleWXDemoFrame(NULL, -1, "piddleWX: (A Demonstration)")
		frame.Show(true)
		self.SetTopWindow(frame)
		return true



if __name__ == '__main__':
	app = PiddleWXDemoApp(0)
	app.MainLoop()
