/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_STEREO_CAMERA_H
#define RAYPP_STEREO_CAMERA_H

#include "kernel/kernel.h"

namespace RAYPP {

class STEREO_CAMERA: public CAMERA
  {
  private:
    INSIDE_INFO MyVol1, MyVol2;
    VECTOR Location, Sky, LookAt;
    float8 u_fov, v_fov;
    float8 Aspect_Ratio;
    float8 EyeSep;
    VECTOR Loc1, Loc2, Dir1, Dir2, Right1, Right2, Up;

  public:
    STEREO_CAMERA ();
    STEREO_CAMERA (const VECTOR &Loc, const VECTOR &Look, float8 Eye);

    virtual void Init ();

    virtual void Transform (const TRANSFORM &trans);

    virtual COLOUR Calc_Intensity (float8 u, float8 v) const;

    void Set_Sky (const VECTOR & new_sky);
    void Set_Location (const VECTOR &new_loc);
    void Set_LookAt (const VECTOR &new_look);
    void Set_Fov (float8 new_ufov, float8 new_vfov);
    void Set_Fov (float8 new_ufov);
    void Set_Aspect_Ratio (float8 new_AR);
    void Set_EyeSep (float8 new_EyeSep);
  };

} // namespace RAYPP

#endif
