/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_CONFIG_H
#define RAYPP_CONFIG_H

#ifdef _MSC_VER
namespace std {
#include <math.h>
}
#else
#include <cmath>
#endif

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <algorithm>
#include <queue>
#include <utility>
#include <map>
//#include <sstream>

namespace RAYPP {

using namespace ::std;

#ifdef _MSC_VER
template<class T> T    min (const T &x,const T &y) { return (x<y ? x : y);   } 
template<class T> T    max (const T &x,const T &y) { return (x>y ? x : y);   } 
template<class T> T    abs (const T& v)            { return (v>0 ? v : -v ); }
template<class T> void swap(T &x,T &y) { T tmp = x; x = y; y = tmp; } 
#endif

} // namespace RAYPP

#ifdef _MSC_VER
#  define INT2 short
#  define INT4 int
#  define FLOAT4 float
#  define FLOAT8 double
#  define BIGENDIAN 0
#else
#  include "config/sizecalc.h"
#endif

/** The namespace enclosing the whole Ray++ library
 */
namespace RAYPP {

/// floating point type (min.  4 bytes, IEEE754 single)
typedef FLOAT4 float4;
/// floating point type (min.  8 bytes, IEEE754 double)
typedef FLOAT8 float8;

/// unsigned byte type (exactly 1 byte)
typedef unsigned char byte;

/// unsigned integer type (min. 1 byte)
typedef unsigned char uint1;
///   signed integer type (min. 1 byte)
typedef signed char int1;
///   unsigned integer type (min. 2 bytes)
typedef unsigned INT2 uint2;
///   signed integer type (min. 2 bytes)
typedef signed INT2 int2;
///   unsigned integer type (min. 4 bytes)
typedef unsigned INT4 uint4;
///   signed integer type (min. 4 bytes)
typedef signed INT4 int4;

#if (BIGENDIAN==1)
  const bool big_endian=true;
#else
  const bool big_endian=false;
#endif

} // namespace RAYPP

#undef FLOAT4
#undef FLOAT8
#undef FLOAT12
#undef INT2
#undef INT4
#undef INT8
#undef BIGENDIAN

#endif
