// macro magic to determine integer and floating point types of a given size
// this file may only be included by config.h - nowhere else!

#define SIZEOF_SHORT_INT     0
#define SIZEOF_INT           0
#define SIZEOF_LONG_INT      0
#define SIZEOF_FLOAT         0
#define SIZEOF_DOUBLE        0
#define SIZEOF_LONG_DOUBLE   0

#define BIGENDIAN            1

#if SIZEOF_SHORT_INT >= 2
#  define INT2 short int
#elif SIZEOF_INT >= 2
#  define INT2 int
#elif SIZEOF_LONG_INT >= 2
#  define INT2 long int
#elif SIZEOF_LONG_LONG_INT >= 2
#  define INT2 long long int
#else
#  error "no 2 byte integer type available"
#endif

#if SIZEOF_SHORT_INT >= 4
#  define INT4 short int
#elif SIZEOF_INT >= 4
#  define INT4 int
#elif SIZEOF_LONG_INT >= 4
#  define INT4 long int
#elif SIZEOF_LONG_LONG_INT >= 4
#  define INT4 long long int
#else
#  error "no 4 byte integer type available"
#endif

#if SIZEOF_FLOAT >= 4
#  define FLOAT4 float
#elif SIZEOF_DOUBLE >= 4
#  define FLOAT4 double
#elif SIZEOF_LONG_DOUBLE >= 4
#  define FLOAT4 long double
#else
#  error "no 4 byte floating point type available"
#endif

#if SIZEOF_FLOAT >= 8
#  define FLOAT8 float
#elif SIZEOF_DOUBLE >= 8
#  define FLOAT8 double
#elif SIZEOF_LONG_DOUBLE >= 8
#  define FLOAT8 long double
#else
#  error "no 8 byte floating point type available"
#endif

#undef SIZEOF_SHORT_INT
#undef SIZEOF_INT
#undef SIZEOF_LONG_INT
#undef SIZEOF_FLOAT
#undef SIZEOF_DOUBLE
#undef SIZEOF_LONG_DOUBLE
