/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_KERNEL_H
#define RAYPP_KERNEL_H

#include "kernel/axisbox.h"
#include "kernel/camera.h"
#include "kernel/colour.h"
#include "kernel/constants.h"
#include "kernel/error.h"
#include "kernel/full_shading_info.h"
#include "kernel/geom_ray.h"
#include "kernel/globals.h"
#include "kernel/handle.h"
#include "kernel/initable.h"
#include "kernel/inside_info.h"
#include "kernel/intersect_info.h"
#include "kernel/interval.h"
#include "kernel/light.h"
#include "kernel/light_array.h"
#include "kernel/msg_stream.h"
#include "kernel/object.h"
#include "kernel/object_queue.h"
#include "kernel/output.h"
#include "kernel/ray.h"
#include "kernel/renderer.h"
#include "kernel/shading_info.h"
#include "kernel/shape.h"
#include "kernel/surface.h"
#include "kernel/transform.h"
#include "kernel/transformable.h"
#include "kernel/vector.h"
#include "kernel/volume.h"
#include "kernel/world.h"

#endif
