/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_AMBIENT_LIGHT_H
#define RAYPP_AMBIENT_LIGHT_H

#include "kernel/kernel.h"

namespace RAYPP {

class AMBIENT_LIGHT: public LIGHT
  {
  private:
    COLOUR Colour;

  public:
    AMBIENT_LIGHT () : Colour (float4(0.2),float4(0.2),float4(0.2)) {}
    AMBIENT_LIGHT (const COLOUR &Col) : Colour (Col) {}

    virtual void Transform (const TRANSFORM &) {}

    virtual void Cast_Light (const VECTOR &, LIGHT_ARRAY &Arr) const
      { Arr.Ambient += Colour; }

    void Set_Colour (const COLOUR &Col)
      {
      cni();
      Colour = Col;
      }
  };

} // namespace RAYPP

#endif
