/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_POINTLIGHT_H
#define RAYPP_POINTLIGHT_H

#include "kernel/kernel.h"

namespace RAYPP {

class POINTLIGHT: public LIGHT
  {
  private:
    INSIDE_INFO MyVolume;
    VECTOR Location;
    COLOUR Colour;

  public:
    POINTLIGHT ();
    POINTLIGHT (const VECTOR &Loc, const COLOUR &Col);

    virtual void Init ();

    virtual void Transform (const TRANSFORM &trans);

    virtual void Cast_Light (const VECTOR &Pos, LIGHT_ARRAY &Arr) const;

    void Set_Colour (const COLOUR &new_col);
    void Set_Location (const VECTOR &new_loc);
  };

} // namespace RAYPP

#endif
