/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_BOUNDING_SLAB_H
#define RAYPP_BOUNDING_SLAB_H

#include "kernel/kernel.h"

namespace RAYPP {

class BOUNDING_SLAB: public OBJECT
  {
  private:
    vector<HANDLE<OBJECT> > Object;
    AXISBOX Bounder;
    bool Contains_Volume, V_in_BBox;

  public:
    virtual void Init ();
    virtual void Deinit ();

    virtual void Transform (const TRANSFORM &trans);

    virtual AXISBOX BBox () const
      { return Bounder; }

    virtual bool Has_Volume () const;
    virtual bool Volume_in_BBox () const;

    virtual bool Test
      (RAY &Ray, float8 &dist) const;

    virtual bool Inside_Volume (const VECTOR &Loc,
      const INSIDE_INFO &nowInside, INSIDE_INFO &result) const;
    virtual bool Intersect
      (RAY &Ray, OBJECT_QUEUE &Queue, INTERSECT_INFO &) const;

    void Add (const HANDLE<OBJECT> &new_obj);
  };

} // namespace RAYPP

#endif
