/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

/*
    AUTHOR:
        Dair Grant <mailto:dair@webthing.net>
*/

#ifndef RAYPP_MEM_OUTPUT_H
#define RAYPP_MEM_OUTPUT_H

#include "kernel/kernel.h"

namespace RAYPP {

typedef bool (*OutputFilterFunc)(uint4 filterRefCon, uint4 scanY,
              uint4 scanWidth, COLOUR *theScan);


class MEM_OUTPUT: public OUTPUT
  {
  private:
    uint4               mWidth, mHeight;
    OutputFilterFunc    mFilter;
    uint4               mFilterRefCon;
    void                *mBaseAddr;
    uint4               mRowBytes, mPixelBytes;
    uint4               mShiftRed, mShiftGreen, mShiftBlue;
    uint4               mMaskRed, mMaskGreen, mMaskBlue;
    uint4               mScaleRed, mScaleGreen, mScaleBlue;

    void UpdateScale();
    void DrawScan(uint4 scanY, COLOUR *theScan) const;

  public:
//    class OutputFilter
//      {
//      public:
//        virtual bool operator() (uint4 filterRefCon, uint4 scanY,
//                                 uint4 scanWidth, COLOUR *theScan) const = 0;
//      };

    MEM_OUTPUT();
    MEM_OUTPUT(uint4 theWidth,   uint4 theHeight,
               OutputFilterFunc  theFilter,
               uint4             filterRefCon,
               void              *baseAddr,
               uint4 rowBytes,   uint4 pixelBytes,
               uint4 shiftRed,   uint4 maskRed,
               uint4 shiftGreen, uint4 maskGreen,
               uint4 shiftBlue,  uint4 maskBlue);
    virtual ~MEM_OUTPUT();

    virtual void Render () const;

    void Set_Resolution(uint4 theWidth,    uint4 theHeight);
    void Set_Filter(OutputFilterFunc       theFilter, uint4 filterRefCon);
    void Set_Image(void *baseAddr,         uint4 rowBytes, uint4 pixelBytes);
    void Set_RedFormat(uint4 shiftRed,     uint4 maskRed);
    void Set_GreenFormat(uint4 shiftGreen, uint4 maskGreen);
    void Set_BlueFormat(uint4 shiftBlue,   uint4 maskBlue);
  };

} // namespace RAYPP

#endif
