/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_TGA_OUTPUT_H
#define RAYPP_TGA_OUTPUT_H

#include "kernel/kernel.h"

namespace RAYPP {

class TGA_OUTPUT: public OUTPUT
  {
  private:
    uint4 xres, yres;
    float4 igamma;
    string filename;

  public:
    TGA_OUTPUT ();
    TGA_OUTPUT (uint4 xpix, uint4 ypix, const string& name,
                float4 gamma = float4(1.0));

    virtual void Init ();

    virtual void Render () const;

    void Set_Resolution (uint4 xpix, uint4 ypix);
    void Set_Gamma (float4 gam);
    void Set_Filename (const string &name);
  };

} // namespace RAYPP

#endif
