/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_RAYTRACER_H
#define RAYPP_RAYTRACER_H

#include "kernel/kernel.h"

namespace RAYPP {

class RAY;
class SHADING_INFO;

class RAYTRACER: public RENDERER
  {
  private:
    HANDLE<CAMERA> Camera;
    uint1 Max_Specular_Level, Samples;
    bool Shadow_Rays;

    COLOUR Trace_Light_Ray
      (const RAY &Ray, const COLOUR &Ingoing) const;

    COLOUR Get_Emitted_Light (const SHADING_INFO &Info) const;

  public:
    RAYTRACER ();

    virtual void Init ();
    virtual void Deinit ();

    virtual COLOUR Trace_Ray (const RAY &Ray) const;

    virtual COLOUR Get_Pixel (float8 u, float8 v, float8 du, float8 dv) const;
    virtual COLOUR Trace_Camera_Ray (float8 u, float8 v) const;
    virtual void Calc_Illumination (const VECTOR &Loc, const COLOUR &Imp,
      INCIDENT_ARRAY &Arr) const;

    void Add (const HANDLE<CAMERA> &Cam);

    void Set_Shadow_Rays (bool new_value);
    void Set_Samples (uint1 new_samples);
//    void Set_Max_Specular_Level (uint1);
  };

} // namespace RAYPP

#endif
