/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_TUBE_H
#define RAYPP_TUBE_H

#include "shapes/flat_shape.h"

namespace RAYPP {

class TUBE: public FLAT_SHAPE
  {
  private:
    STRANSFORM Trans;

    inline VECTOR Get_Normal (const VECTOR &rawnorm) const;

  public:
    TUBE () {}

    virtual void Init ();

    virtual void Transform (const TRANSFORM &Trans);

    virtual AXISBOX BBox () const;

    virtual bool Test (const GEOM_RAY &Ray, float8 &dist, bool &realhit) const;

    virtual bool Intersect
      (const GEOM_RAY &Ray, float8 &dist, VECTOR &Normal) const;
    virtual void All_Intersections (const GEOM_RAY &Ray,
      vector<INTER> &Inter) const;
  };

} // namespace RAYPP

#endif
