/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_LAMBERT_H
#define RAYPP_LAMBERT_H

#include "kernel/kernel.h"
#include "surfaces/pigments/pigment.h"

namespace RAYPP {

class LAMBERT: public SURFACE
  {
  private:
    HANDLE<PIGMENT> Pigment;

  public:
    LAMBERT ();
    LAMBERT (const HANDLE<PIGMENT> &pig);
    LAMBERT (const COLOUR &Col);

    virtual void Init ();

    virtual void Transform (const TRANSFORM &trans);

    virtual void Get_Full_Shading_Info (const SHADING_INFO &In,
      FULL_SHADING_INFO &Out) const;

    virtual COLOUR Get_Total_Importance (const FULL_SHADING_INFO &Info,
      const VECTOR & Dir) const;

    virtual VECTOR Get_MC_Reflected_Dir (const FULL_SHADING_INFO &Info)
      const;

    virtual VECTOR Get_MC_Refracted_Dir (const FULL_SHADING_INFO &Info)
      const;

    virtual VECTOR Get_MC_Diffuse_Dir (const FULL_SHADING_INFO &Info)
      const;

    virtual COLOUR Get_Emitted_Light (const FULL_SHADING_INFO &Info,
      const INCIDENT_ARRAY &Light, const COLOUR &Reflected,
      const COLOUR &Refracted, const INCIDENT_ARRAY &MC_Reflected,
      const INCIDENT_ARRAY &MC_Refracted, const INCIDENT_ARRAY &MC_Diffuse)
      const;

    virtual COLOUR Get_Transmitted_Light 
      (const SHADING_INFO &Info, const COLOUR &Ingoing) const;

    void Set_Pigment (const HANDLE<PIGMENT> &ThePig);
  };

} // namespace RAYPP

#endif
