/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_GENERIC_PIGMENT_H
#define RAYPP_GENERIC_PIGMENT_H

#include "kernel/kernel.h"
#include "utils/utils.h"
#include "surfaces/pigments/pigment.h"

namespace RAYPP {

class GENERIC_PIGMENT: public PIGMENT
  {
  private:
    COLOURMAP CMap;
    STRANSFORM Trans;
    HANDLE<CONVERTER<VECTOR,float8> > Conv;

  public:
    GENERIC_PIGMENT () {}
    GENERIC_PIGMENT (const HANDLE<CONVERTER<VECTOR, float8> >& Cnv);

    virtual void Transform (const TRANSFORM &);
    virtual COLOUR Get_Colour (const SHADING_INFO &) const;

    void Set_CMap (const COLOURMAP &);
    void Set_Conv (const HANDLE<CONVERTER<VECTOR, float8> >& Cnv);
  };

} // namespace RAYPP

#endif
