/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_STD_PIGMENTS_H
#define RAYPP_STD_PIGMENTS_H

#include "surfaces/pigments/solid_pigment.h"

namespace RAYPP {

class AGATE: public SOLID_PIGMENT
  {
  public:
    virtual COLOUR Get_Colour (const SHADING_INFO &) const;
  };

class BOZO: public SOLID_PIGMENT
  {
  public:
    virtual COLOUR Get_Colour (const SHADING_INFO &) const;
  };

class GRANITE: public SOLID_PIGMENT
  {
  public:
    virtual COLOUR Get_Colour (const SHADING_INFO &) const;
  };

class MARBLE: public SOLID_PIGMENT
  {
  public:
    virtual COLOUR Get_Colour (const SHADING_INFO &) const;
  };

class ONION: public SOLID_PIGMENT
  {
  public:
    virtual COLOUR Get_Colour (const SHADING_INFO &) const;
  };

class WOOD: public SOLID_PIGMENT
  {
  public:
    virtual COLOUR Get_Colour (const SHADING_INFO &) const;
  };

//MR: Derivation from SOLID_PIGMENT is not really needed here
//(CHECKER needs no turbulence and no colour map)
class CHECKER: public SOLID_PIGMENT
  {
  public:
    virtual COLOUR Get_Colour (const SHADING_INFO &) const;
  };

} // namespace RAYPP

#endif
