/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_FOG_H
#define RAYPP_FOG_H

#include "kernel/kernel.h"

namespace RAYPP {

class FOG: public VOLUME
  {
  private:
    COLOUR Colour;
    float4 Distance;
    float4 I_o_R;

  public:
    FOG ();
    FOG (const COLOUR &Col, float4 dist);

    virtual void Transform (const TRANSFORM &) {}

    virtual float8 Refractive_Index (const SHADING_INFO &) const
      { return I_o_R; }

    virtual COLOUR Calc_new_Importance (const RAY &Ray) const;

    virtual COLOUR Calc_Modified_Colour
      (const RAY &Ray, const COLOUR &Ingoing) const;

    virtual COLOUR Get_Attenuated_Light
      (const RAY &Ray, const COLOUR &Ingoing) const;

    void Set_Colour (const COLOUR &new_col);
    void Set_Distance (float4 new_dist);
    void Set_Refractive_Index (float4 new_index);
  };

} // namespace RAYPP

#endif
