/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_GAS2_H
#define RAYPP_GAS2_H

#include "kernel/kernel.h"

namespace RAYPP {

class GAS2: public VOLUME
  {
  public:
    enum phase_func {LAMBERT,ANISOTROPIC,RAYLEIGH};

    class OPACITY_FUNCTOR
      {
      public:
        virtual ~OPACITY_FUNCTOR () {}

        virtual COLOUR Get_Opacity (const VECTOR &Loc) const = 0;
      };

  private:
    STRANSFORM Trans;
    phase_func phase;
    HANDLE <OPACITY_FUNCTOR> Opacfunc;
    float4 min_step, max_step;
    float4 abs_tol, rel_tol;

    COLOUR Get_Contrib (const COLOUR &ActInt, const VECTOR &Interest,
      const VECTOR &dir) const;

    COLOUR Integrate_Opacity_Function(const VECTOR &Lower,
      const VECTOR &Higher, const COLOUR &Ingoing) const;

    COLOUR Phase_Function(const float4 cosangle) const;

  public:
    GAS2 ();
    GAS2 (phase_func ph, const HANDLE<OPACITY_FUNCTOR> &Opac);

    virtual void Init ();

    virtual void Transform (const TRANSFORM &trans);

    virtual float8 Refractive_Index (const SHADING_INFO &)  const
      { return float8(1.0); }

    virtual COLOUR Calc_new_Importance (const RAY &Ray) const;

    virtual COLOUR Calc_Modified_Colour
      (const RAY &Ray, const COLOUR &Ingoing) const;

    virtual COLOUR Get_Attenuated_Light
      (const RAY &Ray, const COLOUR &Ingoing) const;

    void Set_Phase (phase_func pf);

    void Set_Opacity (const HANDLE<OPACITY_FUNCTOR> &Opac);

    /*!
       Set the accuracy parameters for the integrations. <br>
       \a min_st, \a max_st:
         minimum and maximum step width during integration <br>
       \a abstol, \a reltol:
         the guessed error must be smaller than
         <tt> max (abstol, value*reltol)<tt> 
    */
    void Set_Constants (float4 min_st, float4 max_st,
                        float4 abstol, float4 reltol);
  };

} // namespace RAYPP

#endif

