/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_POV_HMAKER_H
#define RAYPP_POV_HMAKER_H

#include "kernel/kernel.h"
#include "worlds/hmakers/hmaker.h"
#include "worlds/hmakers/sort_entry.h"

namespace RAYPP {

class POV_HMAKER: public HMAKER
  {
  private:
    uint2 Bunching_Factor;

    void Find_Infinites (vector<HANDLE<OBJECT> > &Orig,
      vector<SORT_ENTRY> &Infinite, vector<SORT_ENTRY> &Finite) const;
    void Remerge (vector<SORT_ENTRY> &Infinite,
      vector<SORT_ENTRY> &Finite, vector<HANDLE<OBJECT> > &New) const;

    bool Find_Split (vector<SORT_ENTRY> &Arr,
                     uint4 Lo, uint4 Hi, int4 &Pos) const;
    void Split (vector<SORT_ENTRY> &In, uint4 Lo, uint4 Hi,
      vector<SORT_ENTRY> &Out) const;

  public:
    POV_HMAKER ()
      : Bunching_Factor (6) {}

    virtual void Init ();

    virtual void Build_Hierarchy (vector<HANDLE<OBJECT> > &Arr) const;

    void Set_Bunching_Factor (uint2 new_factor);
  };

} // namespace RAYPP

#endif
