/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_SORT_ENTRY_H
#define RAYPP_SORT_ENTRY_H

#include "kernel/kernel.h"

namespace RAYPP {

class SORT_ENTRY
  {
  public:
    HANDLE<OBJECT> Obj;
    HANDLE<AXISBOX> Box;
    HANDLE<VECTOR> Center;

    SORT_ENTRY () {}
    SORT_ENTRY (const HANDLE<OBJECT> &hnd)
      : Obj (hnd)
      {
      Box = HANDLE<AXISBOX> (Cnew AXISBOX (hnd->BBox()));
      Center = HANDLE<VECTOR> (Cnew VECTOR (Box->Center()));
      }
  };

} // namespace RAYPP

namespace std {

inline void swap (RAYPP::SORT_ENTRY &a, RAYPP::SORT_ENTRY &b)
  {
  swap (a.Obj, b.Obj);
  swap (a.Box, b.Box);
  swap (a.Center, b.Center);
  }

} // namespace std

#endif
