/*
 *  Ray++ - Object-oriented ray tracing library
 *  Copyright (C) 1998-2001 Martin Reinecke and others.
 *  See the AUTHORS file for more information.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  See the README file for more information.
 */

#ifndef RAYPP_SCENE_H
#define RAYPP_SCENE_H

#include "kernel/kernel.h"
#include "worlds/hmakers/hmaker.h"
#include "surfaces/pigments/pigment.h"

namespace RAYPP {

class SCENE: public WORLD
  {
  private:
    bool objects_ready;

    vector<HANDLE<OBJECT> > Object;
    vector<HANDLE<LIGHT> > Light;

    HANDLE<HMAKER> HMaker;
    HANDLE<PIGMENT> BackgroundPigment;

    void coi () const
      { if (!objects_ready) error ("Scene objects not yet initialized"); }
    void cnoi () const
      { if ( objects_ready) error ("Scene objects already initialized"); }

  public:
    SCENE ()
      : objects_ready (false) {}

    virtual void Init ();
    virtual void Deinit ();

    virtual void Get_Surrounding_Volume
      (const VECTOR &Loc, INSIDE_INFO &result) const;

    virtual bool Get_Next_Intersection
      (const RAY &Ray, float8 &dist, SHADING_INFO &result) const;

    virtual void Get_Lights
      (const VECTOR &Loc, LIGHT_ARRAY &result) const;

    virtual COLOUR Get_Background
      (const VECTOR &Dir) const;

    void Add (const HANDLE<OBJECT> &Obj);
    void Add (const HANDLE<LIGHT> &Lgt);

    void Set_HMaker (const HANDLE<HMAKER> &Hm);
    void Set_Background(const HANDLE<PIGMENT> &Pigment);
  };

} // namespace RAYPP

#endif
