
#====================================================================#
# svg/element.rb
#====================================================================#

#====================================================================#
# SVG Class
class SVG

  #==================================================================#
  # Element Class
  class Element

    #================================================================#
    # Initialize Method

    def initialize(&block)
      @style     = nil
      @class     = nil
      @transform = nil

      if block_given?
        instance_eval(&block)
      end
    end

    #================================================================#
    # Accessor

    attr_accessor :style, :class, :transform

    #================================================================#
    # Instance Methods

    def to_s
      text = ''
      text << %| style="#{@style}"|         if @style
      text << %| class="#{@class}"|         if @class
      text << %| transform="#{@transform}"| if @transform
      return text
    end

  end

  #==================================================================#
  # Group Class
  class Group < Element

    #================================================================#
    # Include Module

    include SVG::ArrayMixin

    #================================================================#
    # Initialize Method

    def initialize
      super()
      @elements = []
    end

    #================================================================#
    # Accessor

    attr_reader :elements

    #================================================================#
    # Instance Methods

    def array
      return @elements
    end
    private :array

    def to_s
     text = %|<g|
     text << super()
     text << %|>\n|
     text << @elements.collect { |element| element.to_s + "\n" }.join
     text << %|</g>\n|
    end

  end

  #==================================================================#
  # Rect Class
  class Rect < Element

    #================================================================#
    # Initialize Method

    def initialize(x, y, width, height, rx = nil, ry = nil)
      super()

      @x      = x
      @y      = y
      @width  = width
      @height = height
      @rx     = rx
      @ry     = ry
    end

    #================================================================#
    # Accessor

    attr_accessor :width, :height, :x, :y, :rx, :ry

    #================================================================#
    # Instance Methods

    def to_s
      text = %|<rect width="#{@width}" height="#{@height}"|
      text << %| x="#{@x}"|   if @x
      text << %| y="#{@y}"|   if @y
      text << %| rx="#{@rx}"| if @rx
      text << %| ry="#{@ry}"| if @ry
      text << super()
      text << %| />|
      return text
    end

  end

  #==================================================================#
  # Circle Class
  class Circle < Element

    #================================================================#
    # Initialize Method

    def initialize(cx, cy, r)
      super()

      @cx = cx
      @cy = cy
      @r  = r
    end

    #================================================================#
    # Accessor

    attr_accessor :cx, :cy, :r

    #================================================================#
    # Instance Methods

    def to_s
      text = %|<circle cx="#{@cx}" cy="#{@cy}" r="#{@r}"|
      text << super()
      text << %| />|
      return text
    end

  end

  #==================================================================#
  # Ellipse Class
  class Ellipse < Element

    #================================================================#
    # Initialize Method

    def initialize(cx, cy, rx, ry)
      super()

      @cx = cx
      @cy = cy
      @rx = rx
      @ry = ry
    end

    #================================================================#
    # Accessor

    attr_accessor :cx, :cy, :rx, :ry

    #================================================================#
    # Instance Methods

    def to_s
      text = %|<ellipse cx="#{@cx}" cy="#{@cy}" rx="#{@rx}" ry="#{@ry}"|
      text << super()
      text << %| />|
      return text
    end

  end

  #==================================================================#
  # Line Class
  class Line < Element

    #================================================================#
    # Initialize Method

    def initialize(x1, y1, x2, y2)
      super()
      @x1 = x1
      @y1 = y1
      @x2 = x2
      @y2 = y2
    end

    #================================================================#
    # Accessor

    attr_accessor :x1, :y1, :x2, :y2

    #================================================================#
    # Instance Methods

    def to_s
      text = %|<line x1="#{@x1}" y1="#{@y1}" x2="#{@x2}" y2="#{@y2}"|
      text << super()
      text << %| />|
      return text
    end

  end

  #==================================================================#
  # Polyline Class
  class Polyline < Element

    #================================================================#
    # Initialize Method

    def initialize(points)
      super()
      @points = points
    end

    #================================================================#
    # Accessor

    attr_accessor :points

    #================================================================#
    # Instance Methods

    def to_s
      text = %|<polyline points="#{@points.join(' ')}"|
      text << super()
      text << %| />|
      return text
    end

  end

  #==================================================================#
  # Polygon Class
  class Polygon < Element

    #================================================================#
    # Initialize Method

    def initialize(points)
      super()
      @points = points
    end

    #================================================================#
    # Accessor

    attr_accessor :points

    #================================================================#
    # Instance Methods

    def to_s
      text = %|<polygon points="#{@points.join(' ')}"|
      text << super()
      text << %| />|
      return text
    end

  end

  #==================================================================#
  # Image Class
  class Image < Element

    #================================================================#
    # Initialize Method

    def initialize(x, y, width, height, href)
      super()
      @x      = x
      @y      = y
      @width  = width
      @height = height
      @href   = href
    end

    #================================================================#
    # Accessor

    attr_accessor :x, :y, :width, :height, :href

    #================================================================#
    # Instance Methods

    def to_s
      text = %|<image|
      text << %| x="#{@x}"| if @x
      text << %| y="#{@y}"| if @y
      text << %| width="#{@width}"|
      text << %| height="#{@height}"|
      text << %| xlink:href="#{@href}"|
      text << super()
      text << %| />|
      return text
    end

  end

  #==================================================================#
  # Path Class
  class Path < Element

    #================================================================#
    # Initialize Method Method

    def initialize(path, length = nil)
      super()
      @path   = path
      @length = length
    end

    #================================================================#
    # Accessor

    attr_accessor :path, :length

    #================================================================#
    # Instance Methods

    def to_s
      text = %|<path d="#{@path.join(' ')}"|
      text = %| length="#{@length}"| if @length
      text << super()
      text << %| />|
      return text
    end

  end

  #==================================================================#
  # Text Class
  class Text < Element

    #================================================================#
    # Initialize Method Method

    def initialize(x, y, text)
      super()
      @x             = x
      @y             = y
      @text          = text
      @length        = nil
      @length_adjust = nil
    end

    #================================================================#
    # Accessor

    attr_accessor :x, :y, :text, :length, :length_adjust

    #================================================================#
    # Instance Methods

    def to_s
      svg =  %|<text|
      svg << %| x="#{@x}"|           if @x
      svg << %| y="#{@y}"|           if @y
      svg << %| textLength="#{@}"|   if @length
      svg << %| lengthAdjust="#{@}"| if @length_adjust
      svg << super()
      svg << %|>|
      svg << text
      svg << %|</text>|
      return svg
    end

=begin
    class Span
      def initialize
        @x      = nil
        @y      = nil
        @dx     = nil
        @dy     = nil
        @rotate = nil
        @length = nil
      end
    end

    class Ref
      def initialize
        @x      = nil
        @y      = nil
        @dx     = nil
        @dy     = nil
        @rotate = nil
        @href   = nil
      end
    end

    class Path
      def initialize
        @start_offset = nil
        @method       = nil
        @spacing      = nil
      end
    end
=end

  end

end

#====================================================================#
#====================================================================#
