
#==============================================================================#
# svg/misc.rb
#==============================================================================#

#==============================================================================#
# SVG Class
class SVG

  #============================================================================#
  # Point Class
  class Point

    #==========================================================================#
    # Initialize Method

    def initialize(x, y)
      @x = x
      @y = y
    end

    #==========================================================================#
    # Accessor

    attr_accessor :x, :y

    #==========================================================================#
    # Class Methods

    def self.[](*points)
      if points.size % 2 == 0
        return (0...(points.size / 2)).collect { |i|
          self.new(points[i * 2], points[i * 2 + 1])
        }
      else
        raise ArgumentError, 'odd number args for Point'
      end
    end

    #==========================================================================#
    # Instance Methods

    def to_s
      return "#{@x} #{@y}"
    end

  end # Point

  #============================================================================#
  # ArrayMixin Module
  module ArrayMixin

    #==========================================================================#
    # Include Module

    include Enumerable

    #==========================================================================#
    # Instance Methods

    def array
      raise NotImplementedError
    end
    private :array

    def [](index)
      array[index]
    end

    def []=(index, value)
      array[index] = value
    end

    def <<(other)
      array << other
    end

    def clear
      array.clear
    end

    def first
      array.first
    end

    def last
      array.last
    end

    def each(&block)
      array.each(&block)
    end

  end # ArrayMixin

end # SVG

#==============================================================================#
#==============================================================================#
