#!/usr/local/bin/python -O
''' 
threeDS.py - Python Module for loading and displaying 3DStudio format modules
Copyright (C) 2000-2001 Jason Petrone <jp@demonseed.net>
'''
blending = None
smoothing = None
# blending = 1
smoothing = 1
autospin = 0

import sys

from OpenGL.Tk import *
from OpenGL.GL import *
from OpenGL.GLUT import *

try:
  from OpenGL.Tk import *
  from OpenGL.GL import *
  from OpenGL.GLUT import *
except:
  print '''
ERROR: PyOpenGL is not installed properly.  This needs fixed for this program
       to continue.  PyOpenGL can be found at: http://pyopengl.sourceforge.net
        '''
  sys.exit()

#try:
import threeDS
#except:
#  print '''
#ERROR: Can't find the threeDS.py module that should have come with this 
#       program.  Please make sure it is within your Python path.
#        '''
#  sys.exit()

model = None


def draw(o):
  'OpenGL redraw callback'
  if model: model.draw()

def main():
  try:
    modelName = sys.argv[1]
  except:
    print '''
  ERROR: No model specified!
    '''
    sys.exit()


  global model, blending, smoothing
  o = Opengl(width = 640, height = 480, double = 1)

  print 'Loading ' + modelName
  global model
  model = threeDS.Scene(modelName)
  print modelName + ': ' + str(len(model.objects)) + ' objects, ' + str(len(model.materials.keys())) + ' materials, ' + str(len(model.lights)) + ' lights.'
  o.redraw  = draw
  o.pack(side = 'top', expand = 1, fill = 'both')
  if not model.lighting():
    print 'Using default lighting.'
    light_ambient =  [0.2, 0.2, 0.2, 1.0]
    light_diffuse =  [0.1, 0.1, 0.1, 1.0]
    light_specular =  [.1, .1, .1, .1]
    light_position =  [-37, -1, 15, 0]

    glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient)
    glLightfv(GL_LIGHT0, GL_DIFFUSE, light_diffuse)
    glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular)
    glLightfv(GL_LIGHT0, GL_POSITION, light_position)
    
    glEnable(GL_LIGHTING)
    glEnable(GL_LIGHT0)

  # use gray background
  o.set_background(.3, .3, .3)
  #o.set_eyepoint(1300)
  o.set_eyepoint(500)
  pt = model.objects[0].vertices[0]
  o.set_centerpoint(pt[0], pt[1], pt[2])

  # enable autospin with middle click
  if autospin: o.autospin_allowed = 1

  # set back clipping plane WAY back
  o.far = 20000

  if smoothing: 
    glShadeModel(GL_SMOOTH)
  else: 
    glShadeModel(GL_FLAT)

  glEnable(GL_TEXTURE_2D)
  glLightModel(GL_LIGHT_MODEL_TWO_SIDE, 1)

  if blending:
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  else:
    glDisable(GL_BLEND)

  o.mainloop()

main()
