//
// BuildingArray.h
//
// Copyright (c) 2001 Virtual Terrain Project
// Free for all uses, see license.txt for details.
//

#ifndef BUILDINGARRAYH
#define BUILDINGARRAYH

#include "MathTypes.h"
#include "Projections.h"
#include "Building.h"
#include <stdio.h>

#define BCFVERSION_CURRENT		1.2f
#define BCFVERSION_SUPPORTED	1.1f

// BCF file format version history
//
// 1.0 first version, just a list of xy floats
// 1.1 first numbered version, real structure with flexible number of fields
// 1.2 added utm_zone field at top of file

/*****
 *
 * Name: vtBuildingArray
 * Parent: Array<vtBuildingPtr>
 *
 * Description:
 *	Array of Buildings
 *
 *****/
class vtBuildingArray : public Array<vtBuildingPtr>
{
public:
	~vtBuildingArray() { Empty(); }
	virtual void DestructItems(int first, int last);	// override

	void AddBuilding(vtBuildingPtr bld) { Append(bld); }
	void Remove(int index, DPoint2 &thepoint)	// remove a specific coordinate
	{
		// grab the point out of the array
		thepoint = GetAt(index)->GetLocation();
		RemoveAt(index, 1);
	}
	void DeleteSelected();

	bool ReadSHP(const char* pathname);
	bool ReadBCF(const char* pathname);			// read a .bcf file
	bool WriteSHP(const char* pathname);
	bool WriteBCF(const char* pathname);		// write to a .bcf file
	bool ReadBCF_Old(FILE *fp);

	int IsBuildingThere(DPoint2 point, double error);//checks to see if a coordinate (within
													//the given spatial error) is in the array
	bool FindClosestCorner(DPoint2 point, double error,
						   int &building, int &corner, double &distance);
	bool FindClosestCenter(DPoint2 point, double error,
						   int &building, double &distance);

	bool IsEmpty() { return (GetSize() == 0); }
	void GetExtents(DRECT &ext);

	// selection
	int NumSelected();
	void DeselectAll();

	// override this so that the BuildingArray base methods can be capable
	// of handling subclasses of vtBuilding
	virtual vtBuilding *NewBuilding() { return new vtBuilding; }
//	vtBuilding *GetBuilding(int i) { return GetAt(i); }

	vtProjection m_proj;
protected:
};

#endif
