//
// LodGrid.h
//
// Copyright (c) 2001 Virtual Terrain Project
// Free for all uses, see license.txt for details.
//

#ifndef LODGRIDH
#define LODGRIDH

#include "HeightField.h"

class vtLodGrid : public vtGroup
{
public:
	vtLodGrid(FPoint3 &origin, FPoint3 &size,
		int iDimension, float fLODDistance, vtHeightField *pHF = NULL);
	~vtLodGrid();

	// methods
	void AppendToGrid(vtTransform *pModel);
	void AppendToGrid(vtGeom *pModel);

	void AllocateCell(int a, int b);
	void DetermineCell(const FPoint3 &pos, int &a, int &b);

protected:
	FPoint3 m_origin;
	FPoint3 m_size;
	FPoint3 m_step;

	int m_dim;
	float m_fLODDistance;
	vtLOD **m_pCells;
	vtHeightField *m_pHeightField;
};

#endif
